/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.animation.gun;

import com.craftingdead.core.item.animation.IAnimationController;
import com.craftingdead.core.item.animation.gun.GunAnimation;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;

public class GunAnimationController
implements IAnimationController {
    private final Queue<Pair<GunAnimation, Runnable>> animations = new LinkedList<Pair<GunAnimation, Runnable>>();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private int ticks;

    @Override
    public void tick(LivingEntity livingEntity, ItemStack itemStack) {
        Pair<GunAnimation, Runnable> animation = this.animations.peek();
        if (animation != null) {
            ++this.ticks;
            float progress = MathHelper.func_76131_a((float)((float)this.ticks / (((GunAnimation)animation.getLeft()).getMaxAnimationTick() * 1.5f)), (float)0.0f, (float)1.0f);
            ((GunAnimation)animation.getLeft()).onUpdate(this.minecraft, livingEntity, itemStack, progress);
            if (progress >= 1.0f) {
                if (animation.getRight() != null) {
                    ((Runnable)animation.getRight()).run();
                }
                this.removeCurrentAnimation();
            }
        }
    }

    @Override
    public void applyTransforms(LivingEntity livingEntity, ItemStack itemStack, String part, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, float partialTicks) {
        Pair<GunAnimation, Runnable> animationPair = this.animations.peek();
        if (animationPair != null && ((GunAnimation)animationPair.getLeft()).isAcceptedTransformType(transformType)) {
            ((GunAnimation)animationPair.getLeft()).applyTransforms(livingEntity, itemStack, part, matrixStack, partialTicks);
        }
    }

    public void addAnimation(GunAnimation animation, Runnable callback) {
        this.animations.add((Pair<GunAnimation, Runnable>)Pair.of((Object)animation, (Object)callback));
    }

    public void removeCurrentAnimation() {
        this.animations.poll();
        this.ticks = 0;
    }

    public void clearAnimations() {
        this.animations.clear();
    }
}

