/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.gun;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.enchantment.ModEnchantments;
import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.hat.IHat;
import com.craftingdead.core.inventory.CraftingInventorySlotType;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.item.AttachmentItem;
import com.craftingdead.core.item.animation.gun.AnimationType;
import com.craftingdead.core.item.animation.gun.GunAnimation;
import com.craftingdead.core.item.combatslot.CombatSlotType;
import com.craftingdead.core.item.gun.AbstractGunType;
import com.craftingdead.core.item.gun.FireMode;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.item.gun.IGunClient;
import com.craftingdead.core.item.gun.PendingHit;
import com.craftingdead.core.item.gun.ammoprovider.AmmoProviderType;
import com.craftingdead.core.item.gun.ammoprovider.IAmmoProvider;
import com.craftingdead.core.item.gun.magazine.IMagazine;
import com.craftingdead.core.living.EntitySnapshot;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.living.IPlayer;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.HitMessage;
import com.craftingdead.core.network.message.play.RightMouseAction;
import com.craftingdead.core.network.message.play.SetFireModeMessage;
import com.craftingdead.core.network.message.play.TriggerPressedMessage;
import com.craftingdead.core.network.util.NetworkDataManager;
import com.craftingdead.core.util.ModDamageSource;
import com.craftingdead.core.util.ModSoundEvents;
import com.craftingdead.core.util.RayTraceUtil;
import com.craftingdead.core.util.Text;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.UnbreakingEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.CombatRules;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGun<T extends AbstractGunType<SELF>, SELF extends AbstractGun<T, SELF>>
implements IGun,
INBTSerializable<CompoundNBT> {
    private static final Logger logger = LogManager.getLogger();
    private static final AtomicIntegerFieldUpdater<AbstractGun> triggerPressedUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractGun.class, "triggerPressed");
    private static final int BASE_SNAPSHOT_TICK_OFFSET = 3;
    public static final float HEADSHOT_MULTIPLIER = 4.0f;
    public static final byte HIT_VALIDATION_DELAY_TICKS = 3;
    private static final Random random = new Random();
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gun-pool-%s").setDaemon(true).build());
    private static final DataParameter<ItemStack> PAINT_STACK = new DataParameter(1, DataSerializers.field_187196_f);
    private final NetworkDataManager dataManager = new NetworkDataManager();
    protected final T type;
    protected final ItemStack gunStack;
    @Deprecated
    private volatile int triggerPressed;
    private boolean wasTriggerPressed;
    private int triggerPressedTicks;
    protected long lastShotMs = Integer.MIN_VALUE;
    private FireMode fireMode;
    private int shotCount;
    private Set<AttachmentItem> attachments;
    private boolean attachmentsDirty;
    private final Iterator<FireMode> fireModeInfiniteIterator;
    private boolean performingRightMouseAction;
    private final IGunClient client;
    private volatile long lastTickMs;
    private IAmmoProvider ammoProvider;
    private boolean ammoProviderChanged;

    public AbstractGun(T type, ItemStack gunStack) {
        this.type = type;
        this.gunStack = gunStack;
        this.fireModeInfiniteIterator = Iterables.cycle(((AbstractGunType)this.type).getFireModes()).iterator();
        this.fireMode = this.fireModeInfiniteIterator.next();
        this.client = (IGunClient)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> type.getClientFactory().apply(this));
        GunEvent.Initialize event = new GunEvent.Initialize(this, gunStack, ((AbstractGunType)type).createAmmoProvider());
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.setAmmoProvider(event.getAmmoProvider());
        this.attachments = new HashSet<AttachmentItem>(event.getAttachments());
        this.dataManager.register(PAINT_STACK, ItemStack.field_190927_a);
    }

    public T getType() {
        return this.type;
    }

    @Override
    public void tick(ILiving<?, ?> living) {
        this.lastTickMs = Util.func_211177_b();
        if (!((LivingEntity)living.getEntity()).field_70170_p.func_201670_d() && !this.isTriggerPressed() && this.wasTriggerPressed) {
            this.triggerPressedTicks = living.getEntity().func_184102_h().func_71259_af();
        }
        this.wasTriggerPressed = this.isTriggerPressed();
        if (this.isPerformingRightMouseAction() && living.getEntity().func_70051_ag()) {
            this.setPerformingRightMouseAction(living, false, true);
        }
        if (((LivingEntity)living.getEntity()).field_70170_p.func_201670_d()) {
            this.client.handleTick(living);
        }
    }

    @Override
    public void reset(ILiving<?, ?> living) {
        this.setTriggerPressed(living, false, false);
        if (this.performingRightMouseAction) {
            this.setPerformingRightMouseAction(living, false, false);
        }
    }

    @Override
    public void setTriggerPressed(ILiving<?, ?> living, boolean triggerPressed, boolean sendUpdate) {
        if (triggerPressed && (!this.canShoot(living) || MinecraftForge.EVENT_BUS.post((Event)new GunEvent.TriggerPressed(this, this.gunStack, living)))) {
            return;
        }
        this.setTriggerPressed(triggerPressed);
        if (this.isTriggerPressed()) {
            executorService.execute(() -> {
                while (this.isTriggerPressed() && Util.func_211177_b() - this.lastTickMs < 500L) {
                    this.tryShoot(living);
                }
            });
        } else {
            this.shotCount = 0;
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = ((LivingEntity)living.getEntity()).field_70170_p.func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new TriggerPressedMessage(living.getEntity().func_145782_y(), triggerPressed));
        }
    }

    @Override
    public boolean isTriggerPressed() {
        return triggerPressedUpdater.get(this) != 0;
    }

    private void setTriggerPressed(boolean triggerPressed) {
        triggerPressedUpdater.set(this, triggerPressed ? 1 : 0);
    }

    @Override
    public void validatePendingHit(IPlayer<ServerPlayerEntity> player, ILiving<?, ?> hitLiving, PendingHit pendingHit) {
        EntitySnapshot hitSnapshot;
        EntitySnapshot playerSnapshot;
        byte tickOffset = pendingHit.getTickOffset();
        if (tickOffset > 3) {
            logger.warn("Bad living hit packet received, tick offset is too big!");
            return;
        }
        int latencyTicks = ((ServerPlayerEntity)player.getEntity()).field_71138_i / 1000 * 20 + tickOffset;
        int tick = ((ServerPlayerEntity)player.getEntity()).func_184102_h().func_71259_af();
        if (tick - latencyTicks > this.triggerPressedTicks && !this.isTriggerPressed()) {
            return;
        }
        try {
            playerSnapshot = player.getSnapshot(tick - latencyTicks).combineUntrustedSnapshot(pendingHit.getPlayerSnapshot());
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        try {
            hitSnapshot = hitLiving.getSnapshot(tick - latencyTicks - 3).combineUntrustedSnapshot(pendingHit.getHitSnapshot());
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        if (!hitLiving.getEntity().func_233643_dh_()) {
            random.setSeed(pendingHit.getRandomSeed());
            hitSnapshot.rayTrace(((ServerPlayerEntity)player.getEntity()).field_70170_p, playerSnapshot, ((AbstractGunType)this.type).getRange(), this.getAccuracy(player), this.shotCount, random).ifPresent(hitPos -> this.hitEntity((ILiving<?, ?>)player, (Entity)hitLiving.getEntity(), (Vector3d)hitPos, false));
        }
    }

    private boolean canShoot(ILiving<?, ?> living) {
        return !living.getProgressMonitor().isPresent() && !living.getEntity().func_70051_ag() && !living.getEntity().func_175149_v() && ((AbstractGunType)this.type).getTriggerPredicate().test(this);
    }

    protected void processShot(ILiving<?, ?> living, ThreadTaskExecutor<?> executor) {
        int unbreakingLevel;
        Object entity = living.getEntity();
        if (!(((Entity)entity).field_70170_p.func_201670_d() || living.getEntity() instanceof PlayerEntity && ((PlayerEntity)living.getEntity()).func_184812_l_() || UnbreakingEnchantment.func_92097_a((ItemStack)this.gunStack, (int)(unbreakingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)this.gunStack)), (Random)random))) {
            this.ammoProvider.getExpectedMagazine().decrementSize();
        }
        RayTraceResult lastRayTraceResult = null;
        for (int i = 0; i < ((AbstractGunType)this.type).getBulletAmountToFire(); ++i) {
            long randomSeed = ((Entity)entity).field_70170_p.func_82737_E() + (long)i;
            random.setSeed(randomSeed);
            RayTraceResult rayTraceResult = CompletableFuture.supplyAsync(() -> RayTraceUtil.rayTrace(entity, ((AbstractGunType)this.type).getRange(), this.getAccuracy(living), this.shotCount, random).orElse(null), executor).join();
            if (rayTraceResult == null) continue;
            switch (rayTraceResult.func_216346_c()) {
                case BLOCK: {
                    BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
                    boolean playSound = lastRayTraceResult instanceof BlockRayTraceResult ? ((Entity)entity).field_70170_p.func_180495_p(((BlockRayTraceResult)lastRayTraceResult).func_216350_a()) != ((Entity)entity).field_70170_p.func_180495_p(blockRayTraceResult.func_216350_a()) : true;
                    executor.execute(() -> this.hitBlock(living, (BlockRayTraceResult)rayTraceResult, playSound && entity.field_70170_p.func_201670_d()));
                    break;
                }
                case ENTITY: {
                    EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
                    if (!entityRayTraceResult.func_216348_a().func_70089_S() || entityRayTraceResult.func_216348_a() instanceof ServerPlayerEntity && entity instanceof ServerPlayerEntity) break;
                    if (((Entity)entity).field_70170_p.func_201670_d()) {
                        this.client.handleHitEntityPre(living, entityRayTraceResult.func_216348_a(), entityRayTraceResult.func_216347_e(), randomSeed);
                    }
                    boolean playEntityHitSound = !(lastRayTraceResult instanceof EntityRayTraceResult) || !((EntityRayTraceResult)lastRayTraceResult).func_216348_a().func_200600_R().getRegistryName().equals((Object)entityRayTraceResult.func_216348_a().func_200600_R().getRegistryName()) && ((Entity)entity).field_70170_p.func_201670_d();
                    executor.execute(() -> this.hitEntity(living, entityRayTraceResult.func_216348_a(), entityRayTraceResult.func_216347_e(), playEntityHitSound));
                    break;
                }
            }
            lastRayTraceResult = rayTraceResult;
        }
    }

    private void tryShoot(ILiving<?, ?> living) {
        if (!this.canShoot(living)) {
            this.setTriggerPressed(false);
            return;
        }
        LogicalSide side = ((LivingEntity)living.getEntity()).field_70170_p.func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
        ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(side);
        if (this.ammoProvider.getMagazine().map(IMagazine::getSize).orElse(0) <= 0) {
            if (side.isServer()) {
                executor.execute(() -> {
                    living.getEntity().func_184185_a((SoundEvent)ModSoundEvents.DRY_FIRE.get(), 1.0f, 1.0f);
                    this.ammoProvider.reload(living);
                });
            }
            this.setTriggerPressed(false);
            return;
        }
        boolean isMaxShotsReached = this.fireMode.getMaxShots().map(max -> this.shotCount >= max).orElse(false);
        if (isMaxShotsReached) {
            return;
        }
        ++this.shotCount;
        this.lastShotMs = Util.func_211177_b();
        this.processShot(living, executor);
        if (side == LogicalSide.CLIENT) {
            this.client.handleShoot(living);
        }
        Thread.yield();
        try {
            Thread.sleep(((AbstractGunType)this.type).getFireDelayMs());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void hitEntity(ILiving<?, ?> living, Entity hitEntity, Vector3d hitPos, boolean playSound) {
        GunEvent.HitEntity event;
        Object entity = living.getEntity();
        World world = hitEntity.field_70170_p;
        float damage = ((AbstractGunType)this.type).getDamage();
        float armorPenetration = Math.min((1.0f + (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.ARMOR_PENETRATION.get()), (ItemStack)this.gunStack) / 255.0f) * this.ammoProvider.getExpectedMagazine().getArmorPenetration(), 1.0f);
        if (armorPenetration > 0.0f && hitEntity instanceof LivingEntity) {
            LivingEntity livingEntityHit = (LivingEntity)hitEntity;
            float reducedDamage = damage - CombatRules.func_189427_a((float)damage, (float)livingEntityHit.func_70658_aO(), (float)((float)livingEntityHit.func_110148_a(Attributes.field_233827_j_).func_111126_e()));
            damage += reducedDamage * armorPenetration;
        }
        boolean headshot = false;
        if (hitEntity instanceof LivingEntity) {
            ILiving<LivingEntity, ?> hitLiving = ILiving.getExpected((LivingEntity)hitEntity);
            double chinHeight = hitEntity.func_226278_cu_() + (double)hitEntity.func_70047_e() - (double)0.2f;
            boolean bl = headshot = (hitEntity instanceof PlayerEntity || hitEntity instanceof ZombieEntity || hitEntity instanceof SkeletonEntity || hitEntity instanceof CreeperEntity || hitEntity instanceof EndermanEntity || hitEntity instanceof WitchEntity || hitEntity instanceof VillagerEntity || hitEntity instanceof VindicatorEntity || hitEntity instanceof WanderingTraderEntity) && hitPos.field_72448_b >= chinHeight;
            if (headshot) {
                damage *= 4.0f * (1.0f - hitLiving.getItemHandler().getStackInSlot(InventorySlotType.HAT.getIndex()).getCapability(ModCapabilities.HAT).map(IHat::getHeadshotReductionPercentage).orElse(Float.valueOf(0.0f)).floatValue());
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new GunEvent.HitEntity(this, this.gunStack, living, hitEntity, damage, hitPos, headshot)))) {
            return;
        }
        damage = event.getDamage();
        headshot = event.isHeadshot();
        if (world.func_201670_d()) {
            this.client.handleHitEntityPost(living, hitEntity, hitPos, playSound, headshot);
        } else {
            hitEntity.field_70172_ad = 0;
            ModDamageSource.causeDamageWithoutKnockback(hitEntity, ModDamageSource.causeGunDamage(entity, this.gunStack, headshot), damage);
            AbstractGun.checkCreateExplosion(this.gunStack, entity, hitPos);
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)this.gunStack) > 0) {
                hitEntity.func_70015_d(100);
            }
            if (hitEntity instanceof LivingEntity) {
                LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
                if (entity instanceof ServerPlayerEntity) {
                    boolean dead = hitLivingEntity.func_233643_dh_();
                    NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new HitMessage(hitPos, dead));
                }
            }
        }
    }

    private void hitBlock(ILiving<?, ?> living, BlockRayTraceResult rayTrace, boolean playSound) {
        World world;
        Object entity = living.getEntity();
        BlockPos blockPos = rayTrace.func_216350_a();
        BlockState blockState = ((LivingEntity)entity).field_70170_p.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        GunEvent.HitBlock event = new GunEvent.HitBlock(this, this.gunStack, block, blockPos, living, world = ((LivingEntity)entity).field_70170_p);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (world.func_201670_d()) {
            this.client.handleHitBlock(living, rayTrace, playSound);
        } else {
            if (blockState.func_177230_c() instanceof BellBlock) {
                ((BellBlock)blockState.func_177230_c()).func_226884_a_(world, blockState, rayTrace, entity instanceof PlayerEntity ? (PlayerEntity)entity : null, playSound);
            }
            if (block instanceof TNTBlock) {
                block.catchFire(blockState, ((LivingEntity)entity).field_70170_p, blockPos, null, entity instanceof LivingEntity ? entity : null);
                ((LivingEntity)entity).field_70170_p.func_217377_a(blockPos, false);
            }
            AbstractGun.checkCreateExplosion(this.gunStack, entity, rayTrace.func_216347_e());
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)this.gunStack) > 0) {
                if (CampfireBlock.func_241470_h_((BlockState)blockState)) {
                    world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
                } else {
                    BlockPos faceBlockPos = blockPos.func_177972_a(rayTrace.func_216354_b());
                    if (AbstractFireBlock.func_241465_a_((World)world, (BlockPos)faceBlockPos, (Direction)entity.func_174811_aO())) {
                        BlockState blockstate1 = AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)faceBlockPos);
                        world.func_180501_a(faceBlockPos, blockstate1, 11);
                    }
                }
            }
        }
    }

    @Override
    public float getAccuracy(ILiving<?, ?> living) {
        float accuracy = ((AbstractGunType)this.type).getAccuracyPct() * this.getAttachmentMultiplier(AttachmentItem.MultiplierType.ACCURACY);
        return Math.min(living.getModifiedAccuracy(accuracy, random), 1.0f);
    }

    @Override
    public Set<AttachmentItem> getAttachments() {
        return ImmutableSet.copyOf(this.attachments);
    }

    @Override
    public void setAttachments(Set<AttachmentItem> attachments) {
        this.attachments = attachments;
    }

    @Override
    public ItemStack getPaintStack() {
        return this.dataManager.get(PAINT_STACK);
    }

    @Override
    public void setPaintStack(ItemStack paintStack) {
        this.dataManager.set(PAINT_STACK, paintStack);
    }

    @Override
    public boolean isAcceptedPaintOrAttachment(ItemStack itemStack) {
        return itemStack != null && (((AbstractGunType)this.type).getAcceptedAttachments().contains(itemStack.func_77973_b()) || ((AbstractGunType)this.type).getAcceptedPaints().contains(itemStack.func_77973_b()));
    }

    @Override
    public void toggleFireMode(ILiving<?, ?> living, boolean sendUpdate) {
        if (this.fireModeInfiniteIterator.hasNext()) {
            this.setFireMode(living, this.fireModeInfiniteIterator.next(), sendUpdate);
        }
    }

    @Override
    public void setFireMode(ILiving<?, ?> living, FireMode fireMode, boolean sendUpdate) {
        this.fireMode = fireMode;
        living.getEntity().func_184185_a((SoundEvent)ModSoundEvents.TOGGLE_FIRE_MODE.get(), 1.0f, 1.0f);
        if (living.getEntity() instanceof PlayerEntity) {
            ((PlayerEntity)living.getEntity()).func_146105_b((ITextComponent)Text.translate("message.switch_fire_mode", Text.translate(this.fireMode.getTranslationKey(), new Object[0])), true);
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = ((LivingEntity)living.getEntity()).field_70170_p.func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new SetFireModeMessage(living.getEntity().func_145782_y(), this.fireMode));
        }
    }

    @Override
    public boolean hasCrosshair() {
        return ((AbstractGunType)this.type).hasCrosshair();
    }

    @Override
    public boolean isPerformingRightMouseAction() {
        return this.performingRightMouseAction;
    }

    @Override
    public void setPerformingRightMouseAction(ILiving<?, ?> living, boolean performingRightMouseAction, boolean sendUpdate) {
        if (performingRightMouseAction && living.getEntity().func_70051_ag()) {
            return;
        }
        boolean bl = this.performingRightMouseAction = !this.performingRightMouseAction;
        if (((LivingEntity)living.getEntity()).field_70170_p.func_201670_d()) {
            this.client.handleToggleRightMouseAction(living);
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = ((LivingEntity)living.getEntity()).field_70170_p.func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new RightMouseAction(living.getEntity().func_145782_y(), this.performingRightMouseAction));
        }
    }

    @Override
    public IGun.RightMouseActionTriggerType getRightMouseActionTriggerType() {
        return ((AbstractGunType)this.type).getRightMouseActionTriggerType();
    }

    @Override
    public Optional<SoundEvent> getReloadSound() {
        return ((AbstractGunType)this.type).getReloadSound();
    }

    @Override
    public int getReloadDurationTicks() {
        return ((AbstractGunType)this.type).getReloadDurationTicks();
    }

    @Override
    public boolean hasIronSight() {
        for (AttachmentItem attachmentItem : this.attachments) {
            if (attachmentItem.getInventorySlot() != CraftingInventorySlotType.OVERBARREL_ATTACHMENT) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<GunAnimation> getAnimation(AnimationType animationType) {
        return Optional.ofNullable(((AbstractGunType)this.type).getAnimations().get((Object)animationType)).map(Supplier::get);
    }

    @Override
    public int getShotCount() {
        return this.shotCount;
    }

    @Override
    public FireMode getFireMode() {
        return this.fireMode;
    }

    @Override
    public IGunClient getClient() {
        return this.client;
    }

    @Override
    public IAmmoProvider getAmmoProvider() {
        return this.ammoProvider;
    }

    @Override
    public void setAmmoProvider(IAmmoProvider ammoProvider) {
        this.ammoProvider = ammoProvider;
        this.ammoProviderChanged = true;
    }

    @Override
    public Set<? extends Item> getAcceptedMagazines() {
        return ((AbstractGunType)this.type).getAcceptedMagazines();
    }

    @Override
    public ItemStack getDefaultMagazineStack() {
        return ((AbstractGunType)this.type).getDefaultMagazine().get().func_190903_i();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("ammoProviderType", this.ammoProvider.getType().getRegistryName().toString());
        nbt.func_218657_a("ammoProvider", this.ammoProvider.serializeNBT());
        ListNBT attachmentsTag = this.attachments.stream().map(attachment -> StringNBT.func_229705_a_((String)attachment.getRegistryName().toString())).collect(ListNBT::new, AbstractList::add, List::addAll);
        nbt.func_218657_a("attachments", (INBT)attachmentsTag);
        nbt.func_218657_a("paintStack", (INBT)this.getPaintStack().serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("ammoProviderType", 8)) {
            this.setAmmoProvider(((AmmoProviderType)GameRegistry.findRegistry(AmmoProviderType.class).getValue(new ResourceLocation(nbt.func_74779_i("ammoProviderType")))).create());
            this.ammoProvider.deserializeNBT((INBT)nbt.func_74775_l("ammoProvider"));
            this.ammoProviderChanged = true;
        }
        this.setAttachments(nbt.func_150295_c("attachments", 8).stream().map(tag -> (AttachmentItem)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_150285_a_()))).collect(Collectors.toSet()));
        this.setPaintStack(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("paintStack")));
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        NetworkDataManager.writeEntries(writeAll ? this.dataManager.getAll() : this.dataManager.getDirty(), out);
        if (writeAll || this.attachmentsDirty) {
            out.func_150787_b(this.attachments.size());
            for (Item item : this.attachments) {
                out.writeRegistryId((IForgeRegistryEntry)item);
            }
        } else {
            out.func_150787_b(-1);
        }
        this.attachmentsDirty = false;
        if (this.ammoProviderChanged || writeAll) {
            out.writeBoolean(true);
            out.writeRegistryId((IForgeRegistryEntry)this.ammoProvider.getType());
        } else {
            out.writeBoolean(false);
        }
        this.ammoProvider.encode(out, this.ammoProviderChanged || writeAll);
        this.ammoProviderChanged = false;
    }

    @Override
    public void decode(PacketBuffer in) {
        this.dataManager.setEntryValues(NetworkDataManager.readEntries(in));
        int size = in.func_150792_a();
        if (size > -1) {
            this.attachments.clear();
            for (int i = 0; i < size; ++i) {
                this.attachments.add((AttachmentItem)in.readRegistryIdSafe(Item.class));
            }
        }
        if (in.readBoolean()) {
            this.ammoProvider = ((AmmoProviderType)in.readRegistryIdSafe(AmmoProviderType.class)).create();
        }
        this.ammoProvider.decode(in);
    }

    @Override
    public boolean requiresSync() {
        return this.attachmentsDirty || this.dataManager.isDirty() || this.ammoProvider.requiresSync();
    }

    @Override
    public CombatSlotType getSlotType() {
        return ((AbstractGunType)this.type).getCombatSlotType();
    }

    private static void checkCreateExplosion(ItemStack magazineStack, Entity entity, Vector3d position) {
        float explosionSize = (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)magazineStack) / (float)Enchantments.field_185309_u.func_77325_b();
        if (explosionSize > 0.0f) {
            entity.field_70170_p.func_217385_a(entity, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), explosionSize, Explosion.Mode.NONE);
        }
    }
}

