/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.gun;

import com.craftingdead.core.item.AttachmentItem;
import com.craftingdead.core.item.MagazineItem;
import com.craftingdead.core.item.PaintItem;
import com.craftingdead.core.item.animation.gun.AnimationType;
import com.craftingdead.core.item.animation.gun.GunAnimation;
import com.craftingdead.core.item.combatslot.CombatSlotType;
import com.craftingdead.core.item.gun.AbstractGun;
import com.craftingdead.core.item.gun.FireMode;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.item.gun.IGunClient;
import com.craftingdead.core.item.gun.ammoprovider.IAmmoProvider;
import com.craftingdead.core.item.gun.ammoprovider.MagazineAmmoProvider;
import com.craftingdead.core.item.gun.simple.SimpleGunClient;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class AbstractGunType<T extends AbstractGun<?, ?>> {
    private final int fireDelayMs;
    private final int damage;
    private final int reloadDurationTicks;
    private final float accuracyPct;
    private final int bulletAmountToFire;
    private final boolean crosshair;
    private final Set<FireMode> fireModes;
    private final Supplier<SoundEvent> shootSound;
    private final Supplier<SoundEvent> distantShootSound;
    private final Supplier<SoundEvent> silencedShootSound;
    private final Supplier<SoundEvent> reloadSound;
    private final Map<AnimationType, Supplier<GunAnimation>> animations;
    private final Set<Supplier<MagazineItem>> acceptedMagazines;
    private final Supplier<MagazineItem> defaultMagazine;
    private final Set<Supplier<AttachmentItem>> acceptedAttachments;
    private final Set<Supplier<PaintItem>> acceptedPaints;
    private final IGun.RightMouseActionTriggerType rightMouseActionTriggerType;
    private final Predicate<IGun> triggerPredicate;
    private final Supplier<SoundEvent> rightMouseActionSound;
    private final long rightMouseActionSoundRepeatDelayMs;
    private final double range;
    private final CombatSlotType combatSlotType;
    private final Function<T, ? extends IGunClient> clientFactory;

    protected AbstractGunType(Builder<T, ?> builder) {
        this.fireDelayMs = ((Builder)builder).fireDelayMs;
        this.damage = ((Builder)builder).damage;
        this.reloadDurationTicks = ((Builder)builder).reloadDurationTicks;
        this.accuracyPct = ((Builder)builder).accuracy;
        this.bulletAmountToFire = ((Builder)builder).bulletAmountToFire;
        this.crosshair = ((Builder)builder).crosshair;
        this.fireModes = ((Builder)builder).fireModes;
        this.shootSound = ((Builder)builder).shootSound;
        this.distantShootSound = ((Builder)builder).distantShootSound;
        this.silencedShootSound = ((Builder)builder).silencedShootSound;
        this.reloadSound = ((Builder)builder).reloadSound;
        this.animations = ((Builder)builder).animations;
        this.acceptedMagazines = ((Builder)builder).acceptedMagazines;
        this.defaultMagazine = ((Builder)builder).defaultMagazine;
        this.acceptedAttachments = ((Builder)builder).acceptedAttachments;
        this.acceptedPaints = ((Builder)builder).acceptedPaints;
        this.rightMouseActionTriggerType = ((Builder)builder).rightMouseActionTriggerType;
        this.triggerPredicate = ((Builder)builder).triggerPredicate;
        this.rightMouseActionSound = ((Builder)builder).rightMouseActionSound;
        this.rightMouseActionSoundRepeatDelayMs = ((Builder)builder).rightMouseActionSoundRepeatDelayMs;
        this.range = ((Builder)builder).range;
        this.combatSlotType = ((Builder)builder).combatSlotType;
        this.clientFactory = ((Builder)builder).clientFactory;
    }

    public Function<T, ? extends IGunClient> getClientFactory() {
        return this.clientFactory;
    }

    public abstract ICapabilityProvider createCapabilityProvider(ItemStack var1);

    public int getFireDelayMs() {
        return this.fireDelayMs;
    }

    public int getFireRateRPM() {
        return 60000 / this.getFireDelayMs();
    }

    public float getDamage() {
        return this.damage;
    }

    public int getReloadDurationTicks() {
        return this.reloadDurationTicks;
    }

    public float getAccuracyPct() {
        return this.accuracyPct;
    }

    public double getRange() {
        return this.range;
    }

    public int getBulletAmountToFire() {
        return this.bulletAmountToFire;
    }

    public boolean hasCrosshair() {
        return this.crosshair;
    }

    public Set<FireMode> getFireModes() {
        return this.fireModes;
    }

    public Supplier<SoundEvent> getShootSound() {
        return this.shootSound;
    }

    public Optional<SoundEvent> getDistantShootSound() {
        return Optional.ofNullable(this.distantShootSound.get());
    }

    public Optional<SoundEvent> getSilencedShootSound() {
        return Optional.ofNullable(this.silencedShootSound.get());
    }

    public Optional<SoundEvent> getReloadSound() {
        return Optional.ofNullable(this.reloadSound.get());
    }

    public Map<AnimationType, Supplier<GunAnimation>> getAnimations() {
        return this.animations;
    }

    public IAmmoProvider createAmmoProvider() {
        MagazineAmmoProvider ammoProvider = new MagazineAmmoProvider(this.getDefaultMagazine().get().func_190903_i());
        ammoProvider.getExpectedMagazine().setSize(0);
        return ammoProvider;
    }

    public Set<MagazineItem> getAcceptedMagazines() {
        return this.acceptedMagazines.stream().map(Supplier::get).collect(Collectors.toSet());
    }

    public Supplier<MagazineItem> getDefaultMagazine() {
        return this.defaultMagazine;
    }

    public Set<AttachmentItem> getAcceptedAttachments() {
        return this.acceptedAttachments.stream().map(Supplier::get).collect(Collectors.toSet());
    }

    public Set<PaintItem> getAcceptedPaints() {
        return this.acceptedPaints.stream().map(Supplier::get).collect(Collectors.toSet());
    }

    public IGun.RightMouseActionTriggerType getRightMouseActionTriggerType() {
        return this.rightMouseActionTriggerType;
    }

    public Predicate<IGun> getTriggerPredicate() {
        return this.triggerPredicate;
    }

    public Supplier<SoundEvent> getRightMouseActionSound() {
        return this.rightMouseActionSound;
    }

    public long getRightMouseActionSoundRepeatDelayMs() {
        return this.rightMouseActionSoundRepeatDelayMs;
    }

    public CombatSlotType getCombatSlotType() {
        return this.combatSlotType;
    }

    public static class Builder<T extends AbstractGun<?, ?>, SELF extends Builder<T, SELF>> {
        private final Function<SELF, AbstractGunType<?>> factory;
        private int fireDelayMs;
        private int damage;
        private int reloadDurationTicks;
        private int bulletAmountToFire = 1;
        private float accuracy;
        private double range;
        private boolean crosshair = true;
        private final Set<FireMode> fireModes = EnumSet.noneOf(FireMode.class);
        private Supplier<SoundEvent> shootSound;
        private Supplier<SoundEvent> distantShootSound = () -> null;
        private Supplier<SoundEvent> silencedShootSound = () -> null;
        private Supplier<SoundEvent> reloadSound = () -> null;
        private final Map<AnimationType, Supplier<GunAnimation>> animations = new EnumMap<AnimationType, Supplier<GunAnimation>>(AnimationType.class);
        private final Set<Supplier<MagazineItem>> acceptedMagazines = new HashSet<Supplier<MagazineItem>>();
        private Supplier<MagazineItem> defaultMagazine;
        private final Set<Supplier<AttachmentItem>> acceptedAttachments = new HashSet<Supplier<AttachmentItem>>();
        private final Set<Supplier<PaintItem>> acceptedPaints = new HashSet<Supplier<PaintItem>>();
        private IGun.RightMouseActionTriggerType rightMouseActionTriggerType = IGun.RightMouseActionTriggerType.CLICK;
        private Predicate<IGun> triggerPredicate = gun -> true;
        private Supplier<SoundEvent> rightMouseActionSound = () -> null;
        private long rightMouseActionSoundRepeatDelayMs = -1L;
        private CombatSlotType combatSlotType = CombatSlotType.PRIMARY;
        private Function<T, ? extends IGunClient> clientFactory = SimpleGunClient::new;

        public Builder(Function<SELF, AbstractGunType<?>> factory) {
            this.factory = factory;
        }

        public SELF setFireDelayMs(int fireDelayMs) {
            this.fireDelayMs = fireDelayMs;
            return this.self();
        }

        public SELF setDamage(int damage) {
            this.damage = damage;
            return this.self();
        }

        public SELF setReloadDurationTicks(int reloadDurationTicks) {
            this.reloadDurationTicks = reloadDurationTicks;
            return this.self();
        }

        public SELF setBulletAmountToFire(int amount) {
            this.bulletAmountToFire = amount;
            return this.self();
        }

        public SELF setCrosshair(boolean crosshair) {
            this.crosshair = crosshair;
            return this.self();
        }

        public SELF setAccuracy(float accuracy) {
            this.accuracy = accuracy;
            return this.self();
        }

        public SELF setRange(double range) {
            this.range = range;
            return this.self();
        }

        public SELF addFireMode(FireMode fireMode) {
            this.fireModes.add(fireMode);
            return this.self();
        }

        public SELF setShootSound(Supplier<SoundEvent> shootSound) {
            this.shootSound = shootSound;
            return this.self();
        }

        public SELF setDistantShootSound(Supplier<SoundEvent> distantShootSound) {
            this.distantShootSound = distantShootSound;
            return this.self();
        }

        public SELF setSilencedShootSound(Supplier<SoundEvent> silencedShootSound) {
            this.silencedShootSound = silencedShootSound;
            return this.self();
        }

        public SELF setReloadSound(Supplier<SoundEvent> reloadSound) {
            this.reloadSound = reloadSound;
            return this.self();
        }

        public SELF addAnimation(AnimationType type, Supplier<GunAnimation> animation) {
            this.animations.put(type, animation);
            return this.self();
        }

        public SELF addAcceptedMagazine(Supplier<MagazineItem> acceptedMagazine) {
            this.acceptedMagazines.add(acceptedMagazine);
            return this.self();
        }

        public SELF setDefaultMagazine(Supplier<MagazineItem> defaultMagazine) {
            if (this.defaultMagazine != null) {
                throw new IllegalArgumentException("Default magazine already set");
            }
            this.defaultMagazine = defaultMagazine;
            return this.addAcceptedMagazine(defaultMagazine);
        }

        public SELF addAcceptedAttachment(Supplier<AttachmentItem> acceptedAttachment) {
            this.acceptedAttachments.add(acceptedAttachment);
            return this.self();
        }

        public SELF addAcceptedPaint(Supplier<PaintItem> acceptedPaint) {
            this.acceptedPaints.add(acceptedPaint);
            return this.self();
        }

        public SELF setRightMouseActionTriggerType(IGun.RightMouseActionTriggerType rightMouseActionTriggerType) {
            this.rightMouseActionTriggerType = rightMouseActionTriggerType;
            return this.self();
        }

        public SELF setTriggerPredicate(Predicate<IGun> triggerPredicate) {
            this.triggerPredicate = triggerPredicate;
            return this.self();
        }

        public SELF setRightMouseActionSound(Supplier<SoundEvent> rightMouseActionSound) {
            this.rightMouseActionSound = rightMouseActionSound;
            return this.self();
        }

        public SELF setRightMouseActionSoundRepeatDelayMs(long rightMouseActionSoundRepeatDelayMs) {
            this.rightMouseActionSoundRepeatDelayMs = rightMouseActionSoundRepeatDelayMs;
            return this.self();
        }

        public SELF setCombatSlotType(CombatSlotType combatSlotType) {
            this.combatSlotType = combatSlotType;
            return this.self();
        }

        public SELF setClientFactory(Function<T, ? extends IGunClient> clientFactory) {
            this.clientFactory = clientFactory;
            return this.self();
        }

        public AbstractGunType<?> build() {
            return this.factory.apply(this.self());
        }

        protected final SELF self() {
            return (SELF)this;
        }
    }
}

