/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.gun;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.item.AttachmentItem;
import com.craftingdead.core.item.animation.IAnimationProvider;
import com.craftingdead.core.item.animation.gun.AnimationType;
import com.craftingdead.core.item.animation.gun.GunAnimation;
import com.craftingdead.core.item.animation.gun.GunAnimationController;
import com.craftingdead.core.item.combatslot.ICombatSlotProvider;
import com.craftingdead.core.item.gun.FireMode;
import com.craftingdead.core.item.gun.IGunClient;
import com.craftingdead.core.item.gun.PendingHit;
import com.craftingdead.core.item.gun.ammoprovider.IAmmoProvider;
import com.craftingdead.core.item.gun.paint.IPaint;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.living.IPlayer;
import com.craftingdead.core.util.IBufferSerializable;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.LazyOptional;

public interface IGun
extends ICombatSlotProvider,
IBufferSerializable,
IAnimationProvider<GunAnimationController> {
    public void tick(ILiving<?, ?> var1);

    public void reset(ILiving<?, ?> var1);

    public void setTriggerPressed(ILiving<?, ?> var1, boolean var2, boolean var3);

    public boolean isTriggerPressed();

    public void validatePendingHit(IPlayer<ServerPlayerEntity> var1, ILiving<?, ?> var2, PendingHit var3);

    public float getAccuracy(ILiving<?, ?> var1);

    public Set<AttachmentItem> getAttachments();

    default public float getAttachmentMultiplier(AttachmentItem.MultiplierType multiplierType) {
        return this.getAttachments().stream().map(attachment -> attachment.getMultiplier(multiplierType)).reduce(Float.valueOf(1.0f), (x, y) -> Float.valueOf(x.floatValue() * y.floatValue())).floatValue();
    }

    public void setAttachments(Set<AttachmentItem> var1);

    public ItemStack getPaintStack();

    default public LazyOptional<IPaint> getPaint() {
        return this.getPaintStack().getCapability(ModCapabilities.PAINT);
    }

    public void setPaintStack(ItemStack var1);

    public boolean isAcceptedPaintOrAttachment(ItemStack var1);

    public void toggleFireMode(ILiving<?, ?> var1, boolean var2);

    public void setFireMode(ILiving<?, ?> var1, FireMode var2, boolean var3);

    public boolean hasCrosshair();

    public boolean isPerformingRightMouseAction();

    public void setPerformingRightMouseAction(ILiving<?, ?> var1, boolean var2, boolean var3);

    public RightMouseActionTriggerType getRightMouseActionTriggerType();

    public Optional<SoundEvent> getReloadSound();

    public int getReloadDurationTicks();

    public boolean hasIronSight();

    public int getShotCount();

    public FireMode getFireMode();

    public Optional<GunAnimation> getAnimation(AnimationType var1);

    public IGunClient getClient();

    public IAmmoProvider getAmmoProvider();

    public void setAmmoProvider(IAmmoProvider var1);

    public Set<? extends Item> getAcceptedMagazines();

    public ItemStack getDefaultMagazineStack();

    @Override
    default public LazyOptional<GunAnimationController> getAnimationController() {
        return this.getClient() == null ? LazyOptional.empty() : LazyOptional.of(this.getClient()::getAnimationController);
    }

    public static enum RightMouseActionTriggerType {
        HOLD,
        CLICK;

    }
}

