/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.gun.aimable;

import com.craftingdead.core.item.AttachmentItem;
import com.craftingdead.core.item.gun.AbstractGun;
import com.craftingdead.core.item.gun.aimable.AimableGunType;
import com.craftingdead.core.item.scope.IScope;
import com.craftingdead.core.living.ILiving;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.ThreadTaskExecutor;

public class AimableGun
extends AbstractGun<AimableGunType, AimableGun>
implements IScope {
    private boolean waitingForBoltAction;

    public AimableGun(AimableGunType properties, ItemStack gunStack) {
        super(properties, gunStack);
    }

    @Override
    public void reset(ILiving<?, ?> living) {
        super.reset(living);
        this.waitingForBoltAction = false;
    }

    @Override
    public void tick(ILiving<?, ?> living) {
        long timeDelta = Util.func_211177_b() - this.lastShotMs;
        if (timeDelta >= (long)((AimableGunType)this.type).getFireDelayMs() && this.waitingForBoltAction) {
            this.waitingForBoltAction = false;
            if (!this.isPerformingRightMouseAction()) {
                this.setPerformingRightMouseAction(living, true, false);
            }
        }
        super.tick(living);
    }

    @Override
    protected void processShot(ILiving<?, ?> living, ThreadTaskExecutor<?> executor) {
        super.processShot(living, executor);
        executor.execute(() -> {
            if (this.isPerformingRightMouseAction() && ((AimableGunType)this.type).hasBoltAction()) {
                this.setPerformingRightMouseAction(living, false, false);
                this.waitingForBoltAction = true;
            }
        });
    }

    @Override
    public boolean isAiming(Entity entity) {
        return this.isPerformingRightMouseAction();
    }

    @Override
    public float getZoomMultiplier(Entity entity) {
        return this.hasIronSight() ? 2.0f : this.getAttachmentMultiplier(AttachmentItem.MultiplierType.ZOOM);
    }

    @Override
    public Optional<ResourceLocation> getOverlayTexture(Entity entity) {
        for (AttachmentItem attachmentItem : this.getAttachments()) {
            if (!attachmentItem.isScope()) continue;
            return Optional.of(new ResourceLocation(attachmentItem.getRegistryName().func_110624_b(), "textures/scope/" + attachmentItem.getRegistryName().func_110623_a() + ".png"));
        }
        return Optional.empty();
    }

    @Override
    public void setPerformingRightMouseAction(ILiving<?, ?> living, boolean performingRightMouseAction, boolean sendUpdate) {
        if (!this.waitingForBoltAction) {
            super.setPerformingRightMouseAction(living, performingRightMouseAction, sendUpdate);
        }
    }

    @Override
    public int getOverlayTextureWidth() {
        return 2048;
    }

    @Override
    public int getOverlayTextureHeight() {
        return 512;
    }
}

