/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.gun.ammoprovider;

import com.craftingdead.core.action.RemoveMagazineAction;
import com.craftingdead.core.action.reload.MagazineReloadAction;
import com.craftingdead.core.item.gun.ammoprovider.AmmoProviderType;
import com.craftingdead.core.item.gun.ammoprovider.AmmoProviderTypes;
import com.craftingdead.core.item.gun.ammoprovider.IAmmoProvider;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.util.IBufferSerializable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class MagazineAmmoProvider
implements IAmmoProvider {
    private ItemStack magazineStack;
    private boolean stackChanged;

    public MagazineAmmoProvider() {
        this(ItemStack.field_190927_a);
    }

    public MagazineAmmoProvider(ItemStack magazineStack) {
        this.magazineStack = magazineStack;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("magazineStack", (INBT)this.magazineStack.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("magazineStack", 10)) {
            this.magazineStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("magazineStack"));
            this.stackChanged = true;
        }
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        if (this.stackChanged || writeAll) {
            out.writeBoolean(true);
            out.func_150788_a(this.magazineStack);
            this.stackChanged = false;
        } else {
            out.writeBoolean(false);
        }
        this.getMagazine().ifPresent(magazine -> magazine.encode(out, writeAll));
    }

    @Override
    public void decode(PacketBuffer in) {
        if (in.readBoolean()) {
            this.magazineStack = in.func_150791_c();
        }
        this.getMagazine().ifPresent(magazine -> magazine.decode(in));
    }

    @Override
    public boolean requiresSync() {
        return this.getMagazine().map(IBufferSerializable::requiresSync).orElse(false) != false || this.stackChanged;
    }

    @Override
    public void reload(ILiving<?, ?> living) {
        living.performAction(new MagazineReloadAction(living), true);
    }

    @Override
    public void unload(ILiving<?, ?> living) {
        living.performAction(new RemoveMagazineAction(living), true);
    }

    @Override
    public int getReserveSize() {
        return 0;
    }

    @Override
    public ItemStack getMagazineStack() {
        return this.magazineStack;
    }

    public void setMagazineStack(ItemStack magazineStack) {
        this.magazineStack = magazineStack;
        this.stackChanged = true;
    }

    @Override
    public AmmoProviderType getType() {
        return (AmmoProviderType)AmmoProviderTypes.MAGAZINE.get();
    }
}

