/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.gun.ammoprovider;

import com.craftingdead.core.action.reload.RefillableReloadAction;
import com.craftingdead.core.item.gun.ammoprovider.AmmoProviderType;
import com.craftingdead.core.item.gun.ammoprovider.AmmoProviderTypes;
import com.craftingdead.core.item.gun.ammoprovider.IAmmoProvider;
import com.craftingdead.core.item.gun.magazine.IMagazine;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.util.IBufferSerializable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class RefillableAmmoProvider
implements IAmmoProvider {
    private ItemStack magazineStack;
    private int reserveSize;
    private boolean infiniteAmmo;
    private boolean reserveSizeChanged;

    public RefillableAmmoProvider() {
        this(ItemStack.field_190927_a, 0, false);
    }

    public RefillableAmmoProvider(ItemStack magazineStack, int reserveMagazineCount, boolean infiniteAmmo) {
        this.magazineStack = magazineStack;
        this.reserveSize = this.getMagazine().map(IMagazine::getMaxSize).orElse(0) * reserveMagazineCount;
        this.infiniteAmmo = infiniteAmmo;
    }

    public boolean hasInfiniteAmmo() {
        return this.infiniteAmmo;
    }

    public void refillMagazine() {
        IMagazine magazine = this.getExpectedMagazine();
        this.moveAmmoToReserve(magazine.getSize());
        this.moveAmmoToMagazine(this.infiniteAmmo ? magazine.getMaxSize() : Math.min(magazine.getMaxSize(), this.reserveSize));
    }

    public boolean moveAmmoToMagazine(int amount) {
        if (!this.infiniteAmmo && this.reserveSize < amount) {
            return false;
        }
        IMagazine magazine = this.getExpectedMagazine();
        int ammoToLoad = Math.min(magazine.getMaxSize(), amount);
        magazine.setSize(ammoToLoad);
        if (!this.infiniteAmmo) {
            this.reserveSize -= ammoToLoad;
            this.reserveSizeChanged = true;
        }
        return true;
    }

    public boolean moveAmmoToReserve(int amount) {
        IMagazine magazine = this.getExpectedMagazine();
        int currentSize = magazine.getSize();
        if (currentSize < amount) {
            return false;
        }
        if (!this.infiniteAmmo) {
            this.reserveSize += amount;
            this.reserveSizeChanged = true;
        }
        magazine.setSize(currentSize - amount);
        return true;
    }

    @Override
    public void reload(ILiving<?, ?> living) {
        living.performAction(new RefillableReloadAction(living), true);
    }

    @Override
    public void unload(ILiving<?, ?> living) {
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("magazineStack", (INBT)this.magazineStack.serializeNBT());
        nbt.func_74768_a("reserveSize", this.reserveSize);
        nbt.func_74757_a("infiniteAmmo", this.infiniteAmmo);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("magazineStack", 10)) {
            this.magazineStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("magazineStack"));
        }
        this.reserveSize = nbt.func_74762_e("reserveSize");
        this.infiniteAmmo = nbt.func_74767_n("infiniteAmmo");
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        if (writeAll) {
            out.writeBoolean(true);
            out.func_150788_a(this.magazineStack);
            out.writeBoolean(this.infiniteAmmo);
        } else {
            out.writeBoolean(false);
        }
        this.getExpectedMagazine().encode(out, writeAll);
        out.func_150787_b(this.reserveSize);
        this.reserveSizeChanged = false;
    }

    @Override
    public void decode(PacketBuffer in) {
        if (in.readBoolean()) {
            this.magazineStack = in.func_150791_c();
            this.infiniteAmmo = in.readBoolean();
        }
        this.getExpectedMagazine().decode(in);
        this.reserveSize = in.func_150792_a();
    }

    @Override
    public boolean requiresSync() {
        return this.reserveSizeChanged || this.getMagazine().map(IBufferSerializable::requiresSync).orElse(false) != false;
    }

    @Override
    public int getReserveSize() {
        return this.reserveSize;
    }

    @Override
    public ItemStack getMagazineStack() {
        return this.magazineStack;
    }

    @Override
    public AmmoProviderType getType() {
        return (AmmoProviderType)AmmoProviderTypes.REFILLABLE.get();
    }
}

