/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.gun.magazine;

import com.craftingdead.core.item.MagazineItem;
import com.craftingdead.core.item.gun.magazine.IMagazine;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class MagazineImpl
implements IMagazine {
    private final MagazineItem magazineItem;
    private int size;
    private boolean dirty;

    public MagazineImpl() {
        throw new UnsupportedOperationException("Specify magazine item");
    }

    public MagazineImpl(MagazineItem magazineItem) {
        this.magazineItem = magazineItem;
        this.size = magazineItem.getSize();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("size", this.size);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.size = nbt.func_74762_e("size");
    }

    @Override
    public float getArmorPenetration() {
        return this.magazineItem.getArmorPenetration();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.dirty = true;
        this.size = size;
    }

    @Override
    public void refill() {
        this.dirty = true;
        this.size = this.magazineItem.getSize();
    }

    @Override
    public int decrementSize() {
        this.dirty = true;
        return --this.size;
    }

    @Override
    public Item getNextTier() {
        return this.magazineItem.getNextTier().get();
    }

    @Override
    public boolean hasCustomTexture() {
        return this.magazineItem.hasCustomTexture();
    }

    @Override
    public int getMaxSize() {
        return this.magazineItem.getSize();
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        out.func_150787_b(this.size);
        this.dirty = false;
    }

    @Override
    public void decode(PacketBuffer in) {
        this.size = in.func_150792_a();
    }

    @Override
    public boolean requiresSync() {
        return this.dirty;
    }
}

