/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.gun.simple;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.item.AttachmentItem;
import com.craftingdead.core.item.animation.gun.AnimationType;
import com.craftingdead.core.item.animation.gun.GunAnimation;
import com.craftingdead.core.item.animation.gun.GunAnimationController;
import com.craftingdead.core.item.gun.AbstractGun;
import com.craftingdead.core.item.gun.AbstractGunType;
import com.craftingdead.core.item.gun.IGunClient;
import com.craftingdead.core.item.gun.PendingHit;
import com.craftingdead.core.living.EntitySnapshot;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.ValidatePendingHitMessage;
import com.craftingdead.core.util.ModSoundEvents;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class SimpleGunClient<T extends AbstractGun<?, ?>>
implements IGunClient {
    private static final int MUZZLE_FLASH_DURATION_TICKS = 2;
    private final ClientDist client = CraftingDead.getInstance().getClientDist();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    protected final T gun;
    private final GunAnimationController animationController = new GunAnimationController();
    private int lastShotCount;
    private int remainingFlashTicks;
    private long rightMouseActionSoundStartTimeMs;
    private final Multimap<Integer, PendingHit> livingHitValidationBuffer = Multimaps.synchronizedListMultimap((ListMultimap)Multimaps.newListMultimap((Map)new Int2ObjectLinkedOpenHashMap(), ObjectArrayList::new));
    private byte hitValidationTicks = 0;

    public SimpleGunClient(T gun) {
        this.gun = gun;
    }

    @Override
    public void handleTick(ILiving<?, ?> living) {
        if (living.getEntity() instanceof ClientPlayerEntity && this.livingHitValidationBuffer.size() > 0) {
            byte by = this.hitValidationTicks;
            this.hitValidationTicks = (byte)(by + 1);
            if (by >= 3) {
                this.hitValidationTicks = 0;
                NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new ValidatePendingHitMessage(new HashMap<Integer, Collection<PendingHit>>(this.livingHitValidationBuffer.asMap())));
                this.livingHitValidationBuffer.clear();
            }
        }
        SoundEvent rightMouseActionSound = ((AbstractGunType)((AbstractGun)this.gun).getType()).getRightMouseActionSound().get();
        long rightMouseActionSoundDelta = Util.func_211177_b() - this.rightMouseActionSoundStartTimeMs + 50L;
        if (((AbstractGun)this.gun).isPerformingRightMouseAction() && ((AbstractGunType)((AbstractGun)this.gun).getType()).getRightMouseActionSoundRepeatDelayMs() > 0L && rightMouseActionSoundDelta >= ((AbstractGunType)((AbstractGun)this.gun).getType()).getRightMouseActionSoundRepeatDelayMs() && rightMouseActionSound != null) {
            this.rightMouseActionSoundStartTimeMs = Util.func_211177_b();
            living.getEntity().func_184185_a(rightMouseActionSound, 1.0f, 1.0f);
        }
        if (!((AbstractGun)this.gun).isTriggerPressed()) {
            this.lastShotCount = 0;
        }
        if (this.remainingFlashTicks > 0) {
            --this.remainingFlashTicks;
        }
    }

    protected boolean canFlash(ILiving<?, ?> living) {
        return this.minecraft.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && ((AbstractGun)this.gun).getShotCount() != this.lastShotCount && ((AbstractGun)this.gun).getShotCount() > 0;
    }

    @Override
    public void handleShoot(ILiving<?, ?> living) {
        SoundEvent shootSound;
        Object entity = living.getEntity();
        if (this.canFlash(living)) {
            this.remainingFlashTicks = 2;
        }
        this.lastShotCount = ((AbstractGun)this.gun).getShotCount();
        if (entity == this.minecraft.func_175606_aa()) {
            float baseJolt = 0.05f;
            this.client.getCameraManager().joltCamera(1.0f - ((AbstractGun)this.gun).getAccuracy(living) + 0.05f, true);
        }
        ((AbstractGun)this.gun).getAnimation(AnimationType.SHOOT).ifPresent(animation -> {
            this.animationController.removeCurrentAnimation();
            this.animationController.addAnimation((GunAnimation)animation, null);
        });
        double sqrDistance = this.minecraft.field_71460_t.func_215316_n().func_216785_c().func_186679_c(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        boolean distant = sqrDistance > 1600.0;
        Supplier<SoundEvent> defaultShootSound = ((AbstractGunType)((AbstractGun)this.gun).getType()).getShootSound();
        boolean amplifyDistantSound = ((AbstractGunType)((AbstractGun)this.gun).getType()).getDistantShootSound().isPresent();
        if (((AbstractGun)this.gun).getAttachments().stream().anyMatch(AttachmentItem::isSoundSuppressor)) {
            shootSound = distant ? null : ((AbstractGunType)((AbstractGun)this.gun).getType()).getSilencedShootSound().orElseGet(defaultShootSound);
        } else {
            SoundEvent soundEvent = shootSound = distant ? ((AbstractGunType)((AbstractGun)this.gun).getType()).getDistantShootSound().orElseGet(defaultShootSound) : defaultShootSound.get();
        }
        if (!entity.func_174814_R() && shootSound != null) {
            this.minecraft.execute(() -> entity.field_70170_p.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), shootSound, entity.func_184176_by(), distant && amplifyDistantSound ? 8.0f : 1.0f, 1.0f, true));
        }
    }

    @Override
    public void handleHitEntityPre(ILiving<?, ?> living, Entity hitEntity, Vector3d hitPos, long randomSeed) {
        if (living.getEntity() instanceof ClientPlayerEntity && hitEntity instanceof LivingEntity) {
            this.livingHitValidationBuffer.put((Object)hitEntity.func_145782_y(), (Object)new PendingHit((byte)(3 - this.hitValidationTicks), new EntitySnapshot((Entity)living.getEntity()), new EntitySnapshot(hitEntity), randomSeed));
        }
    }

    @Override
    public void handleHitEntityPost(ILiving<?, ?> living, Entity hitEntity, Vector3d hitPos, boolean playSound, boolean headshot) {
        int i;
        int particleCount;
        World world = hitEntity.func_130014_f_();
        Object entity = living.getEntity();
        if (headshot) {
            particleCount = 12;
            for (i = 0; i < 12; ++i) {
                world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_189880_di.func_176223_P()), hitPos.func_82615_a(), hitPos.func_82617_b(), hitPos.func_82616_c(), 0.0, 0.0, 0.0);
            }
        }
        world.func_184133_a(entity instanceof PlayerEntity ? (PlayerEntity)entity : null, hitEntity.func_233580_cy_(), (SoundEvent)ModSoundEvents.BULLET_IMPACT_FLESH.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (hitEntity == this.minecraft.func_175606_aa()) {
            this.client.getCameraManager().joltCamera(1.5f, false);
        }
        particleCount = 12;
        for (i = 0; i < 12; ++i) {
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150451_bX.func_176223_P()), hitPos.func_82615_a(), hitPos.func_82617_b(), hitPos.func_82616_c(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void handleHitBlock(ILiving<?, ?> living, BlockRayTraceResult rayTrace, boolean playSound) {
        Object entity = living.getEntity();
        Vector3d hitVec3d = rayTrace.func_216347_e();
        BlockPos blockPos = rayTrace.func_216350_a();
        BlockState blockState = entity.func_130014_f_().func_180495_p(blockPos);
        World world = entity.func_130014_f_();
        SoundEvent hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_DIRT.get();
        Material blockMaterial = blockState.func_185904_a();
        if (blockMaterial == Material.field_151575_d) {
            hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_WOOD.get();
        } else if (blockMaterial == Material.field_151576_e) {
            hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_STONE.get();
        } else if (blockMaterial == Material.field_151573_f) {
            hitSound = Math.random() > 0.5 ? (SoundEvent)ModSoundEvents.BULLET_IMPACT_METAL.get() : (SoundEvent)ModSoundEvents.BULLET_IMPACT_METAL2.get();
        } else if (blockMaterial == Material.field_151592_s) {
            hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_GLASS.get();
        }
        world.func_184133_a(entity instanceof PlayerEntity ? (PlayerEntity)entity : null, blockPos, hitSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        int particleCount = 12;
        for (int i = 0; i < 12; ++i) {
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), hitVec3d.func_82615_a(), hitVec3d.func_82617_b(), hitVec3d.func_82616_c(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void handleToggleRightMouseAction(ILiving<?, ?> living) {
        SoundEvent rightMouseActionSound = ((AbstractGunType)((AbstractGun)this.gun).getType()).getRightMouseActionSound().get();
        if (rightMouseActionSound != null) {
            if (((AbstractGun)this.gun).isPerformingRightMouseAction()) {
                this.rightMouseActionSoundStartTimeMs = Util.func_211177_b();
                living.getEntity().func_184185_a(rightMouseActionSound, 1.0f, 1.0f);
            } else {
                Minecraft.func_71410_x().func_147118_V().func_195478_a(rightMouseActionSound.getRegistryName(), SoundCategory.PLAYERS);
            }
        }
    }

    @Override
    public boolean isFlashing() {
        return this.remainingFlashTicks > 0;
    }

    @Override
    public GunAnimationController getAnimationController() {
        return this.animationController;
    }
}

