/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.living;

import com.craftingdead.core.util.RayTraceUtil;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class EntitySnapshot {
    private boolean complete;
    private final AxisAlignedBB boundingBox;
    private Vector3d pos;
    private final Vector2f pitchYaw;
    private final float eyeHeight;

    public EntitySnapshot(AxisAlignedBB boundingBox, Vector2f pitchYaw) {
        this(boundingBox, pitchYaw, -1.0f);
        this.complete = false;
    }

    public EntitySnapshot(Entity entity) {
        this(entity.func_174813_aQ(), entity.func_189653_aC(), entity.func_70047_e());
    }

    public EntitySnapshot(AxisAlignedBB boundingBox, Vector2f pitchYaw, float eyeHeight) {
        this.pos = new Vector3d((boundingBox.field_72340_a + boundingBox.field_72336_d) / 2.0, boundingBox.field_72338_b, (boundingBox.field_72339_c + boundingBox.field_72334_f) / 2.0);
        this.boundingBox = boundingBox;
        this.pitchYaw = pitchYaw;
        this.eyeHeight = eyeHeight;
        this.complete = true;
    }

    public Optional<Vector3d> rayTrace(World world, EntitySnapshot fromSnapshot, double distance, float accuracy, int shotCount, Random random) {
        if (!fromSnapshot.complete || !this.complete) {
            return Optional.empty();
        }
        Vector3d start = fromSnapshot.getPos().func_72441_c(0.0, (double)fromSnapshot.eyeHeight, 0.0);
        Vector3d look = RayTraceUtil.getVectorForRotation(fromSnapshot.getPitchYaw().field_189982_i + RayTraceUtil.getAccuracyOffset(accuracy, shotCount, random), fromSnapshot.getPitchYaw().field_189983_j + RayTraceUtil.getAccuracyOffset(accuracy, shotCount, random));
        Optional<BlockRayTraceResult> blockRayTraceResult = RayTraceUtil.rayTraceBlocksPiercing(start, distance, look, world);
        Vector3d scaledLook = look.func_186678_a(distance);
        Vector3d end = blockRayTraceResult.map(RayTraceResult::func_216347_e).orElse(start.func_178787_e(scaledLook));
        Optional potentialHit = this.getCollisionBox().func_216365_b(start, end);
        if (this.getCollisionBox().func_72318_a(start)) {
            return Optional.of(potentialHit.orElse(start));
        }
        return potentialHit;
    }

    public Vector3d getPos() {
        return this.pos;
    }

    public AxisAlignedBB getCollisionBox() {
        return this.boundingBox;
    }

    public Vector2f getPitchYaw() {
        return this.pitchYaw;
    }

    public float getEyeHeight() {
        return this.eyeHeight;
    }

    public EntitySnapshot combineUntrustedSnapshot(EntitySnapshot snapshot) {
        if (!this.complete) {
            throw new UnsupportedOperationException("Snapshot not complete");
        }
        AxisAlignedBB boundingBox = snapshot.boundingBox;
        if (this.pos.func_72438_d(snapshot.pos) > 1.0 || Math.abs(this.boundingBox.func_72320_b() - snapshot.boundingBox.func_72320_b()) > 1.0E-10) {
            boundingBox = this.boundingBox;
        }
        Vector2f pitchYaw = snapshot.pitchYaw;
        if ((double)MathHelper.func_203301_d((float)this.pitchYaw.field_189982_i, (float)snapshot.pitchYaw.field_189982_i) > 10.0 || (double)MathHelper.func_203301_d((float)this.pitchYaw.field_189983_j, (float)snapshot.pitchYaw.field_189983_j) > 10.0) {
            pitchYaw = this.pitchYaw;
        }
        return new EntitySnapshot(boundingBox, pitchYaw, this.eyeHeight);
    }

    public String toString() {
        return "snapshot[pitch = " + this.pitchYaw.field_189982_i + ", yaw = " + this.pitchYaw.field_189983_j + ", " + this.boundingBox.toString() + "]";
    }

    public void write(PacketBuffer out) {
        out.writeDouble(this.boundingBox.field_72340_a);
        out.writeDouble(this.boundingBox.field_72338_b);
        out.writeDouble(this.boundingBox.field_72339_c);
        out.writeDouble(this.boundingBox.field_72336_d);
        out.writeDouble(this.boundingBox.field_72337_e);
        out.writeDouble(this.boundingBox.field_72334_f);
        out.writeFloat(this.pitchYaw.field_189982_i);
        out.writeFloat(this.pitchYaw.field_189983_j);
    }

    public static EntitySnapshot read(PacketBuffer in) {
        double minX = in.readDouble();
        double minY = in.readDouble();
        double minZ = in.readDouble();
        double maxX = in.readDouble();
        double maxY = in.readDouble();
        double maxZ = in.readDouble();
        float pitch = in.readFloat();
        float yaw = in.readFloat();
        return new EntitySnapshot(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ), new Vector2f(pitch, yaw));
    }
}

