/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.living;

import com.craftingdead.core.action.IAction;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.living.EntitySnapshot;
import com.craftingdead.core.living.ILivingExtension;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface ILiving<T extends LivingEntity, E extends ILivingExtension>
extends ILivingExtension {
    public static final ResourceLocation CAPABILITY_KEY = new ResourceLocation("craftingdead", "living");

    public void load();

    public Optional<E> getExtension(ResourceLocation var1);

    @Nonnull
    public E getExpectedExtension(ResourceLocation var1) throws IllegalStateException;

    public void registerExtension(ResourceLocation var1, E var2);

    default public boolean performAction(IAction action, boolean sendUpdate) {
        return this.performAction(action, false, sendUpdate);
    }

    public boolean performAction(IAction var1, boolean var2, boolean var3);

    public void cancelAction(boolean var1);

    public void setActionProgress(IProgressMonitor var1);

    public Optional<IProgressMonitor> getProgressMonitor();

    default public boolean isMonitoringAction() {
        return this.getProgressMonitor().isPresent();
    }

    public void setMovementBlocked(boolean var1);

    public boolean isMoving();

    public IItemHandlerModifiable getItemHandler();

    public EntitySnapshot getSnapshot(int var1) throws IndexOutOfBoundsException;

    public boolean isCrouching();

    public void setCrouching(boolean var1, boolean var2);

    default public float getModifiedAccuracy(float accuracy, Random random) {
        if (this.isMoving()) {
            accuracy -= 0.15f;
        } else if (this.isCrouching()) {
            accuracy += 0.15f;
        }
        if (!(this.getEntity() instanceof PlayerEntity)) {
            accuracy -= random.nextFloat();
        }
        return accuracy;
    }

    public T getEntity();

    @Nonnull
    public static <E extends LivingEntity> ILiving<E, ?> getExpected(E livingEntity) throws IllegalStateException {
        return (ILiving)livingEntity.getCapability(ModCapabilities.LIVING).cast().orElseThrow(() -> new IllegalStateException("Missing living capability " + livingEntity));
    }

    public static <R extends ILiving<E, ?>, E extends LivingEntity> Optional<R> getOptional(E livingEntity) {
        return livingEntity.getCapability(ModCapabilities.LIVING).cast().map(Optional::of).orElse(Optional.empty());
    }

    public static interface IProgressMonitor {
        public ITextComponent getMessage();

        public Optional<ITextComponent> getSubMessage();

        public float getProgress(float var1);

        public void stop();
    }
}

