/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.living;

import com.craftingdead.core.action.IAction;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.event.LivingEvent;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.item.animation.IAnimationProvider;
import com.craftingdead.core.living.EntitySnapshot;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.living.ILivingExtension;
import com.craftingdead.core.living.Visibility;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.CancelActionMessage;
import com.craftingdead.core.network.message.play.CrouchMessage;
import com.craftingdead.core.network.message.play.PerformActionMessage;
import com.craftingdead.core.util.ModSoundEvents;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class LivingImpl<L extends LivingEntity, E extends ILivingExtension>
implements ILiving<L, E> {
    protected final L entity;
    protected final Object2ObjectOpenHashMap<ResourceLocation, E> extensions = new Object2ObjectOpenHashMap();
    protected final Object2ObjectOpenHashMap<ResourceLocation, E> dirtyExtensions = new Object2ObjectOpenHashMap();
    protected ItemStack lastHeldStack = null;
    private List<Integer> dirtySlots = new IntArrayList();
    private final EntitySnapshot[] snapshots = new EntitySnapshot[20];
    private final ItemStackHandler itemHandler = new ItemStackHandler(InventorySlotType.values().length){

        public void onContentsChanged(int slot) {
            if (!LivingImpl.this.entity.func_130014_f_().func_201670_d()) {
                LivingImpl.this.dirtySlots.add(slot);
            }
        }
    };
    private IAction action;
    private ILiving.IProgressMonitor actionProgress;
    private boolean movementBlocked;
    private boolean crouching;
    private Vector3d lastPos;
    private boolean moving;
    private Visibility cachedVisibility = Visibility.VISIBLE;

    public LivingImpl() {
        throw new IllegalStateException("No entity provided");
    }

    public LivingImpl(L entity) {
        this.entity = entity;
    }

    @Override
    public void load() {
        MinecraftForge.EVENT_BUS.post((Event)new LivingEvent.Load(this));
    }

    @Override
    public void registerExtension(ResourceLocation id, E extension) {
        if (this.extensions.containsKey((Object)id)) {
            throw new IllegalArgumentException("Extension with id " + id.toString() + " already registered");
        }
        this.extensions.put((Object)id, extension);
    }

    @Override
    public Optional<E> getExtension(ResourceLocation id) {
        return Optional.ofNullable((ILivingExtension)this.extensions.get((Object)id));
    }

    @Override
    public E getExpectedExtension(ResourceLocation id) {
        ILivingExtension extension = (ILivingExtension)this.extensions.get((Object)id);
        if (extension == null) {
            throw new IllegalStateException("Missing extension with ID: " + id.toString());
        }
        return (E)extension;
    }

    @Override
    public boolean performAction(IAction action, boolean force, boolean sendUpdate) {
        if (MinecraftForge.EVENT_BUS.post(new LivingEvent.PerformAction<IAction>(this, action))) {
            return false;
        }
        ILiving.IProgressMonitor targetProgressMonitor = action.getTarget().flatMap(ILiving::getProgressMonitor).orElse(null);
        if (this.actionProgress != null || targetProgressMonitor != null) {
            if (!force) {
                return false;
            }
            this.actionProgress.stop();
            if (targetProgressMonitor != this.actionProgress) {
                targetProgressMonitor.stop();
            }
        }
        if (this.action != null && !force || !action.start()) {
            return false;
        }
        this.cancelAction(true);
        this.action = action;
        this.actionProgress = action.getPerformerProgress();
        action.getTarget().ifPresent(target -> target.setActionProgress(action.getTargetProgress()));
        if (sendUpdate) {
            PacketDistributor.PacketTarget target2 = this.getEntity().func_130014_f_().func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target2, (Object)new PerformActionMessage(action.getActionType(), this.getEntity().func_145782_y(), action.getTarget().map(ILiving::getEntity).map(Entity::func_145782_y).orElse(-1)));
        }
        return true;
    }

    @Override
    public void cancelAction(boolean sendUpdate) {
        if (this.action == null) {
            return;
        }
        this.action.cancel();
        this.removeAction();
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = ((LivingEntity)this.getEntity()).field_70170_p.func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new CancelActionMessage(this.getEntity().func_145782_y()));
        }
    }

    @Override
    public void setActionProgress(ILiving.IProgressMonitor actionProgress) {
        this.actionProgress = actionProgress;
    }

    @Override
    public Optional<ILiving.IProgressMonitor> getProgressMonitor() {
        return Optional.ofNullable(this.actionProgress);
    }

    private void removeAction() {
        if (this.action != null) {
            this.actionProgress = null;
            this.action.getTarget().ifPresent(target -> target.setActionProgress(null));
            this.action = null;
        }
    }

    @Override
    public void setMovementBlocked(boolean movementBlocked) {
        this.movementBlocked = movementBlocked;
    }

    @Override
    public boolean isMovementBlocked() {
        return this.movementBlocked;
    }

    @Override
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    public void tick() {
        ItemStack heldStack = this.entity.func_184614_ca();
        if (heldStack != this.lastHeldStack) {
            this.getProgressMonitor().ifPresent(ILiving.IProgressMonitor::stop);
            if (this.lastHeldStack != null) {
                this.lastHeldStack.getCapability(ModCapabilities.GUN).ifPresent(gun -> gun.reset(this));
            }
            if (heldStack.getCapability(ModCapabilities.GUN).isPresent()) {
                this.entity.func_184185_a((SoundEvent)ModSoundEvents.GUN_EQUIP.get(), 0.25f, 1.0f);
            }
            this.lastHeldStack = heldStack;
        }
        this.movementBlocked = false;
        if (this.action != null && this.action.tick()) {
            this.removeAction();
        }
        heldStack.getCapability(ModCapabilities.GUN).ifPresent(gun -> gun.tick(this));
        ((LazyOptional)heldStack.getCapability(ModCapabilities.ANIMATION_PROVIDER).lazyMap(IAnimationProvider::getAnimationController).orElseGet(LazyOptional::empty)).ifPresent(c -> c.tick((LivingEntity)this.getEntity(), heldStack));
        this.updateGeneralClothingEffects();
        this.updateScubaClothing();
        this.updateScubaMask();
        if (!this.entity.func_130014_f_().func_201670_d()) {
            this.snapshots[this.entity.func_184102_h().func_71259_af() % 20] = new EntitySnapshot((Entity)this.entity);
        }
        this.moving = !this.entity.func_213303_ch().equals((Object)this.lastPos);
        this.lastPos = this.entity.func_213303_ch();
        for (Map.Entry entry : this.extensions.entrySet()) {
            this.tickExtension((ResourceLocation)entry.getKey(), (ILivingExtension)entry.getValue());
        }
    }

    protected void tickExtension(ResourceLocation extensionId, E extension) {
        extension.tick();
        this.cachedVisibility = Visibility.VISIBLE;
        switch (extension.getVisibility()) {
            case INVISIBLE: {
                this.cachedVisibility = Visibility.INVISIBLE;
            }
            case PARTIALLY_VISIBLE: {
                if (this.cachedVisibility != Visibility.VISIBLE) break;
                this.cachedVisibility = Visibility.PARTIALLY_VISIBLE;
                break;
            }
        }
        if (extension.isMovementBlocked()) {
            this.movementBlocked = true;
        }
        if (extension.requiresSync()) {
            this.dirtyExtensions.put((Object)extensionId, extension);
        }
    }

    private void updateScubaClothing() {
        ItemStack clothingStack = this.itemHandler.getStackInSlot(InventorySlotType.CLOTHING.getIndex());
        if (clothingStack.func_77973_b() == ModItems.SCUBA_CLOTHING.get() && this.entity.func_208600_a((ITag)FluidTags.field_206959_a)) {
            this.entity.func_195064_c(new EffectInstance(Effects.field_206827_D, 2, 0, false, false, false));
        }
    }

    private void updateScubaMask() {
        ItemStack headStack = this.itemHandler.getStackInSlot(InventorySlotType.HAT.getIndex());
        if (headStack.func_77973_b() == ModItems.SCUBA_MASK.get() && this.entity.func_208600_a((ITag)FluidTags.field_206959_a)) {
            this.entity.func_195064_c(new EffectInstance(Effects.field_76427_o, 2, 0, false, false, false));
        }
    }

    private void updateGeneralClothingEffects() {
        ItemStack clothingStack = this.itemHandler.getStackInSlot(InventorySlotType.CLOTHING.getIndex());
        clothingStack.getCapability(ModCapabilities.CLOTHING).ifPresent(clothing -> {
            if (clothing.hasFireImmunity()) {
                if (this.entity.func_223314_ad() > 0) {
                    this.entity.func_70066_B();
                }
                this.entity.func_195064_c(new EffectInstance(Effects.field_76426_n, 2, 0, false, false, false));
            }
            clothing.getSlownessAmplifier().ifPresent(amplifier -> this.entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, amplifier.intValue(), false, false, false)));
        });
    }

    @Override
    public float onDamaged(DamageSource source, float amount) {
        return this.extensions.values().stream().reduce(Float.valueOf(amount), (result, extension) -> Float.valueOf(extension.onDamaged(source, result.floatValue())), (u, t) -> t).floatValue();
    }

    @Override
    public boolean onAttacked(DamageSource source, float amount) {
        return this.extensions.values().stream().anyMatch(e -> e.onAttacked(source, amount));
    }

    @Override
    public boolean onKill(Entity target) {
        return this.extensions.values().stream().anyMatch(e -> e.onKill(target));
    }

    @Override
    public boolean onDeath(DamageSource cause) {
        return this.extensions.values().stream().map(e -> e.onDeath(cause)).anyMatch(v -> v == true);
    }

    @Override
    public boolean onDeathDrops(DamageSource cause, Collection<ItemEntity> drops) {
        if (this.extensions.values().stream().map(e -> e.onDeathDrops(cause, drops)).anyMatch(v -> v == true)) {
            return true;
        }
        boolean shouldKeepInventory = this.getEntity().func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223600_c);
        if (!shouldKeepInventory) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack itemStack = this.itemHandler.extractItem(i, Integer.MAX_VALUE, false);
                if (itemStack.func_190926_b()) continue;
                ItemEntity itemEntity = new ItemEntity(((LivingEntity)this.getEntity()).field_70170_p, this.getEntity().func_226277_ct_(), this.getEntity().func_226278_cu_(), this.getEntity().func_226281_cx_(), itemStack);
                itemEntity.func_174869_p();
                drops.add(itemEntity);
            }
        }
        return false;
    }

    @Override
    public Visibility getVisibility() {
        return this.cachedVisibility;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public EntitySnapshot getSnapshot(int tick) {
        int currentTick = this.entity.func_184102_h().func_71259_af();
        if (tick >= currentTick) {
            return new EntitySnapshot((Entity)this.entity);
        }
        if (tick < currentTick - 20) {
            return this.snapshots[0];
        }
        int snapshotIndex = tick % 20;
        EntitySnapshot snapshot = this.snapshots[snapshotIndex];
        if (snapshot == null) {
            throw new IndexOutOfBoundsException();
        }
        return snapshot;
    }

    @Override
    public boolean isCrouching() {
        return this.crouching;
    }

    @Override
    public void setCrouching(boolean crouching, boolean sendUpdate) {
        this.crouching = crouching;
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = this.getEntity().func_130014_f_().func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new CrouchMessage(this.getEntity().func_145782_y(), crouching));
        }
    }

    @Override
    public L getEntity() {
        return this.entity;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("inventory", (INBT)this.itemHandler.serializeNBT());
        for (Map.Entry entry : this.extensions.entrySet()) {
            CompoundNBT extensionNbt = ((ILivingExtension)entry.getValue()).serializeNBT();
            if (extensionNbt.isEmpty()) continue;
            nbt.func_218657_a(((ResourceLocation)entry.getKey()).toString(), (INBT)extensionNbt);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inventory"));
        for (Map.Entry entry : this.extensions.entrySet()) {
            CompoundNBT extensionNbt = nbt.func_74775_l(((ResourceLocation)entry.getKey()).toString());
            if (extensionNbt.isEmpty()) continue;
            ((ILivingExtension)entry.getValue()).deserializeNBT(extensionNbt);
        }
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || obj instanceof LivingImpl && ((LivingImpl)obj).entity.equals(this.entity);
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        if (writeAll) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                out.writeShort(i);
                out.func_150788_a(this.itemHandler.getStackInSlot(i));
            }
        } else {
            for (int i : this.dirtySlots) {
                out.writeShort(i);
                out.func_150788_a(this.itemHandler.getStackInSlot(i));
            }
        }
        out.writeShort(255);
        ObjectSet extensionsToSend = writeAll ? this.extensions.entrySet() : this.dirtyExtensions.entrySet();
        out.func_150787_b(extensionsToSend.size());
        for (Map.Entry entry : extensionsToSend) {
            out.func_192572_a((ResourceLocation)entry.getKey());
            PacketBuffer extensionData = new PacketBuffer(Unpooled.buffer());
            ((ILivingExtension)entry.getValue()).encode(extensionData, writeAll);
            out.func_150787_b(extensionData.readableBytes());
            out.writeBytes((ByteBuf)extensionData);
        }
        this.dirtyExtensions.clear();
    }

    @Override
    public void decode(PacketBuffer in) {
        short slot;
        while ((slot = in.readShort()) != 255) {
            this.itemHandler.setStackInSlot((int)slot, in.func_150791_c());
        }
        int extensionsSize = in.func_150792_a();
        for (int x = 0; x < extensionsSize; ++x) {
            ResourceLocation id = in.func_192575_l();
            int dataSize = in.func_150792_a();
            ILivingExtension extension = (ILivingExtension)this.extensions.get((Object)id);
            if (extension == null) {
                in.readerIndex(in.readerIndex() + dataSize);
                continue;
            }
            extension.decode(in);
        }
    }

    @Override
    public boolean requiresSync() {
        return !this.dirtySlots.isEmpty() || !this.dirtyExtensions.isEmpty();
    }
}

