/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.living;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.clothing.IClothing;
import com.craftingdead.core.event.OpenEquipmentMenuEvent;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.inventory.container.EquipmentContainer;
import com.craftingdead.core.living.IPlayer;
import com.craftingdead.core.living.IPlayerExtension;
import com.craftingdead.core.living.LivingImpl;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.KillFeedMessage;
import com.craftingdead.core.network.util.NetworkDataManager;
import com.craftingdead.core.potion.ModEffects;
import com.craftingdead.core.util.IKillFeedProvider;
import com.craftingdead.core.util.ModDamageSource;
import com.google.common.primitives.Ints;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;

public class PlayerImpl<L extends PlayerEntity>
extends LivingImpl<L, IPlayerExtension>
implements IPlayer<L> {
    private static final int WATER_DAMAGE_DELAY_TICKS = 120;
    private static final int WATER_DELAY_TICKS = 800;
    private static final Random random = new Random();
    private final NetworkDataManager dataManager = new NetworkDataManager();
    private static final DataParameter<Integer> WATER = new DataParameter(0, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAX_WATER = new DataParameter(1, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> COMBAT_MODE_ENABLED = new DataParameter(2, DataSerializers.field_187198_h);
    private int waterTicks;
    private boolean cachedCombatModeEnabled;

    public PlayerImpl(L entity) {
        super(entity);
        this.dataManager.register(WATER, 20);
        this.dataManager.register(MAX_WATER, 20);
        this.dataManager.register(COMBAT_MODE_ENABLED, false);
    }

    @Override
    public void tick() {
        this.cachedCombatModeEnabled = false;
        super.tick();
    }

    @Override
    protected void tickExtension(ResourceLocation extensionId, IPlayerExtension extension) {
        super.tickExtension(extensionId, extension);
        if (extension.isCombatModeEnabled()) {
            this.cachedCombatModeEnabled = true;
        }
    }

    @Override
    public void playerTick() {
        if (!((PlayerEntity)this.entity).field_70170_p.func_201670_d()) {
            this.updateHydration();
            this.updateEffects();
            this.updateBrokenLeg();
        }
        if (this.isCrouching()) {
            ((PlayerEntity)this.getEntity()).func_213301_b(Pose.SWIMMING);
        }
    }

    private void updateHydration() {
        if (((Boolean)CraftingDead.serverConfig.hydrationEnabled.get()).booleanValue() && ((PlayerEntity)this.getEntity()).field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && !((PlayerEntity)this.getEntity()).field_71075_bZ.field_75102_a) {
            ++this.waterTicks;
            if (this.getWater() <= 0) {
                if (this.waterTicks >= 120 && this.getWater() == 0) {
                    ((PlayerEntity)this.getEntity()).func_70097_a(ModDamageSource.DEHYDRATION, 1.0f);
                    this.waterTicks = 0;
                }
            } else if (this.waterTicks >= 800) {
                this.setWater(this.getWater() - 1);
                if (((PlayerEntity)this.getEntity()).func_70051_ag()) {
                    this.setWater(this.getWater() - 1);
                }
                if (this.getItemHandler().getStackInSlot(InventorySlotType.CLOTHING.getIndex()).getCapability(ModCapabilities.CLOTHING).map(IClothing::hasEnhancedProtection).orElse(false).booleanValue()) {
                    this.setWater(this.getWater() - 1);
                }
                this.waterTicks = 0;
            }
        }
    }

    private void updateEffects() {
        boolean invulnerable;
        boolean bl = invulnerable = ((PlayerEntity)this.getEntity()).field_71075_bZ.field_75102_a || ((PlayerEntity)this.getEntity()).field_70170_p.func_175659_aa() == Difficulty.PEACEFUL;
        if ((invulnerable || !((Boolean)CraftingDead.serverConfig.bleedingEnabled.get()).booleanValue()) && ((PlayerEntity)this.getEntity()).func_70644_a((Effect)ModEffects.BLEEDING.get())) {
            ((PlayerEntity)this.getEntity()).func_195063_d((Effect)ModEffects.BLEEDING.get());
        }
        if ((invulnerable || !((Boolean)CraftingDead.serverConfig.brokenLegsEnabled.get()).booleanValue()) && ((PlayerEntity)this.getEntity()).func_70644_a((Effect)ModEffects.BROKEN_LEG.get())) {
            ((PlayerEntity)this.getEntity()).func_195063_d((Effect)ModEffects.BROKEN_LEG.get());
        }
    }

    private void updateBrokenLeg() {
        if (!((PlayerEntity)this.getEntity()).func_184812_l_() && ((Boolean)CraftingDead.serverConfig.brokenLegsEnabled.get()).booleanValue() && ((PlayerEntity)this.getEntity()).field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && !((PlayerEntity)this.getEntity()).func_70644_a((Effect)ModEffects.BROKEN_LEG.get()) && ((PlayerEntity)this.getEntity()).func_233570_aj_() && !((PlayerEntity)this.getEntity()).func_70090_H() && (((PlayerEntity)this.getEntity()).field_70143_R > 4.0f && random.nextInt(3) == 0 || ((PlayerEntity)this.getEntity()).field_70143_R > 10.0f)) {
            ((PlayerEntity)this.getEntity()).func_146105_b((ITextComponent)new TranslationTextComponent("message.broken_leg").func_230530_a_(Style.field_240709_b_.func_240720_a_(new TextFormatting[]{TextFormatting.RED}).func_240713_a_(Boolean.valueOf(true))), true);
            ((PlayerEntity)this.getEntity()).func_195064_c(new EffectInstance((Effect)ModEffects.BROKEN_LEG.get(), 9999999, 4));
            ((PlayerEntity)this.getEntity()).func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 1));
        }
    }

    @Override
    public boolean isMovementBlocked() {
        return !((PlayerEntity)this.entity).func_175149_v() && super.isMovementBlocked();
    }

    @Override
    public boolean isCombatModeEnabled() {
        return !((PlayerEntity)this.entity).func_175149_v() && (this.cachedCombatModeEnabled || this.dataManager.get(COMBAT_MODE_ENABLED) != false);
    }

    @Override
    public void setCombatModeEnabled(boolean combatModeEnabled) {
        this.dataManager.set(COMBAT_MODE_ENABLED, combatModeEnabled);
    }

    @Override
    public void openEquipmentMenu() {
        if (MinecraftForge.EVENT_BUS.post((Event)new OpenEquipmentMenuEvent(this))) {
            return;
        }
        ((PlayerEntity)this.getEntity()).func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, playerEntity) -> new EquipmentContainer(windowId, ((PlayerEntity)this.getEntity()).field_71071_by), (ITextComponent)new TranslationTextComponent("container.equipment")));
    }

    @Override
    public void openStorage(InventorySlotType slotType) {
        ItemStack storageStack = this.getItemHandler().getStackInSlot(slotType.getIndex());
        storageStack.getCapability(ModCapabilities.STORAGE).ifPresent(storage -> ((PlayerEntity)this.getEntity()).func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((IContainerProvider)storage, storageStack.func_200301_q())));
    }

    @Override
    public boolean onDeath(DamageSource source) {
        if (super.onDeath(source)) {
            return true;
        }
        if (source instanceof IKillFeedProvider) {
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.ALL.noArg(), (Object)new KillFeedMessage(((IKillFeedProvider)source).createKillFeedEntry((PlayerEntity)this.entity)));
        }
        return false;
    }

    @Override
    public float onDamaged(DamageSource source, float amount) {
        boolean invulnerable;
        amount = super.onDamaged(source, amount);
        Entity immediateAttacker = source.func_76364_f();
        boolean isValidSource = immediateAttacker != null || source.func_94541_c();
        boolean bl = invulnerable = ((PlayerEntity)this.getEntity()).field_71075_bZ.field_75102_a || ((PlayerEntity)this.getEntity()).field_70170_p.func_175659_aa() == Difficulty.PEACEFUL;
        if (isValidSource && !invulnerable && ((Boolean)CraftingDead.serverConfig.bleedingEnabled.get()).booleanValue()) {
            float bleedChance = 0.1f * amount * this.getItemHandler().getStackInSlot(InventorySlotType.CLOTHING.getIndex()).getCapability(ModCapabilities.CLOTHING).map(clothing -> Float.valueOf(clothing.hasEnhancedProtection() ? 0.5f : 0.0f)).orElse(Float.valueOf(1.0f)).floatValue();
            if (random.nextFloat() < bleedChance && !((PlayerEntity)this.getEntity()).func_70644_a((Effect)ModEffects.BLEEDING.get())) {
                ((PlayerEntity)this.getEntity()).func_146105_b((ITextComponent)new TranslationTextComponent("message.bleeding").func_230530_a_(Style.field_240709_b_.func_240720_a_(new TextFormatting[]{TextFormatting.RED}).func_240713_a_(Boolean.valueOf(true))), true);
                ((PlayerEntity)this.getEntity()).func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 9999999));
            }
        }
        return amount;
    }

    @Override
    public void copyFrom(IPlayer<?> that, boolean wasDeath) {
        for (int i = 0; i < that.getItemHandler().getSlots() - 1; ++i) {
            this.getItemHandler().setStackInSlot(i, that.getItemHandler().getStackInSlot(i));
        }
        for (IPlayerExtension extension : this.extensions.values()) {
            extension.copyFrom(that, wasDeath);
        }
    }

    @Override
    public int getWater() {
        return this.dataManager.get(WATER);
    }

    @Override
    public void setWater(int water) {
        this.dataManager.set(WATER, Ints.constrainToRange((int)water, (int)0, (int)this.getMaxWater()));
    }

    @Override
    public int getMaxWater() {
        return this.dataManager.get(MAX_WATER);
    }

    @Override
    public void setMaxWater(int maxWater) {
        this.dataManager.set(MAX_WATER, maxWater);
    }

    public NetworkDataManager getDataManager() {
        return this.dataManager;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a("water", this.getWater());
        nbt.func_74768_a("maxWater", this.getMaxWater());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.setWater(nbt.func_74762_e("water"));
        this.setMaxWater(nbt.func_74762_e("maxWater"));
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        super.encode(out, writeAll);
        NetworkDataManager.writeEntries(writeAll ? this.dataManager.getAll() : this.dataManager.getDirty(), out);
    }

    @Override
    public void decode(PacketBuffer in) {
        super.decode(in);
        this.dataManager.setEntryValues(NetworkDataManager.readEntries(in));
    }

    @Override
    public boolean requiresSync() {
        return super.requiresSync() || this.dataManager.isDirty();
    }
}

