/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.mixin;

import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.living.ILivingExtension;
import com.craftingdead.core.living.Visibility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(method={"isInvisible"}, at={@At(value="HEAD")}, cancellable=true)
    private void isInvisible(CallbackInfoReturnable<Boolean> callbackInfo) {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && ILiving.getOptional((LivingEntity)entity).map(ILivingExtension::getVisibility).map(v -> v == Visibility.INVISIBLE || v == Visibility.PARTIALLY_VISIBLE).orElse(false).booleanValue()) {
            callbackInfo.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isInvisibleTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void isInvisibleTo(PlayerEntity playerEntity, CallbackInfoReturnable<Boolean> callbackInfo) {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            if (ILiving.getOptional((LivingEntity)entity).map(ILivingExtension::getVisibility).map(Visibility.PARTIALLY_VISIBLE::equals).orElse(false).booleanValue()) {
                callbackInfo.setReturnValue((Object)false);
            }
        }
    }
}

