/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.mixin;

import com.craftingdead.core.CraftingDead;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/model/ItemCameraTransforms$TransformType;ZLcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;IILnet/minecraft/client/renderer/model/IBakedModel;)V"}, cancellable=true)
    private void render(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, boolean leftHanded, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay, IBakedModel bakedModel, CallbackInfo callbackInfo) {
        if (this.renderItem(null, itemStack, transformType, leftHanded, matrixStack, renderTypeBuffer, packedLight, packedOverlay)) {
            callbackInfo.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderStatic(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/model/ItemCameraTransforms$TransformType;ZLcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;Lnet/minecraft/world/World;II)V"}, cancellable=true)
    private void renderStatic(@Nullable LivingEntity livingEntity, ItemStack itemStack, ItemCameraTransforms.TransformType transformType, boolean leftHanded, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, @Nullable World world, int packedLight, int packedOverlay, CallbackInfo callbackInfo) {
        if (this.renderItem(livingEntity, itemStack, transformType, leftHanded, matrixStack, renderTypeBuffer, packedLight, packedOverlay)) {
            callbackInfo.cancel();
        }
    }

    private boolean renderItem(@Nullable LivingEntity livingEntity, ItemStack itemStack, ItemCameraTransforms.TransformType transformType, boolean leftHanded, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        return CraftingDead.getInstance().getClientDist().getItemRendererManager().getItemRenderer(itemStack.func_77973_b()).filter(itemRenderer -> itemRenderer.handleRenderType(itemStack, transformType)).map(itemRenderer -> {
            itemRenderer.renderItem(itemStack, transformType, livingEntity, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
            return true;
        }).orElse(false);
    }
}

