/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.mixin;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.SyncGunEquipmentSlotMessage;
import com.craftingdead.core.util.IBufferSerializable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"isImmobile"}, cancellable=true)
    private void isImmobile(CallbackInfoReturnable<Boolean> callbackInfo) {
        LivingEntity livingEntity = (LivingEntity)this;
        ILiving.getOptional(livingEntity).ifPresent(living -> {
            if (!((Boolean)callbackInfo.getReturnValue()).booleanValue() && living.isMovementBlocked()) {
                callbackInfo.setReturnValue((Object)true);
            }
        });
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;matches(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z"), method={"collectEquipmentChanges"})
    private boolean matches(ItemStack currentStack, ItemStack lastStack) {
        if (!currentStack.equals(lastStack, true)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)this;
        for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
            if (currentStack != livingEntity.func_184582_a(slotType)) continue;
            currentStack.getCapability(ModCapabilities.GUN).filter(IBufferSerializable::requiresSync).ifPresent(gun -> NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), (Object)new SyncGunEquipmentSlotMessage(livingEntity.func_145782_y(), slotType, (IGun)gun, false)));
        }
        return true;
    }
}

