/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.network.util.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CrouchMessage {
    private final int entityId;
    private final boolean crouching;

    public CrouchMessage(int entityId, boolean crouching) {
        this.entityId = entityId;
        this.crouching = crouching;
    }

    public static void encode(CrouchMessage msg, PacketBuffer out) {
        out.func_150787_b(msg.entityId);
        out.writeBoolean(msg.crouching);
    }

    public static CrouchMessage decode(PacketBuffer in) {
        return new CrouchMessage(in.func_150792_a(), in.readBoolean());
    }

    public static boolean handle(CrouchMessage msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkUtil.getEntity(ctx.get(), msg.entityId).filter(entity -> entity instanceof LivingEntity).flatMap(entity -> entity.getCapability(ModCapabilities.LIVING).resolve()).ifPresent(living -> living.setCrouching(msg.crouching, ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()));
        return true;
    }
}

