/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.client.gui.HitMarker;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class HitMessage {
    private final Vector3d hitPos;
    private final boolean dead;

    public HitMessage(Vector3d hitPos, boolean dead) {
        this.hitPos = hitPos;
        this.dead = dead;
    }

    public static void encode(HitMessage msg, PacketBuffer out) {
        out.writeDouble(msg.hitPos.func_82615_a());
        out.writeDouble(msg.hitPos.func_82617_b());
        out.writeDouble(msg.hitPos.func_82616_c());
        out.writeBoolean(msg.dead);
    }

    public static HitMessage decode(PacketBuffer in) {
        return new HitMessage(new Vector3d(in.readDouble(), in.readDouble(), in.readDouble()), in.readBoolean());
    }

    public static boolean handle(HitMessage msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                ClientDist clientDist = CraftingDead.getInstance().getClientDist();
                ((HitMarker.Mode)((Object)((Object)ClientDist.clientConfig.hitMarkerMode.get()))).createHitMarker(msg.hitPos, msg.dead).ifPresent(clientDist.getIngameGui()::displayHitMarker);
                if (msg.dead && ((Boolean)ClientDist.clientConfig.killSoundEnabled.get()).booleanValue()) {
                    PlayerEntity playerEntity = (PlayerEntity)clientDist.getExpectedPlayer().getEntity();
                    SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)ClientDist.clientConfig.killSound.get()));
                    if (soundEvent != null) {
                        playerEntity.func_130014_f_().func_217384_a((PlayerEntity)clientDist.getExpectedPlayer().getEntity(), (Entity)playerEntity, soundEvent, SoundCategory.HOSTILE, 5.0f, 1.5f);
                    }
                }
            });
        }
        return true;
    }
}

