/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.util.KillFeedEntry;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class KillFeedMessage {
    private final int playerEntityId;
    private final int deadEntityId;
    private final ItemStack weaponStack;
    private final KillFeedEntry.Type type;

    public KillFeedMessage(KillFeedEntry entry) {
        this(entry.getKillerEntity().func_145782_y(), entry.getDeadEntity().func_145782_y(), entry.getWeaponStack(), entry.getType());
    }

    public KillFeedMessage(int playerEntityId, int deadEntityId, ItemStack weaponStack, KillFeedEntry.Type type) {
        this.playerEntityId = playerEntityId;
        this.deadEntityId = deadEntityId;
        this.weaponStack = weaponStack;
        this.type = type;
    }

    public static void encode(KillFeedMessage msg, PacketBuffer out) {
        out.func_150787_b(msg.playerEntityId);
        out.func_150787_b(msg.deadEntityId);
        out.func_150788_a(msg.weaponStack);
        out.func_179249_a((Enum)msg.type);
    }

    public static KillFeedMessage decode(PacketBuffer in) {
        return new KillFeedMessage(in.func_150792_a(), in.func_150792_a(), in.func_150791_c(), (KillFeedEntry.Type)in.func_179257_a(KillFeedEntry.Type.class));
    }

    public static boolean handle(KillFeedMessage msg, Supplier<NetworkEvent.Context> ctx) {
        Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(ctx.get().getDirection().getReceptionSide());
        world.ifPresent(w -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
            Entity playerEntity = w.func_73045_a(msg.playerEntityId);
            Entity deadEntity = w.func_73045_a(msg.deadEntityId);
            if (playerEntity instanceof PlayerEntity && deadEntity instanceof PlayerEntity) {
                CraftingDead.getInstance().getClientDist().getIngameGui().addKillFeedMessage(new KillFeedEntry((LivingEntity)((PlayerEntity)playerEntity), (LivingEntity)((PlayerEntity)deadEntity), msg.weaponStack, msg.type));
            }
        }));
        return true;
    }
}

