/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.action.ActionType;
import com.craftingdead.core.action.IAction;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.network.util.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PerformActionMessage {
    private final ActionType<?> actionType;
    private final int performerEntityId;
    private final int targetEntityId;

    public PerformActionMessage(ActionType<?> actionType, int performerEntityId, int targetEntityId) {
        this.actionType = actionType;
        this.performerEntityId = performerEntityId;
        this.targetEntityId = targetEntityId;
    }

    public static void encode(PerformActionMessage msg, PacketBuffer out) {
        out.writeRegistryId(msg.actionType);
        out.func_150787_b(msg.performerEntityId);
        out.func_150787_b(msg.targetEntityId);
    }

    public static PerformActionMessage decode(PacketBuffer in) {
        return new PerformActionMessage((ActionType)in.readRegistryId(), in.func_150792_a(), in.func_150792_a());
    }

    public static boolean handle(PerformActionMessage msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkUtil.getEntity(ctx.get(), msg.performerEntityId).ifPresent(performerEntity -> {
            ILiving performer = (ILiving)performerEntity.getCapability(ModCapabilities.LIVING).orElse(null);
            ILiving target = msg.targetEntityId == -1 ? null : (ILiving)performerEntity.func_130014_f_().func_73045_a(msg.targetEntityId).getCapability(ModCapabilities.LIVING).orElse(null);
            boolean isServer = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer();
            if (!isServer || msg.actionType.isTriggeredByClient()) {
                performer.performAction((IAction)msg.actionType.createAction(performer, target), isServer);
            }
        });
        return true;
    }
}

