/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.item.gun.FireMode;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.network.util.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetFireModeMessage {
    private final int entityId;
    private final FireMode fireMode;

    public SetFireModeMessage(int entityId, FireMode fireMode) {
        this.entityId = entityId;
        this.fireMode = fireMode;
    }

    public static void encode(SetFireModeMessage msg, PacketBuffer out) {
        out.func_150787_b(msg.entityId);
        out.func_179249_a((Enum)msg.fireMode);
    }

    public static SetFireModeMessage decode(PacketBuffer in) {
        return new SetFireModeMessage(in.func_150792_a(), (FireMode)in.func_179257_a(FireMode.class));
    }

    public static boolean handle(SetFireModeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkUtil.getEntity(ctx.get(), msg.entityId).filter(entity -> entity instanceof LivingEntity).ifPresent(entity -> {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack heldStack = livingEntity.func_184614_ca();
            livingEntity.getCapability(ModCapabilities.LIVING).ifPresent(arg_0 -> SetFireModeMessage.lambda$handle$2(heldStack, msg, (Supplier)ctx, arg_0));
        });
        return true;
    }

    private static /* synthetic */ void lambda$handle$2(ItemStack heldStack, SetFireModeMessage msg, Supplier ctx, ILiving living) {
        heldStack.getCapability(ModCapabilities.GUN).ifPresent(arg_0 -> SetFireModeMessage.lambda$handle$1(living, msg, (Supplier)ctx, arg_0));
    }

    private static /* synthetic */ void lambda$handle$1(ILiving living, SetFireModeMessage msg, Supplier ctx, IGun gun) {
        gun.setFireMode(living, msg.fireMode, ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer());
    }
}

