/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.item.gun.IGun;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncGunContainerSlotMessage {
    private final int entityId;
    private final int slot;
    private final PacketBuffer data;

    public SyncGunContainerSlotMessage(int entityId, int slot, IGun gun, boolean writeAll) {
        this(entityId, slot, new PacketBuffer(Unpooled.buffer()));
        gun.encode(this.data, writeAll);
    }

    public SyncGunContainerSlotMessage(int entityId, int slot, PacketBuffer data) {
        this.entityId = entityId;
        this.slot = slot;
        this.data = data;
    }

    public static void encode(SyncGunContainerSlotMessage message, PacketBuffer out) {
        out.func_150787_b(message.entityId);
        out.writeShort(message.slot);
        out.func_150787_b(message.data.readableBytes());
        out.writeBytes((ByteBuf)message.data);
    }

    public static SyncGunContainerSlotMessage decode(PacketBuffer in) {
        int entityId = in.func_150792_a();
        short slot = in.readShort();
        byte[] data = new byte[in.func_150792_a()];
        in.readBytes(data);
        return new SyncGunContainerSlotMessage(entityId, slot, new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
    }

    public static boolean handle(SyncGunContainerSlotMessage message, Supplier<NetworkEvent.Context> ctx) {
        Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(ctx.get().getDirection().getReceptionSide());
        world.map(w -> w.func_73045_a(message.entityId)).filter(e -> e instanceof PlayerEntity).map(e -> ((PlayerEntity)e).field_71069_bz.func_75139_a(message.slot).func_75211_c()).flatMap(itemStack -> itemStack.getCapability(ModCapabilities.GUN).resolve()).ifPresent(gun -> gun.decode(message.data));
        return true;
    }
}

