/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.item.gun.IGun;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncGunEquipmentSlotMessage {
    private final int entityId;
    private final EquipmentSlotType slot;
    private final PacketBuffer data;

    public SyncGunEquipmentSlotMessage(int entityId, EquipmentSlotType slot, IGun gun, boolean writeAll) {
        this(entityId, slot, new PacketBuffer(Unpooled.buffer()));
        gun.encode(this.data, writeAll);
    }

    public SyncGunEquipmentSlotMessage(int entityId, EquipmentSlotType slot, PacketBuffer data) {
        this.entityId = entityId;
        this.slot = slot;
        this.data = data;
    }

    public static void encode(SyncGunEquipmentSlotMessage message, PacketBuffer out) {
        out.func_150787_b(message.entityId);
        out.func_179249_a((Enum)message.slot);
        out.func_150787_b(message.data.readableBytes());
        out.writeBytes((ByteBuf)message.data);
    }

    public static SyncGunEquipmentSlotMessage decode(PacketBuffer in) {
        int entityId = in.func_150792_a();
        EquipmentSlotType slot = (EquipmentSlotType)in.func_179257_a(EquipmentSlotType.class);
        byte[] data = new byte[in.func_150792_a()];
        in.readBytes(data);
        return new SyncGunEquipmentSlotMessage(entityId, slot, new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
    }

    public static boolean handle(SyncGunEquipmentSlotMessage message, Supplier<NetworkEvent.Context> ctx) {
        Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(ctx.get().getDirection().getReceptionSide());
        world.map(w -> w.func_73045_a(message.entityId)).filter(e -> e instanceof LivingEntity).map(e -> ((LivingEntity)e).func_184582_a(message.slot)).flatMap(itemStack -> itemStack.getCapability(ModCapabilities.GUN).resolve()).ifPresent(gun -> gun.decode(message.data));
        return true;
    }
}

