/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.ModCapabilities;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncLivingMessage {
    private final int entityId;
    private final PacketBuffer data;

    public SyncLivingMessage(int entityId, PacketBuffer data) {
        this.entityId = entityId;
        this.data = data;
    }

    public static void encode(SyncLivingMessage msg, PacketBuffer out) {
        out.func_150787_b(msg.entityId);
        out.func_150787_b(msg.data.readableBytes());
        out.writeBytes((ByteBuf)msg.data);
    }

    public static SyncLivingMessage decode(PacketBuffer in) {
        int entityId = in.func_150792_a();
        byte[] data = new byte[in.func_150792_a()];
        in.readBytes(data);
        SyncLivingMessage msg = new SyncLivingMessage(entityId, new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
        return msg;
    }

    public static boolean handle(SyncLivingMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide());
            Entity entity = world.map(w -> w.func_73045_a(msg.entityId)).orElse(null);
            if (entity == null) {
                return;
            }
            entity.getCapability(ModCapabilities.LIVING).ifPresent(living -> living.decode(msg.data));
        });
        return true;
    }
}

