/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.network.util.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class TriggerPressedMessage {
    private final int entityId;
    private final boolean triggerPressed;

    public TriggerPressedMessage(int entityId, boolean triggerPressed) {
        this.entityId = entityId;
        this.triggerPressed = triggerPressed;
    }

    public static void encode(TriggerPressedMessage msg, PacketBuffer out) {
        out.func_150787_b(msg.entityId);
        out.writeBoolean(msg.triggerPressed);
    }

    public static TriggerPressedMessage decode(PacketBuffer in) {
        return new TriggerPressedMessage(in.func_150792_a(), in.readBoolean());
    }

    public static boolean handle(TriggerPressedMessage msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkUtil.getEntity(ctx.get(), msg.entityId).filter(entity -> entity instanceof LivingEntity).ifPresent(entity -> {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack heldStack = livingEntity.func_184614_ca();
            livingEntity.getCapability(ModCapabilities.LIVING).ifPresent(arg_0 -> TriggerPressedMessage.lambda$handle$2(heldStack, msg, (Supplier)ctx, arg_0));
        });
        return true;
    }

    private static /* synthetic */ void lambda$handle$2(ItemStack heldStack, TriggerPressedMessage msg, Supplier ctx, ILiving living) {
        heldStack.getCapability(ModCapabilities.GUN).ifPresent(arg_0 -> TriggerPressedMessage.lambda$handle$1(living, msg, (Supplier)ctx, arg_0));
    }

    private static /* synthetic */ void lambda$handle$1(ILiving living, TriggerPressedMessage msg, Supplier ctx, IGun gun) {
        gun.setTriggerPressed(living, msg.triggerPressed, ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer());
    }
}

