/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.item.gun.PendingHit;
import com.craftingdead.core.living.EntitySnapshot;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.living.IPlayer;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ValidatePendingHitMessage {
    private final Map<Integer, Collection<PendingHit>> hits;

    public ValidatePendingHitMessage(Map<Integer, Collection<PendingHit>> hits) {
        this.hits = hits;
    }

    public static void encode(ValidatePendingHitMessage msg, PacketBuffer out) {
        out.func_150787_b(msg.hits.size());
        for (Map.Entry<Integer, Collection<PendingHit>> hit : msg.hits.entrySet()) {
            out.func_150787_b(hit.getKey().intValue());
            out.func_150787_b(hit.getValue().size());
            for (PendingHit value : hit.getValue()) {
                out.writeByte((int)value.getTickOffset());
                value.getPlayerSnapshot().write(out);
                value.getHitSnapshot().write(out);
                out.func_179254_b(value.getRandomSeed());
            }
        }
    }

    public static ValidatePendingHitMessage decode(PacketBuffer in) {
        int hitsSize = in.func_150792_a();
        Int2ObjectLinkedOpenHashMap hits = new Int2ObjectLinkedOpenHashMap();
        for (int i = 0; i < hitsSize; ++i) {
            int key = in.func_150792_a();
            int valueSize = in.func_150792_a();
            ObjectArrayList value = new ObjectArrayList();
            for (int j = 0; j < valueSize; ++j) {
                value.add(new PendingHit(in.readByte(), EntitySnapshot.read(in), EntitySnapshot.read(in), in.func_179260_f()));
            }
            hits.put(key, value);
        }
        return new ValidatePendingHitMessage((Map<Integer, Collection<PendingHit>>)hits);
    }

    public static boolean handle(ValidatePendingHitMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity playerEntity = ctx.get().getSender();
        IPlayer<ServerPlayerEntity> player = IPlayer.getExpected(playerEntity);
        ItemStack heldStack = playerEntity.func_184614_ca();
        heldStack.getCapability(ModCapabilities.GUN).ifPresent(gun -> {
            for (Map.Entry<Integer, Collection<PendingHit>> hit : msg.hits.entrySet()) {
                Entity hitEntity = playerEntity.func_130014_f_().func_73045_a(hit.getKey().intValue());
                Optional.ofNullable(hitEntity).flatMap(e -> e.getCapability(ModCapabilities.LIVING).resolve()).ifPresent(hitLiving -> {
                    for (PendingHit value : (Collection)hit.getValue()) {
                        gun.validatePendingHit(player, (ILiving<?, ?>)hitLiving, value);
                    }
                });
            }
        });
        return true;
    }
}

