/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.util;

import com.google.common.collect.Lists;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;
import org.apache.commons.lang3.ObjectUtils;

public class NetworkDataManager {
    private final Map<Integer, DataEntry<?>> entries = new Int2ObjectArrayMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Runnable dirtyListener;
    private boolean empty = true;
    private boolean dirty;

    public NetworkDataManager() {
        this.dirtyListener = () -> {};
    }

    public NetworkDataManager(Runnable dirtyListener) {
        this.dirtyListener = dirtyListener;
    }

    public <T> void register(DataParameter<T> parameter, T value) {
        int id = parameter.func_187155_a();
        if (id > 254) {
            throw new IllegalArgumentException("Data parameter id is too big with " + id + "! (Max is 254)");
        }
        if (this.entries.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate id value for " + id + "!");
        }
        if (DataSerializers.func_187188_b((IDataSerializer)parameter.func_187156_b()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + parameter.func_187156_b() + " for " + id + "!");
        }
        this.setEntry(parameter, value);
    }

    private <T> void setEntry(DataParameter<T> parameter, T value) {
        DataEntry<T> entry = new DataEntry<T>(parameter, value);
        this.lock.writeLock().lock();
        this.entries.put(parameter.func_187155_a(), entry);
        this.empty = false;
        this.lock.writeLock().unlock();
    }

    private <T> DataEntry<T> getEntry(DataParameter<T> parameter) {
        DataEntry<?> entry;
        this.lock.readLock().lock();
        try {
            entry = this.entries.get(parameter.func_187155_a());
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Getting data entry");
            CrashReportCategory category = crashReport.func_85058_a("Getting data entry");
            category.func_71507_a("Data parameter ID", parameter);
            throw new ReportedException(crashReport);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return entry;
    }

    public <T> T get(DataParameter<T> parameter) {
        return this.getEntry(parameter).getValue();
    }

    public <T> void set(DataParameter<T> parameter, T value) {
        DataEntry<T> entry = this.getEntry(parameter);
        if (ObjectUtils.notEqual(value, entry.getValue())) {
            entry.setValue(value);
            entry.setDirty(true);
            this.markDirty();
        }
    }

    public <T> T getUpdate(DataParameter<T> parameter, Function<T, T> updater) {
        DataEntry<T> entry = this.getEntry(parameter);
        T newValue = updater.apply(entry.getValue());
        if (ObjectUtils.notEqual(newValue, entry.getValue())) {
            entry.setValue(newValue);
            entry.setDirty(true);
            this.markDirty();
        }
        return newValue;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void markDirty() {
        if (!this.dirty) {
            this.dirtyListener.run();
        }
        this.dirty = true;
    }

    public static void writeEntries(List<DataEntry<?>> entries, PacketBuffer buf) {
        if (entries != null) {
            for (DataEntry<?> entry : entries) {
                NetworkDataManager.writeEntry(buf, entry);
            }
        }
        buf.writeByte(255);
    }

    private static <T> void writeEntry(PacketBuffer out, DataEntry<T> entry) {
        DataParameter<T> parameter = entry.getKey();
        int i = DataSerializers.func_187188_b((IDataSerializer)parameter.func_187156_b());
        if (i < 0) {
            throw new EncoderException("Unknown serializer type " + parameter.func_187156_b());
        }
        out.writeByte(parameter.func_187155_a());
        out.func_150787_b(i);
        parameter.func_187156_b().func_187160_a(out, entry.getValue());
    }

    @Nullable
    public List<DataEntry<?>> getDirty() {
        ArrayList list = null;
        if (this.dirty) {
            this.lock.readLock().lock();
            for (DataEntry<?> enttry : this.entries.values()) {
                if (!enttry.isDirty()) continue;
                enttry.setDirty(false);
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(enttry.copy());
            }
            this.lock.readLock().unlock();
        }
        this.dirty = false;
        return list;
    }

    @Nullable
    public List<DataEntry<?>> getAll() {
        ArrayList list = null;
        this.lock.readLock().lock();
        for (DataEntry<?> entry : this.entries.values()) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(entry.copy());
        }
        this.lock.readLock().unlock();
        return list;
    }

    @Nullable
    public static List<DataEntry<?>> readEntries(PacketBuffer in) {
        short id;
        ArrayList entries = null;
        while ((id = in.readUnsignedByte()) != 255) {
            int j;
            IDataSerializer serializer;
            if (entries == null) {
                entries = Lists.newArrayList();
            }
            if ((serializer = DataSerializers.func_187190_a((int)(j = in.func_150792_a()))) == null) {
                throw new DecoderException("Unknown serializer type " + j);
            }
            entries.add(NetworkDataManager.readEntry(in, id, serializer));
        }
        return entries;
    }

    private static <T> DataEntry<T> readEntry(PacketBuffer buf, int id, IDataSerializer<T> serializer) {
        return new DataEntry<Object>(serializer.func_187161_a(id), serializer.func_187159_a(buf));
    }

    public void setEntryValues(@Nullable List<DataEntry<?>> entries) {
        if (entries == null) {
            return;
        }
        this.lock.writeLock().lock();
        for (DataEntry<?> entry : entries) {
            DataEntry<?> currentEntry = this.entries.get(entry.getKey().func_187155_a());
            if (currentEntry == null) continue;
            this.transferData(currentEntry, entry);
        }
        this.lock.writeLock().unlock();
    }

    private <T> void transferData(DataEntry<T> destination, DataEntry<?> source) {
        if (!Objects.equals(((DataEntry)source).parameter.func_187156_b(), ((DataEntry)destination).parameter.func_187156_b())) {
            throw new IllegalStateException(String.format("Data entry mismatch for %d: old=%s(%s), new=%s(%s)", ((DataEntry)destination).parameter.func_187155_a(), ((DataEntry)destination).value, ((DataEntry)destination).value.getClass(), ((DataEntry)source).value, ((DataEntry)source).value.getClass()));
        }
        destination.setValue(source.getValue());
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setClean() {
        this.dirty = false;
        this.lock.readLock().lock();
        for (DataEntry<?> entry : this.entries.values()) {
            entry.setDirty(false);
        }
        this.lock.readLock().unlock();
    }

    public static class DataEntry<T> {
        private final DataParameter<T> parameter;
        private T value;
        private boolean dirty;

        public DataEntry(DataParameter<T> parameter, T value) {
            this.parameter = parameter;
            this.value = value;
            this.dirty = true;
        }

        public DataParameter<T> getKey() {
            return this.parameter;
        }

        public void setValue(T valueIn) {
            this.value = valueIn;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirtyIn) {
            this.dirty = dirtyIn;
        }

        public DataEntry<T> copy() {
            return new DataEntry<Object>(this.parameter, this.parameter.func_187156_b().func_192717_a(this.value));
        }
    }
}

