/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;

public class ArbitraryTooltips {
    private static final Multimap<Supplier<Item>, TooltipFunction> TO_REGISTER = ArrayListMultimap.create();
    private static final Multimap<Item, TooltipFunction> REGISTERED_FUNCTIONS = ArrayListMultimap.create();

    public static void registerTooltip(Supplier<Item> item, TooltipFunction function) {
        TO_REGISTER.put(item, (Object)function);
    }

    public static void registerTooltip(Item item, TooltipFunction function) {
        REGISTERED_FUNCTIONS.put((Object)item, (Object)function);
    }

    public static void registerAll(RegistryEvent.Register<Item> event) {
        TO_REGISTER.asMap().forEach((supplier, lines) -> REGISTERED_FUNCTIONS.putAll((Object)((Item)supplier.get()), (Iterable)lines));
        TO_REGISTER.clear();
    }

    public static Collection<TooltipFunction> getFunctions(Item item) {
        return REGISTERED_FUNCTIONS.get((Object)item);
    }

    @FunctionalInterface
    public static interface TooltipFunction {
        @Nullable
        public ITextComponent createTooltip(ItemStack var1, @Nullable World var2, ITooltipFlag var3);
    }
}

