/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.util;

import com.craftingdead.core.util.MutableVector2f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class EntityUtil {
    private static final MutableVector2f ROTATIONS_TO_TARGET = new MutableVector2f();

    public static boolean isInsideFOV(LivingEntity viewer, Entity target, float fov) {
        EntityUtil.getRotationsToTarget(viewer, target, ROTATIONS_TO_TARGET);
        float yawToTarget = ROTATIONS_TO_TARGET.getX();
        float pitchToTarget = ROTATIONS_TO_TARGET.getY();
        float currentYaw = MathHelper.func_76142_g((float)viewer.field_70759_as);
        float currentPitch = MathHelper.func_76142_g((float)viewer.field_70125_A);
        float yawDifference = Math.abs(MathHelper.func_76142_g((float)(currentYaw - yawToTarget)));
        float pitchDifference = Math.abs(MathHelper.func_76142_g((float)(currentPitch - pitchToTarget)));
        boolean isInsideYaw = yawDifference <= fov;
        boolean isInsidePitch = pitchDifference <= fov;
        return isInsideYaw && isInsidePitch;
    }

    public static void getRotationsToTarget(LivingEntity viewer, Entity target, MutableVector2f result) {
        Vector3d entityVec = target.func_213303_ch();
        Vector3d livingVec = viewer.func_213303_ch();
        double xDiff = livingVec.field_72450_a - entityVec.field_72450_a;
        double zDiff = entityVec.field_72449_c - livingVec.field_72449_c;
        double yDiff = entityVec.field_72448_b + (double)target.func_70047_e() - (livingVec.field_72448_b + (double)viewer.func_70047_e());
        double distance2D = MathHelper.func_76133_a((double)(xDiff * xDiff + zDiff * zDiff));
        float yawToTarget = (float)(Math.atan2(xDiff, zDiff) * 180.0 / Math.PI);
        float pitchToTarget = (float)(-(Math.atan2(yDiff, distance2D) * 180.0 / Math.PI));
        result.set(MathHelper.func_76142_g((float)yawToTarget), MathHelper.func_76142_g((float)pitchToTarget));
    }
}

