/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.util;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class RayTraceUtil {
    public static List<Entity> filterEntities(Entity fromEntity, Vector3d scaledLook) {
        return fromEntity.func_130014_f_().func_175674_a(fromEntity, fromEntity.func_174813_aQ().func_216361_a(scaledLook).func_72314_b(1.0, 1.0, 1.0), entityTest -> {
            LivingEntity livingEntity;
            if (entityTest.func_175149_v() || !entityTest.func_70067_L()) {
                return false;
            }
            return !(entityTest instanceof LivingEntity) || !(livingEntity = (LivingEntity)entityTest).func_233643_dh_();
        });
    }

    public static Optional<EntityRayTraceResult> rayTraceEntities(Entity fromEntity) {
        ModifiableAttributeInstance reachDistanceAttribute = fromEntity instanceof PlayerEntity ? ((PlayerEntity)fromEntity).func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()) : null;
        double distance = reachDistanceAttribute == null ? 4.0 : reachDistanceAttribute.func_111126_e();
        Vector3d start = fromEntity.func_174824_e(1.0f);
        Vector3d look = fromEntity.func_70676_i(1.0f);
        Vector3d scaledLook = look.func_186678_a(distance);
        Vector3d end = start.func_178787_e(scaledLook);
        return RayTraceUtil.rayTraceEntities(fromEntity, start, end, RayTraceUtil.filterEntities(fromEntity, scaledLook), distance * distance);
    }

    public static Optional<EntityRayTraceResult> rayTraceEntities(Entity fromEntity, Vector3d start, Vector3d end, Iterable<Entity> entities, double sqrDistance) {
        Entity finalHitEntity = null;
        Vector3d finalHitVec = null;
        double sqrDistanceToLastHit = sqrDistance;
        for (Entity otherEntity : entities) {
            Vector3d hitVec;
            double sqrDistanceToHit;
            AxisAlignedBB otherEntityCollisionBox = otherEntity.func_174813_aQ().func_186662_g((double)otherEntity.func_70111_Y());
            Optional potentialHit = otherEntityCollisionBox.func_216365_b(start, end);
            if (otherEntityCollisionBox.func_72318_a(start) && sqrDistanceToLastHit >= 0.0) {
                finalHitEntity = otherEntity;
                finalHitVec = potentialHit.orElse(start);
                sqrDistanceToLastHit = 0.0;
                continue;
            }
            if (!potentialHit.isPresent() || !((sqrDistanceToHit = start.func_72436_e(hitVec = (Vector3d)potentialHit.get())) < sqrDistanceToLastHit) && sqrDistanceToLastHit != 0.0) continue;
            if (otherEntity.func_184208_bv() == fromEntity.func_184208_bv()) {
                if (sqrDistanceToHit != 0.0) continue;
                finalHitEntity = otherEntity;
                finalHitVec = hitVec;
                continue;
            }
            finalHitEntity = otherEntity;
            finalHitVec = hitVec;
            sqrDistanceToLastHit = sqrDistanceToHit;
        }
        return Optional.ofNullable(finalHitEntity != null ? new EntityRayTraceResult(finalHitEntity, finalHitVec) : null);
    }

    public static Optional<BlockRayTraceResult> rayTraceBlocks(LivingEntity fromEntity, RayTraceContext.FluidMode fluidMode, double distance, float partialTicks) {
        Vector3d start = fromEntity.func_174824_e(partialTicks);
        Vector3d look = fromEntity.func_70676_i(partialTicks);
        Vector3d scaledLook = look.func_186678_a(distance);
        Vector3d end = start.func_178787_e(scaledLook);
        return Optional.ofNullable(fromEntity.field_70170_p.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, fluidMode, (Entity)fromEntity)));
    }

    public static Optional<? extends RayTraceResult> rayTrace(Entity fromEntity, double distance, float accuracy, int shotCount, Random random) {
        return RayTraceUtil.rayTrace(fromEntity, distance, 1.0f, RayTraceUtil.getAccuracyOffset(accuracy, shotCount, random), RayTraceUtil.getAccuracyOffset(accuracy, shotCount, random));
    }

    public static float getAccuracyOffset(float accuracy, int shotCount, Random random) {
        return (1.0f - accuracy * accuracy) * ((float)Math.min(20, shotCount + 1) / 2.0f) * ((1.0f - accuracy) * (float)(random.nextInt(9) + 1)) * (random.nextInt(5) % 2 == 0 ? -1.0f : 1.0f);
    }

    public static Optional<? extends RayTraceResult> rayTrace(Entity fromEntity, double distance, float partialTicks, float pitchOffset, float yawOffset) {
        Vector3d start = fromEntity.func_174824_e(partialTicks);
        Vector3d look = RayTraceUtil.getVectorForRotation(fromEntity.func_195050_f(partialTicks) + pitchOffset, fromEntity.func_195046_g(partialTicks) + yawOffset);
        Vector3d scaledLook = look.func_186678_a(distance);
        Vector3d end = start.func_178787_e(scaledLook);
        Optional<BlockRayTraceResult> blockRayTraceResult = RayTraceUtil.rayTraceBlocksPiercing(start, distance, look, fromEntity.field_70170_p);
        double sqrDistance = blockRayTraceResult.isPresent() ? blockRayTraceResult.get().func_216347_e().func_72436_e(start) : distance * distance;
        Optional<EntityRayTraceResult> entityRayTraceResult = RayTraceUtil.rayTraceEntities(fromEntity, start, end, RayTraceUtil.filterEntities(fromEntity, scaledLook), sqrDistance);
        return entityRayTraceResult.isPresent() ? entityRayTraceResult : blockRayTraceResult;
    }

    public static Optional<BlockRayTraceResult> rayTraceBlocksPiercing(Vector3d start, double distance, Vector3d look, World world) {
        return RayTraceUtil.rayTraceBlocksPiercing(start, distance, look, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, world);
    }

    public static Optional<BlockRayTraceResult> rayTraceBlocksPiercing(Vector3d start, double distance, Vector3d look, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, World world) {
        Vector3d newStart = start;
        Vector3d end = start.func_178787_e(look.func_186678_a(distance));
        boolean pierceableBlock = false;
        BlockRayTraceResult blockRayTraceResult = null;
        BlockPos lastBlockPos = null;
        while (!(newStart.func_72438_d(start) >= distance)) {
            RayTraceContext context = new RayTraceContext(newStart, end, blockMode, fluidMode, null);
            blockRayTraceResult = world.func_217299_a(context);
            if (blockRayTraceResult != null) {
                BlockPos blockPos = blockRayTraceResult.func_216350_a();
                if (lastBlockPos != null && lastBlockPos.equals((Object)blockPos)) break;
                lastBlockPos = blockPos;
                BlockState blockState = world.func_180495_p(blockPos);
                boolean bl = pierceableBlock = !blockState.func_200132_m();
                if (pierceableBlock) {
                    Vector3d hitVec = blockRayTraceResult.func_216347_e();
                    VoxelShape shape = context.func_222251_a(blockState, (IBlockReader)world, blockPos);
                    if (!shape.func_197766_b()) {
                        AxisAlignedBB bb = shape.func_197752_a();
                        double xDist = look.func_82615_a() < 0.0 ? hitVec.func_82615_a() - bb.field_72340_a - (double)blockPos.func_177958_n() : (double)blockPos.func_177958_n() - hitVec.func_82615_a() + bb.field_72336_d;
                        double yDist = look.func_82617_b() < 0.0 ? hitVec.func_82617_b() - bb.field_72338_b - (double)blockPos.func_177956_o() : (double)blockPos.func_177956_o() - hitVec.func_82617_b() + bb.field_72337_e;
                        double zDist = look.func_82616_c() < 0.0 ? hitVec.func_82616_c() - bb.field_72339_c - (double)blockPos.func_177952_p() : (double)blockPos.func_177952_p() - hitVec.func_82616_c() + bb.field_72334_f;
                        double xRayDist = Math.abs(look.func_82615_a()) != 0.0 ? xDist / Math.abs(look.func_82615_a()) : Double.MAX_VALUE;
                        double yRayDist = Math.abs(look.func_82617_b()) != 0.0 ? yDist / Math.abs(look.func_82617_b()) : Double.MAX_VALUE;
                        double zRayDist = Math.abs(look.func_82616_c()) != 0.0 ? zDist / Math.abs(look.func_82616_c()) : Double.MAX_VALUE;
                        double rayDist = Math.min(xRayDist, Math.min(zRayDist, yRayDist));
                        newStart = hitVec.func_178787_e(look.func_186678_a(rayDist));
                    }
                }
            }
            if (pierceableBlock) continue;
        }
        return Optional.ofNullable(blockRayTraceResult);
    }

    public static Vector3d getVectorForRotation(float pitch, float yaw) {
        float pitchRad = pitch * ((float)Math.PI / 180);
        float yawRad = -yaw * ((float)Math.PI / 180);
        float yawCos = MathHelper.func_76134_b((float)yawRad);
        float yawSin = MathHelper.func_76126_a((float)yawRad);
        float pitchCos = MathHelper.func_76134_b((float)pitchRad);
        float pitchSin = MathHelper.func_76126_a((float)pitchRad);
        return new Vector3d((double)(yawSin * pitchCos), (double)(-pitchSin), (double)(yawCos * pitchCos));
    }
}

