/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.FolderName;
import org.lwjgl.opengl.GL11;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.MapLimiter;
import xaero.map.MapRunner;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.controls.ControlsRegister;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.RegionDetection;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.graphics.TextureUploader;
import xaero.map.gui.GuiMap;
import xaero.map.mcworld.WorldMapClientWorldData;
import xaero.map.mcworld.WorldMapClientWorldDataHelper;
import xaero.map.pool.MapTilePool;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;
import xaero.map.task.MapRunnerTask;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapProcessor {
    public static final int DEFAULT_LIGHT_LEVELS = 4;
    private MapSaveLoad mapSaveLoad;
    private MapWriter mapWriter;
    private MapLimiter mapLimiter;
    private WorldDataHandler worldDataHandler;
    private ByteBufferDeallocator bufferDeallocator;
    private TextureUploader textureUploader;
    private ClientWorld world;
    public MutableRegistry<Biome> worldBiomeRegistry;
    private ClientWorld newWorld;
    public MutableRegistry<Biome> newWorldBiomeRegistry;
    public final Object mainStuffSync;
    public ClientWorld mainWorld;
    public MutableRegistry<Biome> mainWorldBiomeRegistry;
    public double mainPlayerX;
    public double mainPlayerY;
    public double mainPlayerZ;
    private boolean mainWorldUnloaded;
    private ArrayList<Double[]> footprints = new ArrayList();
    private int footprintsTimer;
    private boolean mapWorldUsable;
    private MapWorld mapWorld;
    private String currentWorldString;
    private String currentWorldStringNoDim;
    private boolean mapWorldUsableRequest;
    private boolean caveStartDetermined;
    private int caveStart;
    public final Object renderThreadPauseSync = new Object();
    private int pauseUploading;
    private int pauseRendering;
    private int pauseWriting;
    public final Object processorThreadPauseSync = new Object();
    private int pauseProcessing;
    public final Object loadingSync = new Object();
    public final Object uiSync = new Object();
    private boolean waitingForWorldUpdate;
    private ArrayList<MapRegion> toProcess = new ArrayList();
    private ArrayList<MapRegion> toRefresh = new ArrayList();
    private static final int SPAWNPOINT_TIMEOUT = 3000;
    private BlockPos spawnToRestore;
    private long mainWorldChangedTime = -1L;
    private MapTilePool tilePool;
    private boolean currentMapNeedsDeletion;
    private OverlayManager overlayManager;
    private long renderStartTime;
    private Field scheduledTasksField;
    private Runnable renderStartTimeUpdaterRunnable;
    private int state;
    private String[] dimensionsToIgnore = new String[]{"FZHammer"};
    public Field selectedField = null;

    public MapProcessor(MapSaveLoad mapSaveLoad, MapWriter mapWriter, MapLimiter mapLimiter, ByteBufferDeallocator bufferDeallocator, MapTilePool tilePool, OverlayManager overlayManager, TextureUploader textureUploader, WorldDataHandler worldDataHandler) throws NoSuchFieldException {
        this.mapSaveLoad = mapSaveLoad;
        this.mapWriter = mapWriter;
        this.mapLimiter = mapLimiter;
        this.bufferDeallocator = bufferDeallocator;
        this.tilePool = tilePool;
        this.overlayManager = overlayManager;
        this.textureUploader = textureUploader;
        this.worldDataHandler = worldDataHandler;
        try {
            this.scheduledTasksField = Minecraft.class.getDeclaredField("field_213275_aU");
        }
        catch (Exception e) {
            this.scheduledTasksField = Minecraft.class.getDeclaredField("queueChunkTracking");
        }
        this.renderStartTimeUpdaterRunnable = new Runnable(){

            @Override
            public void run() {
                MapProcessor.this.updateRenderStartTime();
            }
        };
        this.mainStuffSync = new Object();
        this.caveStart = -1;
    }

    public void onInit() {
        this.mapWorld = new MapWorld(this.getMainId(), this);
        this.mapWorld.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(MapRunner runner) {
        if (this.state < 2) {
            try {
                while (this.state < 2 && WorldMap.crashHandler.getCrashedBy() == null) {
                    Object object = this.processorThreadPauseSync;
                    synchronized (object) {
                        if (!this.isProcessingPaused()) {
                            this.updateWorld();
                            if (this.world != null) {
                                this.updateCaveStart(this.mainPlayerX, this.mainPlayerZ, (World)this.world);
                                this.updateFootprints((World)this.world, Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? 1 : 10);
                            }
                            if (this.mapWorldUsable) {
                                this.mapLimiter.applyLimit(this.mapWorld.getCurrentDimension().getMapRegionsList(), this);
                                for (int i = 0; i < this.toProcess.size(); ++i) {
                                    MapRegion region = this.toProcess.get(i);
                                    this.mapSaveLoad.updateSave(region);
                                }
                            }
                            this.mapSaveLoad.run((World)this.world);
                            this.handleRefresh((World)this.world);
                            runner.doTasks(this);
                        }
                    }
                    try {
                        Thread.sleep(this.world == null || Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? 100L : 1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
            if (this.state < 2) {
                this.forceClean();
            }
        }
    }

    public int getDebugFPS(Minecraft mc) {
        int debugFPS;
        String fpsString = mc.field_71426_K.split(" ")[0];
        try {
            debugFPS = Integer.parseInt(fpsString);
        }
        catch (NumberFormatException nfe) {
            if (fpsString.contains("/")) {
                debugFPS = Integer.parseInt(fpsString.split("/")[0]);
            }
            throw nfe;
        }
        return debugFPS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRenderProcess(Minecraft mc) throws RuntimeException {
        this.mapWriter.onRender();
        try {
            Object object = this.renderThreadPauseSync;
            synchronized (object) {
                if (this.pauseUploading == 0 && this.mapWorldUsable) {
                    while (GL11.glGetError() != 0) {
                    }
                    RenderSystem.pixelStore((int)3317, (int)4);
                    RenderSystem.pixelStore((int)3316, (int)0);
                    RenderSystem.pixelStore((int)3315, (int)0);
                    RenderSystem.pixelStore((int)3314, (int)0);
                    int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                    boolean detailedDebug = WorldMap.settings.detailed_debug;
                    int debugFPS = this.getDebugFPS(mc);
                    long uploadStart = System.nanoTime();
                    long passed = uploadStart - this.renderStartTime;
                    long time60FPS = 16666666L;
                    long totalTime = debugFPS <= 0 || debugFPS > 50 && debugFPS < 65 ? time60FPS : (long)(1000000000 / debugFPS);
                    long timeAvailable = Math.max(3000000L, totalTime - passed);
                    long uploadUntil = uploadStart + timeAvailable / 4L;
                    long gpuLimit = Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? Math.max(1000000L, totalTime * 5L / 12L) : Math.min(totalTime / 5L, timeAvailable);
                    for (int i = 0; i < this.toProcess.size(); ++i) {
                        MapRegion region;
                        Object object2 = this.toProcess;
                        synchronized (object2) {
                            if (i >= this.toProcess.size()) {
                                break;
                            }
                            region = this.toProcess.get(i);
                        }
                        if (region == null || region.getWorld() == null || !region.getWorld().equals(this.currentWorldString)) continue;
                        object2 = region;
                        synchronized (object2) {
                            if (region.getLoadState() < 4) {
                                boolean isRefreshing = region.isRefreshing();
                                boolean allCleaned = true;
                                boolean allCached = true;
                                boolean allUploaded = true;
                                boolean isEmpty = true;
                                boolean hasLoadedChunks = false;
                                for (int x = 0; x < 8; ++x) {
                                    for (int z = 0; z < 8; ++z) {
                                        MapTileChunk chunk = region.getChunk(x, z);
                                        if (chunk == null) continue;
                                        isEmpty = false;
                                        if (chunk.getLoadState() >= 2) {
                                            hasLoadedChunks = true;
                                            if (gpuLimit > 0L && System.nanoTime() < uploadUntil) {
                                                Object object3;
                                                if (chunk.getToUpdateBuffers() && !this.isWritingPaused()) {
                                                    object3 = region.writerThreadPauseSync;
                                                    synchronized (object3) {
                                                        if (!region.isWritingPaused()) {
                                                            chunk.updateBuffers((World)this.world, this, this.worldBiomeRegistry, detailedDebug);
                                                        }
                                                    }
                                                }
                                                object3 = chunk;
                                                synchronized (object3) {
                                                    if (chunk.shouldUpload()) {
                                                        if (chunk.getTimer() == 0) {
                                                            long estimatedGPUTime = chunk.uploadBuffer(this.textureUploader);
                                                            gpuLimit -= estimatedGPUTime;
                                                            if (!chunk.shouldDownloadFromPBO()) {
                                                                chunk.setToUpload(false);
                                                                if (chunk.getColorBufferFormat() == -1) {
                                                                    chunk.deleteBuffers();
                                                                } else {
                                                                    chunk.setCachePrepared(true);
                                                                }
                                                            }
                                                        } else {
                                                            chunk.decTimer();
                                                        }
                                                    }
                                                }
                                            }
                                            if (!(region.getLoadState() < 2 || region.isBeingWritten() || region.getLastVisited() != 0L && region.getTimeSinceVisit() <= 1000L || isRefreshing || chunk.getToUpdateBuffers() || chunk.getLoadState() == 3)) {
                                                region.setLoadState((byte)3);
                                                chunk.setLoadState((byte)3);
                                                chunk.clean(this);
                                            }
                                        }
                                        if (chunk.getLoadState() != 3) {
                                            allCleaned = false;
                                        }
                                        if (!chunk.isCachePrepared()) {
                                            allCached = false;
                                        }
                                        if (!chunk.shouldUpload() && !chunk.getToUpdateBuffers()) continue;
                                        allUploaded = false;
                                    }
                                }
                                if (hasLoadedChunks && region.getCacheHashCode() != globalRegionCacheHashCode) {
                                    region.setVersion(Math.max(0, region.getVersion() - 1));
                                }
                                allUploaded = allUploaded && region.getLoadState() >= 2 && !isRefreshing;
                                boolean bl = allCached = allCached && allUploaded && !isEmpty;
                                if ((!region.shouldCache() || !region.recacheHasBeenRequested()) && region.getLoadState() == 3 && allCleaned && allUploaded) {
                                    region.setLoadState((byte)4);
                                    region.destroyBufferUpdateObjects();
                                    region.deleteGLBuffers();
                                    ArrayList<MapRegion> arrayList = this.toProcess;
                                    synchronized (arrayList) {
                                        if (i < this.toProcess.size()) {
                                            this.toProcess.remove(i);
                                            --i;
                                        }
                                    }
                                    if (WorldMap.settings.debug) {
                                        WorldMap.LOGGER.info("Region freed: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + this.mapWriter.getUpdateCounter() + " " + this.currentWorldString);
                                    }
                                }
                                if (allCached && !region.isAllCachePrepared()) {
                                    region.setAllCachePrepared(true);
                                }
                                if (region.shouldCache() && region.isAllCachePrepared() && !isRefreshing) {
                                    this.getMapSaveLoad().requestCache(region);
                                }
                            }
                            continue;
                        }
                    }
                    this.textureUploader.uploadTextures();
                }
            }
            this.mapLimiter.updateAvailableVRAM();
        }
        catch (Throwable e) {
            WorldMap.crashHandler.setCrashedBy(e);
        }
        WorldMap.crashHandler.checkForCrashes();
    }

    public boolean ignoreWorld(World world) {
        for (int i = 0; i < this.dimensionsToIgnore.length; ++i) {
            if (!this.dimensionsToIgnore[i].equals(world.func_234923_W_().func_240901_a_().func_110623_a())) continue;
            return true;
        }
        return false;
    }

    public String getDimensionName(RegistryKey<World> id) {
        if (id == World.field_234918_g_) {
            return "null";
        }
        if (id == World.field_234919_h_) {
            return "DIM-1";
        }
        if (id == World.field_234920_i_) {
            return "DIM1";
        }
        ResourceLocation identifier = id.func_240901_a_();
        return identifier.func_110624_b() + "$" + identifier.func_110623_a().replace('/', '%');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeWorld(ClientWorld world, MutableRegistry<Biome> biomeRegistry) {
        this.pushWriterPause();
        Object object = this.loadingSync;
        synchronized (object) {
            this.waitingForWorldUpdate = true;
        }
        this.newWorld = world;
        this.newWorldBiomeRegistry = biomeRegistry;
        if (world == null) {
            this.mapWorldUsableRequest = false;
        } else {
            this.mapWorldUsableRequest = true;
            RegistryKey dimId = world.func_234923_W_();
            Object autoIdBase = this.getAutoIdBase(world);
            MapDimension mapDimension = this.mapWorld.getDimension((RegistryKey<World>)dimId);
            if (mapDimension == null) {
                mapDimension = this.mapWorld.createDimensionUnsynced((RegistryKey<World>)dimId);
            }
            this.mapWorld.setFutureDimensionId((RegistryKey<World>)dimId);
            mapDimension.updateFutureAutomaticUnsynced(Minecraft.func_71410_x(), autoIdBase);
            mapDimension.resetCustomMultiworldUnsynced();
        }
        this.popWriterPause();
    }

    private String getMainId() {
        Minecraft mc = Minecraft.func_71410_x();
        String result = null;
        if (mc.func_71401_C() != null) {
            result = mc.func_71401_C().func_240776_a_(FolderName.field_237253_i_).getParent().getFileName().toString().replaceAll("_", "^us^") + "_%DIMENSION%";
            if (this.isWorldMultiplayer(this.isWorldRealms(result), result)) {
                result = "^e^" + result;
            }
        } else if (mc.func_181540_al() && WorldMap.events.getLatestRealm() != null) {
            result = "Realms_" + WorldMap.events.getLatestRealm().field_230588_g_ + "." + WorldMap.events.getLatestRealm().field_230582_a_ + "_%DIMENSION%";
        } else if (mc.func_147104_D() != null) {
            String serverIP;
            String string = serverIP = WorldMap.settings.differentiateByServerAddress ? mc.func_147104_D().field_78845_b : "Any Address";
            if (serverIP.contains(":")) {
                serverIP = serverIP.substring(0, serverIP.indexOf(":"));
            }
            result = "Multiplayer_" + serverIP.replaceAll(":", "\u00a7") + "_%DIMENSION%";
        } else {
            result = "Multiplayer_Unknown_%DIMENSION%";
        }
        return result;
    }

    public synchronized void toggleMultiworldType(MapDimension dim) {
        if (this.mapWorldUsable && !this.waitingForWorldUpdate && this.mapWorld.isMultiplayer() && this.mapWorld.getCurrentDimension() == dim) {
            this.mapWorld.toggleMultiworldTypeUnsynced();
        }
    }

    public synchronized void quickConfirmMultiworld() {
        if (this.mapWorldUsable && this.mapWorld.getCurrentDimension().hasConfirmedMultiworld()) {
            this.confirmMultiworld(this.mapWorld.getCurrentDimension());
        }
    }

    public synchronized boolean confirmMultiworld(MapDimension dim) {
        if (this.mapWorldUsable && this.mapWorld.isMultiplayer() && this.mainWorld != null && this.mainWorld.func_234923_W_() == this.mapWorld.getCurrentDimensionId() && this.mapWorld.getCurrentDimension() == dim) {
            this.mapWorld.confirmMultiworldTypeUnsynced();
            this.mapWorld.getCurrentDimension().confirmMultiworldUnsynced();
            return true;
        }
        return false;
    }

    public synchronized void setMultiworld(MapDimension dimToCompare, String customMW) {
        if (this.mapWorldUsable && this.mapWorld.isMultiplayer() && dimToCompare == this.mapWorld.getCurrentDimension()) {
            this.mapWorld.getCurrentDimension().setMultiworldUnsynced(customMW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCrosshairMessage() {
        Object object = this.uiSync;
        synchronized (object) {
            if (this.mapWorldUsable && !this.mapWorld.getCurrentDimension().futureMultiworldWritable && this.mainWorld.func_234923_W_() == this.mapWorld.getCurrentDimensionId()) {
                String selectedMWName = this.mapWorld.getCurrentDimension().getMultiworldName(this.mapWorld.getCurrentDimension().getFutureMultiworldUnsynced());
                String message = "\u00a72(" + ControlsRegister.keyOpenMap.func_238171_j_().getString().toUpperCase() + ")\u00a7r " + I18n.func_135052_a((String)"gui.xaero_map_unconfirmed", (Object[])new Object[0]);
                if (this.mapWorld.getCurrentDimension().hasConfirmedMultiworld()) {
                    message = message + " \u00a72" + ControlsRegister.keyQuickConfirm.func_238171_j_().getString().toUpperCase() + "\u00a7r for map \"" + selectedMWName + "\"";
                }
                return message;
            }
        }
        return null;
    }

    private synchronized void checkForWorldUpdate() {
        Object autoIdBase;
        if (this.mainWorld != null && (autoIdBase = this.getAutoIdBase(this.mainWorld)) != null) {
            Object updatedAutoIdBase;
            MapDimension mapDimension;
            boolean baseChanged;
            boolean bl = baseChanged = !autoIdBase.equals(this.getUsedAutoIdBase(this.mainWorld));
            if (baseChanged && this.mapWorldUsable && (mapDimension = this.mapWorld.getDimension((RegistryKey<World>)this.mainWorld.func_234923_W_())) != null) {
                mapDimension.updateFutureAutomaticUnsynced(Minecraft.func_71410_x(), autoIdBase);
            }
            if (this.mainWorld != this.world) {
                this.changeWorld(this.mainWorld, this.mainWorldBiomeRegistry);
            }
            if ((updatedAutoIdBase = this.getAutoIdBase(this.mainWorld)) != null) {
                this.setUsedAutoIdBase(this.mainWorld, updatedAutoIdBase);
            } else {
                this.removeUsedAutoIdBase(this.mainWorld);
            }
        }
    }

    private void updateWorld() throws IOException, CommandSyntaxException {
        this.updateWorldSynced();
        if (this.mapWorldUsable && !this.mapSaveLoad.isRegionDetectionComplete()) {
            this.mapSaveLoad.detectRegions();
            this.mapSaveLoad.setRegionDetectionComplete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateWorldSynced() throws IOException, CommandSyntaxException {
        Object object = this.uiSync;
        synchronized (object) {
            if (this.mapWorldUsable != this.mapWorldUsableRequest || this.mapWorldUsableRequest && (this.mapWorld.getFutureDimension() != this.mapWorld.getCurrentDimension() || !this.mapWorld.getFutureDimension().getFutureMultiworldUnsynced().equals(this.mapWorld.getFutureDimension().getCurrentMultiworld()))) {
                String newMultiworldId = !this.mapWorldUsableRequest ? null : this.mapWorld.getFutureMultiworldUnsynced();
                this.pushRenderPause(true, true);
                this.pushWriterPause();
                String newWorldStringNoDim = !this.mapWorldUsableRequest ? null : this.mapWorld.getMainIdNoDim() + (!this.mapWorld.isMultiplayer() ? "" : "_" + newMultiworldId);
                boolean shouldClearAllDimensions = this.state == 1;
                boolean shouldClearNewDimension = this.mapWorldUsableRequest && !this.mapWorld.getFutureMultiworldUnsynced().equals(this.mapWorld.getFutureDimension().getCurrentMultiworld());
                this.mapSaveLoad.getToSave().clear();
                if (this.mapWorld.getCurrentDimensionId() != null) {
                    MapDimension currentDim = this.mapWorld.getCurrentDimension();
                    MapDimension mapDimension = !this.mapWorldUsableRequest ? null : this.mapWorld.getFutureDimension();
                    boolean shouldFinishCurrentDim = this.mapWorldUsable && !this.currentMapNeedsDeletion;
                    boolean currentDimChecked = false;
                    if (shouldFinishCurrentDim) {
                        this.mapSaveLoad.saveAll = true;
                    }
                    if (shouldFinishCurrentDim || shouldClearNewDimension && mapDimension == currentDim) {
                        for (MapRegion region : currentDim.getMapRegionsList()) {
                            if (shouldFinishCurrentDim) {
                                if (region.recacheHasBeenRequested() && region.getCacheFile() != null) {
                                    Files.deleteIfExists(region.getCacheFile().toPath());
                                    if (WorldMap.settings.debug) {
                                        WorldMap.LOGGER.info(String.format("Deleting cache for region %s because it might be outdated.", region));
                                    }
                                }
                                region.setReloadHasBeenRequested(false, "world/dim change");
                                if (region.getLoadState() == 2) {
                                    if (region.isBeingWritten()) {
                                        this.mapSaveLoad.getToSave().add(region);
                                    } else {
                                        region.clearRegion(this);
                                    }
                                } else {
                                    region.setBeingWritten(false);
                                    if (region.isRefreshing()) {
                                        throw new RuntimeException("Detected non-loadstate 2 region with refreshing value being true.");
                                    }
                                }
                            }
                            if (!shouldClearAllDimensions && (!shouldClearNewDimension || mapDimension != currentDim)) continue;
                            region.deleteTexturesAndBuffers();
                        }
                        currentDimChecked = true;
                    }
                    if (mapDimension != currentDim && shouldClearNewDimension) {
                        for (MapRegion region : mapDimension.getMapRegionsList()) {
                            region.deleteTexturesAndBuffers();
                        }
                    }
                    if (shouldClearAllDimensions) {
                        for (MapDimension dim : this.mapWorld.getDimensionsList()) {
                            if (currentDimChecked && dim == currentDim) continue;
                            for (MapRegion region : dim.getMapRegionsList()) {
                                region.deleteTexturesAndBuffers();
                            }
                        }
                    }
                    if (this.currentMapNeedsDeletion) {
                        this.mapWorld.getCurrentDimension().deleteMultiworldMapDataUnsynced(this.mapWorld.getCurrentDimension().getCurrentMultiworld());
                    }
                }
                this.currentMapNeedsDeletion = false;
                if (shouldClearAllDimensions) {
                    if (this.mapWorld.getCurrentDimensionId() != null) {
                        for (MapDimension mapDimension : this.mapWorld.getDimensionsList()) {
                            mapDimension.clearLists();
                        }
                    }
                    if (WorldMap.settings.debug) {
                        WorldMap.LOGGER.info("All map data cleared!");
                    }
                    if (this.state == 1) {
                        System.out.println("World map cleaned normally!");
                        this.state = 2;
                    }
                } else if (shouldClearNewDimension) {
                    this.mapWorld.getFutureDimension().regionsToCache.clear();
                    this.mapWorld.getFutureDimension().clearLists();
                    if (WorldMap.settings.debug) {
                        WorldMap.LOGGER.info("Dimension map data cleared!");
                    }
                }
                this.currentWorldStringNoDim = newWorldStringNoDim;
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("World changed!");
                }
                this.mapWorldUsable = this.mapWorldUsableRequest;
                if (this.mapWorldUsableRequest) {
                    this.mapWorld.switchToFutureUnsynced();
                }
                this.caveStartDetermined = false;
                this.caveStart = -1;
                String dimensionName = !this.mapWorldUsableRequest ? null : this.getDimensionName(this.mapWorld.getFutureDimensionId());
                this.currentWorldString = this.currentWorldStringNoDim != null ? this.currentWorldStringNoDim.replace("%DIMENSION%", dimensionName) : null;
                this.footprints.clear();
                this.mapSaveLoad.clearToLoad();
                this.mapSaveLoad.clearLoadRequests();
                this.mapSaveLoad.setNextToLoadByViewing(null);
                this.clearToRefresh();
                this.toProcess.clear();
                if (this.mapWorldUsable) {
                    for (MapRegion region : this.mapWorld.getCurrentDimension().getMapRegionsList()) {
                        if (region.getLoadState() == 4 || region.getLoadState() == 0) continue;
                        this.toProcess.add(region);
                    }
                }
                this.mapSaveLoad.updateCacheFolderList(this.mapSaveLoad.getSubFolder(this.currentWorldString));
                this.mapWriter.resetPosition();
                this.world = this.newWorld;
                this.worldBiomeRegistry = this.newWorldBiomeRegistry;
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("World/dimension changed to: " + this.currentWorldString);
                }
                this.worldDataHandler.prepareSingleplayer((World)this.world, this);
                if (this.worldDataHandler.getWorldDir() == null && this.currentWorldString != null && !this.isWorldMultiplayer(this.isWorldRealms(this.currentWorldString), this.currentWorldString)) {
                    this.currentWorldStringNoDim = null;
                    this.currentWorldString = null;
                }
                boolean bl = this.mapWorldUsable && this.mapWorld.getCurrentDimension().getDetectedRegions() == null;
                this.mapSaveLoad.setRegionDetectionComplete(!bl);
                this.popRenderPause(true, true);
                this.popWriterPause();
            } else if (this.newWorld != this.world) {
                this.pushWriterPause();
                this.world = this.newWorld;
                this.worldBiomeRegistry = this.newWorldBiomeRegistry;
                this.popWriterPause();
            }
            if (this.mapWorldUsable) {
                this.mapWorld.getCurrentDimension().switchToFutureMultiworldWritableValueUnsynced();
                this.mapWorld.switchToFutureMultiworldTypeUnsynced();
            }
            this.waitingForWorldUpdate = false;
        }
    }

    public void updateFootprints(World world, int step) {
        if (WorldMap.settings.footsteps) {
            if (this.footprintsTimer > 0) {
                this.footprintsTimer -= step;
            } else {
                Double[] coords = new Double[]{this.mainPlayerX, this.mainPlayerZ};
                this.footprints.add(coords);
                if (this.footprints.size() > 32) {
                    this.footprints.remove(0);
                }
                this.footprintsTimer = 20;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            if (!this.toRefresh.contains(region)) {
                this.toRefresh.add(0, region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToRefresh(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearToRefresh() {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRefresh(World world) throws RuntimeException {
        Object object = this.loadingSync;
        synchronized (object) {
            if (!this.waitingForWorldUpdate && !this.toRefresh.isEmpty()) {
                MapRegion region = this.toRefresh.get(0);
                if (region.isRefreshing()) {
                    boolean regionLoaded;
                    int globalReloadVersion = WorldMap.settings.reloadVersion;
                    int globalCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                    MapRegion mapRegion = region;
                    synchronized (mapRegion) {
                        boolean bl = regionLoaded = region.getLoadState() == 2;
                        if (regionLoaded) {
                            if (WorldMap.settings.reloadEverything && region.getReloadVersion() != globalReloadVersion || region.getCacheHashCode() != globalCacheHashCode || region.hasVersion() && region.getVersion() != WorldMap.globalVersion || !region.hasVersion() && region.getInitialVersion() != WorldMap.globalVersion) {
                                region.setRecacheHasBeenRequested(true, "refresh handle");
                                region.setShouldCache(true, "refresh handle");
                            }
                            region.setVersion(WorldMap.globalVersion);
                            region.setCacheHashCode(globalCacheHashCode);
                            region.setReloadVersion(globalReloadVersion);
                        }
                    }
                    boolean isEmpty = true;
                    if (regionLoaded) {
                        MapRegion mapRegion2 = region;
                        synchronized (mapRegion2) {
                            region.setAllCachePrepared(false);
                        }
                        for (int i = 0; i < 8; ++i) {
                            for (int j = 0; j < 8; ++j) {
                                MapTileChunk chunk = region.getChunk(i, j);
                                if (chunk == null || chunk.getLoadState() != 2) continue;
                                chunk.setToUpdateBuffers(true);
                                isEmpty = false;
                            }
                        }
                        if (WorldMap.settings.debug) {
                            WorldMap.LOGGER.info("Region refreshed: " + region + " " + region.getRegionX() + "_" + region.getRegionZ() + " " + this.mapWriter.getUpdateCounter());
                        }
                    }
                    MapRegion mapRegion3 = region;
                    synchronized (mapRegion3) {
                        region.setRefreshing(false);
                        if (isEmpty) {
                            region.setRecacheHasBeenRequested(false, "refresh handle");
                            region.setShouldCache(false, "refresh handle");
                        }
                    }
                }
                throw new RuntimeException(String.format("Trying to refresh region %s, which is not marked as being refreshed!", region));
                this.removeToRefresh(region);
            }
        }
    }

    public boolean regionExists(int x, int z) {
        if (!this.mapSaveLoad.isRegionDetectionComplete()) {
            return false;
        }
        Hashtable<Integer, RegionDetection> column = this.mapWorld.getCurrentDimension().getDetectedRegions().get(x);
        return column != null && column.containsKey(z);
    }

    public void addRegionDetection(RegionDetection regionDetection) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.mapWorld.getCurrentDimension().getDetectedRegions();
        Hashtable<Integer, RegionDetection> column = current.get(regionDetection.getRegionX());
        if (column == null) {
            column = new Hashtable();
            current.put(regionDetection.getRegionX(), column);
        }
        column.put(regionDetection.getRegionZ(), regionDetection);
    }

    public RegionDetection getRegionDetection(int x, int z) {
        Hashtable<Integer, RegionDetection> column = this.mapWorld.getCurrentDimension().getDetectedRegions().get(x);
        if (column != null) {
            return column.get(z);
        }
        return null;
    }

    private void removeRegionDetection(int x, int z) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.mapWorld.getCurrentDimension().getDetectedRegions();
        Hashtable<Integer, RegionDetection> column = current.get(x);
        if (column != null) {
            column.remove(z);
        }
        if (column.isEmpty()) {
            current.remove(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapRegion(MapRegion region) {
        MapDimension regionDim = region.getDim();
        Hashtable<Integer, Hashtable<Integer, MapRegion>> hashtable = regionDim.getMapRegions();
        synchronized (hashtable) {
            Hashtable<Integer, MapRegion> mapColumn = regionDim.getMapRegions().get(region.getRegionX());
            if (mapColumn == null) {
                return;
            }
            mapColumn.remove(region.getRegionZ());
            regionDim.getMapRegionsList().remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegion getMapRegion(int regX, int regZ, boolean create) {
        MapDimension mapDimension = this.mapWorld.getCurrentDimension();
        Hashtable<Integer, Hashtable<Integer, MapRegion>> hashtable = mapDimension.getMapRegions();
        synchronized (hashtable) {
            MapRegion region;
            Hashtable<Integer, MapRegion> mapColumn = this.mapWorld.getCurrentDimension().getMapRegions().get(regX);
            if (mapColumn == null) {
                if (create) {
                    mapColumn = new Hashtable();
                    this.mapWorld.getCurrentDimension().getMapRegions().put(regX, mapColumn);
                } else {
                    return null;
                }
            }
            if ((region = mapColumn.get(regZ)) == null) {
                if (create) {
                    region = new MapRegion(this.currentWorldString, mapDimension, regX, regZ, this.getGlobalVersion(), this.isWorldMultiplayer(this.isWorldRealms(this.currentWorldString), this.currentWorldString), this.worldBiomeRegistry);
                    RegionDetection regionDetection = this.getRegionDetection(regX, regZ);
                    if (regionDetection != null) {
                        regionDetection.transferInfoTo(region);
                        this.removeRegionDetection(regX, regZ);
                    }
                    mapDimension.getMapRegionsList().add(region);
                    mapColumn.put(regZ, region);
                } else {
                    return null;
                }
            }
            return region;
        }
    }

    public MapTileChunk getMapChunk(int chunkX, int chunkZ) {
        int regionX = chunkX >> 3;
        int regionZ = chunkZ >> 3;
        MapRegion region = this.getMapRegion(regionX, regionZ, false);
        if (region == null) {
            return null;
        }
        int localChunkX = chunkX & 7;
        int localChunkZ = chunkZ & 7;
        return region.getChunk(localChunkX, localChunkZ);
    }

    public MapTile getMapTile(int x, int z) {
        MapTileChunk tileChunk = this.getMapChunk(x >> 2, z >> 2);
        if (tileChunk == null) {
            return null;
        }
        int tileX = x & 3;
        int tileZ = z & 3;
        return tileChunk.getTile(tileX, tileZ);
    }

    public void updateWorldSpawn(BlockPos newSpawn, ClientWorld world) {
        RegistryKey dimId = world.func_234923_W_();
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        worldData.latestSpawn = newSpawn;
        if (WorldMap.settings.debug) {
            System.out.println("Updated spawn for dimension " + dimId + " " + newSpawn);
        }
        this.spawnToRestore = newSpawn;
        if (world == this.mainWorld) {
            this.mainWorldChangedTime = -1L;
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Done waiting for main spawn.");
            }
        }
        this.checkForWorldUpdate();
    }

    public void onServerLevelId(int serverLevelId) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = serverLevelId;
        if (WorldMap.settings.debug) {
            System.out.println("Updated server level id " + serverLevelId);
        }
        this.checkForWorldUpdate();
    }

    public void onWorldUnload() {
        if (this.mainWorldUnloaded) {
            return;
        }
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info("Changing worlds, pausing the world map...");
        }
        this.mainWorldUnloaded = true;
        this.mainWorldChangedTime = -1L;
        this.changeWorld(null, null);
    }

    public void onClientTickStart() throws RuntimeException {
        if (this.mainWorld != null && this.spawnToRestore != null && this.mainWorldChangedTime != -1L && System.currentTimeMillis() - this.mainWorldChangedTime >= 3000L) {
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("SPAWN SET TIME OUT");
            }
            this.updateWorldSpawn(this.spawnToRestore, this.mainWorld);
        }
    }

    private void updateRenderStartTime() {
        if (this.renderStartTime == -1L) {
            this.renderStartTime = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWriterPause() {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            ++this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popWriterPause() {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            --this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                ++this.pauseRendering;
            }
            if (uploading) {
                ++this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                --this.pauseRendering;
            }
            if (uploading) {
                --this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            ++this.pauseProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            --this.pauseProcessing;
        }
    }

    public boolean isWritingPaused() {
        return this.pauseWriting > 0;
    }

    public boolean isRenderingPaused() {
        return this.pauseRendering > 0;
    }

    public boolean isUploadingPaused() {
        return this.pauseUploading > 0;
    }

    public boolean isProcessingPaused() {
        return this.pauseProcessing > 0;
    }

    public ArrayList<MapRegion> getToProcess() {
        return this.toProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToProcess(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toProcess;
        synchronized (arrayList) {
            this.toProcess.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToProcess(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toProcess;
        synchronized (arrayList) {
            this.toProcess.remove(region);
        }
    }

    public MapSaveLoad getMapSaveLoad() {
        return this.mapSaveLoad;
    }

    public ClientWorld getWorld() {
        return this.world;
    }

    public ClientWorld getNewWorld() {
        return this.newWorld;
    }

    public String getCurrentWorldString() {
        return this.currentWorldString;
    }

    public MapWriter getMapWriter() {
        return this.mapWriter;
    }

    public MapLimiter getMapLimiter() {
        return this.mapLimiter;
    }

    public ArrayList<Double[]> getFootprints() {
        return this.footprints;
    }

    public ByteBufferDeallocator getBufferDeallocator() {
        return this.bufferDeallocator;
    }

    public MapTilePool getTilePool() {
        return this.tilePool;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public int getGlobalVersion() {
        return WorldMap.globalVersion;
    }

    public void setGlobalVersion(int globalVersion) {
        WorldMap.globalVersion = globalVersion;
    }

    public long getRenderStartTime() {
        return this.renderStartTime;
    }

    public void resetRenderStartTime() {
        this.renderStartTime = -1L;
    }

    public Queue<Runnable> getMinecraftScheduledTasks() {
        Queue result;
        this.scheduledTasksField.setAccessible(true);
        try {
            result = (Queue)this.scheduledTasksField.get(Minecraft.func_71410_x());
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        catch (IllegalAccessException e) {
            result = null;
        }
        this.scheduledTasksField.setAccessible(false);
        return result;
    }

    public Runnable getRenderStartTimeUpdater() {
        return this.renderStartTimeUpdaterRunnable;
    }

    public boolean isWaitingForWorldUpdate() {
        return this.waitingForWorldUpdate;
    }

    public WorldDataHandler getWorldDataHandler() {
        return this.worldDataHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainValues() {
        Object object = this.mainStuffSync;
        synchronized (object) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                boolean worldChanging;
                ClientWorld worldToChangeTo = this.ignoreWorld(player.field_70170_p) ? this.mainWorld : (ClientWorld)player.field_70170_p;
                boolean bl = worldChanging = worldToChangeTo != this.mainWorld;
                if (worldChanging) {
                    this.mainWorldChangedTime = -1L;
                    if (this.spawnToRestore != null) {
                        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(worldToChangeTo);
                        if (worldData.latestSpawn == null) {
                            this.mainWorldChangedTime = System.currentTimeMillis();
                        }
                    }
                    this.mainWorldUnloaded = false;
                    this.mainWorldBiomeRegistry = worldToChangeTo == null ? null : worldToChangeTo.func_241828_r().func_243612_b(Registry.field_239720_u_);
                }
                this.mainWorld = worldToChangeTo;
                this.mainPlayerX = player.func_226277_ct_();
                this.mainPlayerY = player.func_226278_cu_();
                this.mainPlayerZ = player.func_226281_cx_();
                if (worldChanging) {
                    this.checkForWorldUpdate();
                }
            } else {
                if (this.mainWorld != null && !this.mainWorldUnloaded) {
                    this.onWorldUnload();
                }
                this.mainWorld = null;
            }
        }
    }

    public void updateCaveStart(double playerX, double playerZ, World world) {
        int chunkZ;
        int chunkX;
        IChunk chunk;
        if (!this.caveStartDetermined && (chunk = world.func_217353_a(chunkX = (int)Math.floor(playerX) >> 4, chunkZ = (int)Math.floor(playerZ) >> 4, ChunkStatus.field_222617_m, false)) != null && !(chunk instanceof EmptyChunk)) {
            if (world.func_234938_ad_() < 256 && (world.func_230315_m_().func_242725_p().equals((Object)DimensionType.field_242711_b) || Math.abs(chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, 0, 0) - world.func_234938_ad_()) < 16)) {
                this.caveStart = world.func_234938_ad_() - 1;
            }
            this.caveStartDetermined = true;
        }
    }

    public boolean caveStartIsDetermined() {
        return this.caveStartDetermined;
    }

    public int getCaveStart() {
        return this.caveStart;
    }

    public float getBrightness() {
        return this.getBrightness(WorldMap.settings.lighting);
    }

    public float getBrightness(boolean lighting) {
        if (this.world == null) {
            return 1.0f;
        }
        float sunBrightness = lighting && this.caveStart == -1 ? (this.world.func_228326_g_(1.0f) - 0.2f) / 0.8f : 1.0f;
        return 0.375f + 0.625f * MathHelper.func_76131_a((float)sunBrightness, (float)0.0f, (float)1.0f);
    }

    public boolean isWorldRealms(String world) {
        return world.startsWith("Realms_");
    }

    public boolean isWorldMultiplayer(boolean realms, String world) {
        return realms || world.startsWith("Multiplayer_");
    }

    public MapWorld getMapWorld() {
        return this.mapWorld;
    }

    public boolean isCurrentMultiworldWritable() {
        return this.mapWorldUsable && this.mapWorld.getCurrentDimension().currentMultiworldWritable;
    }

    public String getCurrentDimension() {
        return "placeholder";
    }

    public void requestCurrentMapDeletion() {
        if (this.currentMapNeedsDeletion) {
            throw new RuntimeException("Requesting map deletion at a weird time!");
        }
        this.currentMapNeedsDeletion = true;
    }

    public void stop() {
        WorldMap.mapRunner.addTask(new MapRunnerTask(){

            @Override
            public void run(MapProcessor doNotUse) {
                if (MapProcessor.this.state == 0) {
                    MapProcessor.this.state = 1;
                    if (!MapProcessor.this.mapWorldUsable) {
                        MapProcessor.this.forceClean();
                    } else {
                        MapProcessor.this.changeWorld(null, null);
                    }
                }
            }
        });
    }

    private synchronized void forceClean() {
        this.pushRenderPause(true, true);
        this.pushWriterPause();
        if (this.mapWorld != null) {
            for (MapDimension dim : this.mapWorld.getDimensionsList()) {
                for (MapRegion region : dim.getMapRegionsList()) {
                    region.deleteTexturesAndBuffers();
                }
            }
        }
        this.popRenderPause(true, true);
        this.popWriterPause();
        this.state = 2;
        System.out.println("World map force-cleaned!");
    }

    public boolean isMapWorldUsable() {
        return this.mapWorldUsable;
    }

    private Object getAutoIdBase(ClientWorld world) {
        return this.hasServerLevelId() ? WorldMapClientWorldDataHelper.getCurrentWorldData().serverLevelId : WorldMapClientWorldDataHelper.getWorldData((ClientWorld)world).latestSpawn;
    }

    private Object getUsedAutoIdBase(ClientWorld world) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        return this.hasServerLevelId() ? WorldMapClientWorldDataHelper.getCurrentWorldData().usedServerLevelId : worldData.usedSpawn;
    }

    private void setUsedAutoIdBase(ClientWorld world, Object autoIdBase) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        if (this.hasServerLevelId()) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().usedServerLevelId = (Integer)autoIdBase;
        } else {
            worldData.usedSpawn = (BlockPos)autoIdBase;
        }
    }

    private void removeUsedAutoIdBase(ClientWorld world) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        if (this.hasServerLevelId()) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().usedServerLevelId = null;
        } else {
            worldData.usedSpawn = null;
        }
    }

    private boolean hasServerLevelId() {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return false;
        }
        return worldData.serverLevelId != null && !this.mapWorld.isIgnoreServerLevelId();
    }
}

