/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.TextureUpload;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.pool.TextureUploadPool;

public class TextureUploader {
    public static final int NORMAL = 0;
    public static final int NORMALDOWNLOAD = 1;
    public static final int COMPRESSED = 2;
    private static final int DEFAULT_NORMALDOWNLOAD_TIME = 3000000;
    private static final int DEFAULT_NORMAL_TIME = 1000000;
    private static final int DEFAULT_COMPRESSED_TIME = 1000000;
    private List<TextureUpload> textureUploadRequests = new ArrayList<TextureUpload>();
    private TextureUploadBenchmark textureUploadBenchmark;
    private TextureUploadPool.Normal normalTextureUploadPool;
    private TextureUploadPool.NormalWithDownload normalWithDownloadTextureUploadPool;
    private TextureUploadPool.Compressed compressedTextureUploadPool;

    public TextureUploader(TextureUploadPool.Normal normalTextureUploadPool, TextureUploadPool.NormalWithDownload normalWithDownloadTextureUploadPool, TextureUploadPool.Compressed compressedTextureUploadPool, TextureUploadBenchmark textureUploadBenchmark) {
        this.normalTextureUploadPool = normalTextureUploadPool;
        this.normalWithDownloadTextureUploadPool = normalWithDownloadTextureUploadPool;
        this.compressedTextureUploadPool = compressedTextureUploadPool;
        this.textureUploadBenchmark = textureUploadBenchmark;
    }

    public long requestUpload(TextureUpload upload) {
        this.textureUploadRequests.add(upload);
        if (upload instanceof TextureUpload.NormalWithDownload) {
            return this.textureUploadBenchmark.isFinished(1) ? Math.min(this.textureUploadBenchmark.getAverage(1), 3000000L) : 3000000L;
        }
        if (upload instanceof TextureUpload.Normal) {
            return this.textureUploadBenchmark.isFinished(0) ? Math.min(this.textureUploadBenchmark.getAverage(0), 1000000L) : 1000000L;
        }
        return this.textureUploadBenchmark.isFinished(2) ? Math.min(this.textureUploadBenchmark.getAverage(2), 1000000L) : 1000000L;
    }

    public long requestNormal(int glTexture, int glPbo, int target, int level, int internalFormat, int width, int height, int border, long pixels_buffer_offset, int format, int type) {
        TextureUpload.Normal upload = this.normalTextureUploadPool.get(glTexture, glPbo, target, level, internalFormat, width, height, border, pixels_buffer_offset, format, type);
        return this.requestUpload(upload);
    }

    public long requestNormalWithDownload(int glTexture, int glPbo, int target, int level, int internalFormat, int width, int height, int border, long pixels_buffer_offset, int format, int type, int glPackPbo) {
        TextureUpload.NormalWithDownload upload = this.normalWithDownloadTextureUploadPool.get(glTexture, glPbo, target, level, internalFormat, width, height, border, pixels_buffer_offset, format, type, glPackPbo);
        return this.requestUpload(upload);
    }

    public long requestCompressed(int glTexture, int glPbo, int target, int level, int internalFormat, int width, int height, int border, long pixels_buffer_offset, int dataSize) {
        TextureUpload.Compressed upload = this.compressedTextureUploadPool.get(glTexture, glPbo, target, level, internalFormat, width, height, border, pixels_buffer_offset, dataSize);
        return this.requestUpload(upload);
    }

    public void finishNewestRequestImmediately() {
        TextureUpload newestRequest = this.textureUploadRequests.remove(this.textureUploadRequests.size() - 1);
        newestRequest.run();
        this.addToPool(newestRequest);
    }

    public void uploadTextures() throws OpenGLException {
        if (!this.textureUploadRequests.isEmpty()) {
            boolean prepared = false;
            for (int i = 0; i < this.textureUploadRequests.size(); ++i) {
                TextureUpload tu = this.textureUploadRequests.get(i);
                int type = tu.getUploadType();
                if (!this.textureUploadBenchmark.isFinished(type)) {
                    if (!prepared) {
                        GL11.glFinish();
                        prepared = true;
                    }
                    this.textureUploadBenchmark.pre();
                }
                tu.run();
                if (!this.textureUploadBenchmark.isFinished(type)) {
                    this.textureUploadBenchmark.post(type);
                    prepared = true;
                }
                this.addToPool(tu);
            }
            this.textureUploadRequests.clear();
        }
    }

    private void addToPool(TextureUpload tu) {
        switch (tu.getUploadType()) {
            case 0: {
                this.normalTextureUploadPool.addToPool((TextureUpload.Normal)tu);
                break;
            }
            case 1: {
                this.normalWithDownloadTextureUploadPool.addToPool((TextureUpload.NormalWithDownload)tu);
                break;
            }
            case 2: {
                this.compressedTextureUploadPool.addToPool((TextureUpload.Compressed)tu);
            }
        }
    }
}

