/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.animation.Animation;
import xaero.map.animation.SinAnimation;
import xaero.map.animation.SlowingAnimation;
import xaero.map.controls.ControlsHandler;
import xaero.map.controls.ControlsRegister;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.gui.GuiDimensionSettings;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.MapMouseButtonPress;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;

public class GuiMap
extends Screen {
    public static final VertexFormatElement TEX_2F_1 = new VertexFormatElement(1, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormatElement TEX_2F_2 = new VertexFormatElement(2, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormat POSITION_TEX_TEX_TEX = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181715_o).add((Object)TEX_2F_1).add((Object)TEX_2F_2).build());
    private static FloatBuffer brightnessBuffer = GLAllocation.func_74529_h((int)4);
    private static final double ZOOM_STEP = 1.2;
    public static final int WAYPOINT_MENU_SIZE = 7;
    private static final int white = -1;
    private static final int whiteTrans = 0x28FFFFFF;
    private static final int redTrans = 687800320;
    private static final int black = -16777216;
    private static int lastAmountOfRegionsViewed = 1;
    private long loadingAnimationStart;
    private PlayerEntity player;
    private double screenScale = 0.0;
    private int mouseDownPosX = -1;
    private int mouseDownPosY = -1;
    private double mouseDownCameraX = -1.0;
    private double mouseDownCameraZ = -1.0;
    private int mouseCheckPosX = -1;
    private int mouseCheckPosY = -1;
    private long mouseCheckTimeNano = -1L;
    private int prevMouseCheckPosX = -1;
    private int prevMouseCheckPosY = -1;
    private long prevMouseCheckTimeNano = -1L;
    private double cameraX = 0.0;
    private double cameraZ = 0.0;
    private int[] cameraDestination = null;
    private SlowingAnimation cameraDestinationAnimX = null;
    private SlowingAnimation cameraDestinationAnimZ = null;
    private double scale;
    private static double destScale = 3.0;
    private Waypoint viewed = null;
    private float waypointHintAlpha = 0.0f;
    private float waypointHintAlphaDest = 0.0f;
    private Animation zoomAnim;
    private SlowingAnimation waypointHintAlphaAnim = null;
    private boolean waypointMenu = false;
    private boolean shouldRenderWaypointMenu = false;
    private int waypointMenuSelected = 0;
    private int waypointMenuOffset = 0;
    private Waypoint waypointMenuSelectedObject = null;
    private Animation waypointMenuAnimation = null;
    private StringBuilder waypointMenuSearch = new StringBuilder();
    private Pattern waypointMenuSearchPattern = null;
    private Pattern waypointMenuSearchStartPattern = null;
    private static ImprovedFramebuffer primaryScaleFBO = null;
    private float[] colourBuffer = new float[4];
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private RegistryKey<World> lastViewedDimensionId;
    private String lastViewedMultiworldId;
    private int mouseBlockPosX;
    private int mouseBlockPosY;
    private int mouseBlockPosZ;
    private long lastStartTime;
    private List<GuiDropDown> dropdowns;
    private GuiDimensionSettings dimensionSettings;
    private MapMouseButtonPress leftMouseButton;
    private MapMouseButtonPress rightMouseButton;
    private MapProcessor mapProcessor;

    public GuiMap(MapProcessor mapProcessor, PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_world_map_screen"));
        this.player = player;
        this.cameraX = (float)player.func_226277_ct_();
        this.cameraZ = (float)player.func_226281_cx_();
        this.leftMouseButton = new MapMouseButtonPress();
        this.rightMouseButton = new MapMouseButtonPress();
        this.dimensionSettings = new GuiDimensionSettings(mapProcessor);
        this.dropdowns = new ArrayList<GuiDropDown>();
        this.scale = destScale * (double)(WorldMap.settings.openMapAnimation ? 1.5f : 1.0f);
        this.zoomAnim = new SlowingAnimation(this.scale, destScale, 0.88, 0.001);
        this.mapProcessor = mapProcessor;
    }

    public void addButton(Button b) {
        super.func_230480_a_((Widget)b);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.dropdowns.clear();
        this.dimensionSettings.init(this, this.dropdowns, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        this.loadingAnimationStart = System.currentTimeMillis();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
        }
        this.screenScale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
    }

    public boolean func_231044_a_(double par1, double par2, int par3) {
        boolean toReturn = false;
        for (GuiDropDown d : this.dropdowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.field_230709_l_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_230709_l_);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropdowns) {
            if (d.onDropDown((int)par1, (int)par2, this.field_230709_l_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_230709_l_);
                return true;
            }
            d.setClosed(true);
        }
        toReturn = super.func_231044_a_(par1, par2, par3);
        if (!toReturn) {
            if (par3 == 0) {
                this.leftMouseButton.isDown = true;
                this.leftMouseButton.pressedAtX = (int)this.field_230706_i_.field_71417_B.func_198024_e();
                this.leftMouseButton.pressedAtY = (int)this.field_230706_i_.field_71417_B.func_198026_f();
            } else if (par3 == 1) {
                this.rightMouseButton.isDown = true;
                this.rightMouseButton.pressedAtX = (int)this.field_230706_i_.field_71417_B.func_198024_e();
                this.rightMouseButton.pressedAtY = (int)this.field_230706_i_.field_71417_B.func_198026_f();
            } else if (par3 == ControlsRegister.keyOpenMap.getKey().func_197937_c()) {
                super.func_231044_a_(256.0, 1.0, 0);
                toReturn = true;
            }
        }
        return toReturn;
    }

    public boolean func_231048_c_(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropdowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.field_230709_l_);
        }
        int mouseX = (int)this.field_230706_i_.field_71417_B.func_198024_e();
        int mouseY = (int)this.field_230706_i_.field_71417_B.func_198026_f();
        if (this.leftMouseButton.isDown && par3 == 0) {
            this.leftMouseButton.isDown = false;
            if (Math.abs(this.leftMouseButton.pressedAtX - mouseX) < 5 && Math.abs(this.leftMouseButton.pressedAtY - mouseY) < 5) {
                this.mapClicked(0, this.leftMouseButton.pressedAtX, this.leftMouseButton.pressedAtY);
            }
            this.leftMouseButton.pressedAtX = -1;
            this.leftMouseButton.pressedAtY = -1;
        }
        if (this.rightMouseButton.isDown && par3 == 1) {
            this.rightMouseButton.isDown = false;
            if (Math.abs(this.rightMouseButton.pressedAtX - mouseX) < 5 && Math.abs(this.rightMouseButton.pressedAtY - mouseY) < 5) {
                this.mapClicked(1, this.rightMouseButton.pressedAtX, this.rightMouseButton.pressedAtY);
            }
            this.rightMouseButton.pressedAtX = -1;
            this.rightMouseButton.pressedAtY = -1;
        }
        return super.func_231048_c_(par1, par2, par3);
    }

    public boolean func_231043_a_(double par1, double par2, double wheel) {
        int direction;
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            for (GuiDropDown d : this.dropdowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_230709_l_)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.field_230709_l_);
                return true;
            }
        }
        int n = direction = wheel > 0.0 ? 1 : -1;
        if (this.waypointMenu) {
            this.scrollWaypoints(direction);
        } else {
            this.changeZoom(wheel);
        }
        return super.func_231043_a_(par1, par2, wheel);
    }

    private void scrollWaypoints(int direction) {
        this.waypointMenuSelected += direction;
        if (this.waypointMenuSelected < 0) {
            this.waypointMenuSelected = 0;
        }
        if (this.waypointMenuSelected == this.waypointMenuOffset + 7 - 1) {
            ++this.waypointMenuOffset;
        }
        if (this.waypointMenuOffset > 0 && this.waypointMenuSelected == this.waypointMenuOffset) {
            --this.waypointMenuOffset;
        }
    }

    private void changeZoom(double factor) {
        this.cameraDestinationAnimX = null;
        this.cameraDestinationAnimZ = null;
        if ((destScale *= Math.pow(1.2, factor)) < 0.5) {
            destScale = 0.5;
        } else if (destScale > 50.0) {
            destScale = 50.0;
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.leftMouseButton.isDown = false;
        this.rightMouseButton.isDown = false;
    }

    public int getTextureSize(double scale) {
        if (scale >= 1.0) {
            return 16;
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_230430_a_(MatrixStack matrixStack, int scaledMouseX, int scaledMouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        long startTime = System.currentTimeMillis();
        this.dimensionSettings.preMapRender(this, this.dropdowns, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        if (!this.waypointMenu) {
            int direction;
            long passed = this.lastStartTime == 0L ? 16L : startTime - this.lastStartTime;
            double passedScrolls = (float)passed / 64.0f;
            int n = ControlsHandler.isDown(ControlsRegister.keyZoomIn) ? 1 : (direction = ControlsHandler.isDown(ControlsRegister.keyZoomOut) ? -1 : 0);
            if (direction != 0) {
                this.changeZoom((double)direction * passedScrolls);
            }
        }
        this.lastStartTime = startTime;
        if (this.cameraDestination != null) {
            this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraDestination[0], 0.9, 0.001);
            this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraDestination[1], 0.9, 0.001);
            this.cameraDestination = null;
        }
        if (this.cameraDestinationAnimX != null) {
            this.cameraX = this.cameraDestinationAnimX.getCurrent();
            if (this.cameraX == this.cameraDestinationAnimX.getDestination()) {
                this.cameraDestinationAnimX = null;
            }
        }
        if (this.cameraDestinationAnimZ != null) {
            this.cameraZ = this.cameraDestinationAnimZ.getCurrent();
            if (this.cameraZ == this.cameraDestinationAnimZ.getDestination()) {
                this.cameraDestinationAnimZ = null;
            }
        }
        this.lastViewedDimensionId = null;
        this.lastViewedMultiworldId = null;
        this.mouseBlockPosY = -1;
        Iterator<GuiDropDown> iterator = this.mapProcessor.renderThreadPauseSync;
        synchronized (iterator) {
            if (!this.mapProcessor.isRenderingPaused()) {
                if (this.mapProcessor.getCurrentWorldString() != null && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete()) {
                    MapRegion region;
                    MapTileChunk chunk;
                    this.lastViewedDimensionId = this.mapProcessor.getMapWorld().getCurrentDimension().getDimId();
                    this.lastViewedMultiworldId = this.mapProcessor.getMapWorld().getCurrentDimension().getCurrentMultiworld();
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.checkWaypoints(this.mapProcessor.getMapWorld().isMultiplayer(), this.lastViewedDimensionId, this.lastViewedMultiworldId);
                    }
                    int mouseXPos = (int)Misc.getMouseX(mc);
                    int mouseYPos = (int)Misc.getMouseY(mc);
                    if (this.mouseCheckPosX == -1 || System.nanoTime() - this.mouseCheckTimeNano > 30000000L) {
                        this.prevMouseCheckPosX = this.mouseCheckPosX;
                        this.prevMouseCheckPosY = this.mouseCheckPosY;
                        this.prevMouseCheckTimeNano = this.mouseCheckTimeNano;
                        this.mouseCheckPosX = mouseXPos;
                        this.mouseCheckPosY = mouseYPos;
                        this.mouseCheckTimeNano = System.nanoTime();
                    }
                    if (!this.leftMouseButton.isDown) {
                        if (this.mouseDownPosX != -1) {
                            this.mouseDownPosX = -1;
                            this.mouseDownPosY = -1;
                            if (this.prevMouseCheckTimeNano != -1L) {
                                double speed_z;
                                double frameTime60FPS;
                                double downTime = 0.0;
                                int draggedX = 0;
                                int draggedY = 0;
                                draggedX = mouseXPos - this.prevMouseCheckPosX;
                                downTime = System.nanoTime() - this.prevMouseCheckTimeNano;
                                double speedScale = downTime / (frameTime60FPS = 1.6666666666666666E7);
                                double speed_x = (double)(-draggedX) / this.scale / speedScale;
                                double speed = Math.sqrt(speed_x * speed_x + (speed_z = (double)(-(draggedY = mouseYPos - this.prevMouseCheckPosY)) / this.scale / speedScale) * speed_z);
                                if (speed > 0.0) {
                                    double cos = speed_x / speed;
                                    double sin = speed_z / speed;
                                    speed = Math.abs(speed) > 500.0 ? Math.copySign(500.0, speed) : speed;
                                    double speed_factor = 0.9;
                                    double ln = Math.log(speed_factor);
                                    double move_distance = -speed / ln;
                                    double moveX = cos * move_distance;
                                    double moveZ = sin * move_distance;
                                    this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraX + moveX, 0.9, 0.001);
                                    this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraZ + moveZ, 0.9, 0.001);
                                }
                            }
                        }
                    } else if (this.mouseDownPosX != -1) {
                        this.cameraX = (double)(this.mouseDownPosX - mouseXPos) / this.scale + this.mouseDownCameraX;
                        this.cameraZ = (double)(this.mouseDownPosY - mouseYPos) / this.scale + this.mouseDownCameraZ;
                    } else {
                        this.mouseDownPosX = mouseXPos;
                        this.mouseDownPosY = mouseYPos;
                        this.mouseDownCameraX = this.cameraX;
                        this.mouseDownCameraZ = this.cameraZ;
                        this.cameraDestinationAnimX = null;
                        this.cameraDestinationAnimZ = null;
                    }
                    int mouseFromCentreX = mouseXPos - mc.func_228018_at_().func_198109_k() / 2;
                    int mouseFromCentreY = mouseYPos - mc.func_228018_at_().func_198091_l() / 2;
                    double oldMousePosX = (double)mouseFromCentreX / this.scale + this.cameraX;
                    double oldMousePosZ = (double)mouseFromCentreY / this.scale + this.cameraZ;
                    double preScale = this.scale;
                    if (destScale != this.scale) {
                        if (this.zoomAnim != null) {
                            this.scale = this.zoomAnim.getCurrent();
                        }
                        if (this.zoomAnim == null || Misc.round(this.zoomAnim.getDestination(), 4) != Misc.round(destScale, 4)) {
                            this.zoomAnim = new SinAnimation(this.scale, destScale, 100L);
                        }
                    }
                    if (this.scale > preScale) {
                        this.cameraX = oldMousePosX - (double)mouseFromCentreX / this.scale;
                        this.cameraZ = oldMousePosZ - (double)mouseFromCentreY / this.scale;
                    }
                    RenderSystem.pushMatrix();
                    double mousePosX = (double)mouseFromCentreX / this.scale + this.cameraX;
                    double mousePosZ = (double)mouseFromCentreY / this.scale + this.cameraZ;
                    RenderSystem.pushMatrix();
                    RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
                    if (WorldMap.settings.displayZoom) {
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)((double)Math.round(destScale * 100.0) / 100.0 + "x"), (int)2, (int)2, (int)-1);
                    }
                    this.mouseBlockPosX = (int)Math.floor(mousePosX);
                    this.mouseBlockPosZ = (int)Math.floor(mousePosZ);
                    int mouseRegX = this.mouseBlockPosX >> 9;
                    int mouseRegZ = this.mouseBlockPosZ >> 9;
                    MapRegion reg = this.mapProcessor.getMapRegion(mouseRegX, mouseRegZ, false);
                    MapTileChunk mapTileChunk = chunk = reg != null ? reg.getChunk(this.mouseBlockPosX >> 6 & 7, this.mouseBlockPosZ >> 6 & 7) : null;
                    if (WorldMap.settings.debug) {
                        if (reg != null) {
                            if (chunk != null) {
                                MapBlock block;
                                GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)(chunk.getX() + " " + chunk.getZ()), (int)5, (int)15, (int)-1);
                                GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("loadState: " + chunk.getLoadState()), (int)5, (int)25, (int)-1);
                                GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("shouldUpload: " + chunk.shouldUpload() + " timer: " + chunk.getTimer()), (int)5, (int)35, (int)-1);
                                GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("buffers exist: %s, %s", chunk.getColorBuffer() != null, chunk.getLightBuffer() != null), (int)5, (int)45, (int)-1);
                                GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("glColorTexture: " + chunk.getGlColorTexture() + " glLightTexture: " + chunk.getGlLightTexture()), (int)5, (int)55, (int)-1);
                                GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("height mask: %d", chunk.getHeightValueMask()), (int)5, (int)65, (int)-1);
                                GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("changed: %s include: %s", chunk.wasChanged(), chunk.includeInSave()), (int)5, (int)75, (int)-1);
                                GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("cachePrepared: " + chunk.isCachePrepared()), (int)5, (int)85, (int)-1);
                                MapTile mouseTile = chunk.getTile(this.mouseBlockPosX >> 4 & 3, this.mouseBlockPosZ >> 4 & 3);
                                if (mouseTile != null && (block = mouseTile.getBlock(this.mouseBlockPosX & 0xF, this.mouseBlockPosZ & 0xF)) != null) {
                                    GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)block.toRenderString(reg.getBiomeRegistry()), (int)(this.field_230708_k_ / 2), (int)12, (int)-1);
                                    if (block.getNumberOfOverlays() != 0) {
                                        for (int i = 0; i < block.getOverlays().size(); ++i) {
                                            GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)block.getOverlays().get(i).toRenderString(), (int)(this.field_230708_k_ / 2), (int)(22 + i * 10), (int)-1);
                                        }
                                    }
                                }
                            }
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("paused: " + reg.isWritingPaused()), (int)5, (int)105, (int)-1);
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("writing: %s refreshing: %s", reg.isBeingWritten(), reg.isRefreshing()), (int)5, (int)115, (int)-1);
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("shouldCache: " + reg.shouldCache()), (int)5, (int)125, (int)-1);
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("saveExists: " + reg.getSaveExists()), (int)5, (int)135, (int)-1);
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)(mouseRegX + " " + mouseRegZ), (int)5, (int)145, (int)-1);
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("reg loadState: %s version: %d/%d hash: %d reloadVersion: %d", reg.getLoadState(), reg.getVersion(), this.mapProcessor.getGlobalVersion(), reg.getCacheHashCode(), reg.getReloadVersion()), (int)5, (int)155, (int)-1);
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("processed: " + this.mapProcessor.getToProcess().contains(reg)), (int)5, (int)165, (int)-1);
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("recache: %s reload: %s", reg.recacheHasBeenRequested(), reg.reloadHasBeenRequested()), (int)5, (int)175, (int)-1);
                        }
                        if (this.mapProcessor.getMapWorld().isMultiplayer()) {
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("MultiWorld ID: " + this.mapProcessor.getMapWorld().getCurrentMultiworld()), (int)5, (int)185, (int)-1);
                        }
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("regions: %d processed: %d viewed: %d", this.mapProcessor.getMapWorld().getCurrentDimension().getMapRegionsList().size(), this.mapProcessor.getToProcess().size(), lastAmountOfRegionsViewed), (int)5, (int)195, (int)-1);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("toLoad: %d toSave: %d tile pool: %d overlays: %d", this.mapProcessor.getMapSaveLoad().getSizeOfToLoad(), this.mapProcessor.getMapSaveLoad().getToSave().size(), this.mapProcessor.getTilePool().size(), this.mapProcessor.getOverlayManager().getNumberOfUniqueOverlays()), (int)5, (int)205, (int)-1);
                        long i = Runtime.getRuntime().maxMemory();
                        long j = Runtime.getRuntime().totalMemory();
                        long k = Runtime.getRuntime().freeMemory();
                        long l = j - k;
                        int debugFPS = this.mapProcessor.getDebugFPS(mc);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("FPS: %d", debugFPS), (int)5, (int)225, (int)-1);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, GuiMap.bytesToMb(l), GuiMap.bytesToMb(i)), (int)5, (int)235, (int)-1);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("Allocated: % 2d%% %03dMB", j * 100L / i, GuiMap.bytesToMb(j)), (int)5, (int)245, (int)-1);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("Available VRAM: %dMB", this.mapProcessor.getMapLimiter().getAvailableVRAM() / 1024), (int)5, (int)255, (int)-1);
                    }
                    if (chunk != null) {
                        this.mouseBlockPosY = chunk.getHeight(this.mouseBlockPosX & 0x3F, this.mouseBlockPosZ & 0x3F);
                    }
                    if (WorldMap.settings.coordinates) {
                        String coordsString = "X: " + this.mouseBlockPosX;
                        if (this.mouseBlockPosY != -1) {
                            coordsString = coordsString + " Y: " + this.mouseBlockPosY;
                        }
                        coordsString = coordsString + " Z: " + this.mouseBlockPosZ;
                        GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)coordsString, (int)(this.field_230708_k_ / 2), (int)2, (int)-1);
                    }
                    RenderSystem.popMatrix();
                    int preferredTextureSize = this.getTextureSize(this.scale);
                    if (primaryScaleFBO == null || GuiMap.primaryScaleFBO.field_147621_c != mc.func_228018_at_().func_198109_k() || GuiMap.primaryScaleFBO.field_147618_d != mc.func_228018_at_().func_198091_l()) {
                        primaryScaleFBO = new ImprovedFramebuffer(mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l(), false);
                    }
                    double fboScale = 0.5;
                    if (preferredTextureSize > 8) {
                        fboScale = Math.max(1.0, Math.floor(this.scale));
                    }
                    double secondaryScale = this.scale / fboScale;
                    if (GuiMap.primaryScaleFBO.field_147616_f == -1) {
                        RenderSystem.popMatrix();
                        return;
                    }
                    primaryScaleFBO.func_147610_a(false);
                    GuiMap.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)mc.func_228018_at_().func_198109_k(), (int)mc.func_228018_at_().func_198091_l(), (int)-16777216);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.scaled((double)(1.0 / this.screenScale), (double)(1.0 / this.screenScale), (double)1.0);
                    RenderSystem.translatef((float)(mc.func_228018_at_().func_198109_k() / 2), (float)(mc.func_228018_at_().func_198091_l() / 2), (float)0.0f);
                    RenderSystem.pushMatrix();
                    RenderSystem.disableCull();
                    int flooredCameraX = (int)Math.floor(this.cameraX);
                    int flooredCameraY = (int)Math.floor(this.cameraZ);
                    double secondaryOffsetX = (this.cameraX - (double)flooredCameraX) * fboScale;
                    double secondaryOffsetY = (this.cameraZ - (double)flooredCameraY) * fboScale;
                    if (fboScale == 0.5) {
                        if ((flooredCameraX & 1) != 0) {
                            --flooredCameraX;
                            secondaryOffsetX += 0.5;
                        }
                        if ((flooredCameraY & 1) != 0) {
                            --flooredCameraY;
                            secondaryOffsetY += 0.5;
                        }
                    } else {
                        int offset;
                        if (secondaryOffsetX >= 1.0) {
                            offset = (int)secondaryOffsetX;
                            RenderSystem.translatef((float)(-offset), (float)0.0f, (float)0.0f);
                            secondaryOffsetX -= (double)offset;
                        }
                        if (secondaryOffsetY >= 1.0) {
                            offset = (int)secondaryOffsetY;
                            RenderSystem.translatef((float)0.0f, (float)offset, (float)0.0f);
                            secondaryOffsetY -= (double)offset;
                        }
                    }
                    RenderSystem.scaled((double)fboScale, (double)(-fboScale), (double)1.0);
                    GlStateManager.func_227619_H_();
                    double leftBorder = this.cameraX - (double)(mc.func_228018_at_().func_198109_k() / 2) / this.scale;
                    double rightBorder = leftBorder + (double)mc.func_228018_at_().func_198109_k() / this.scale;
                    double topBorder = this.cameraZ - (double)(mc.func_228018_at_().func_198091_l() / 2) / this.scale;
                    double bottomBorder = topBorder + (double)mc.func_228018_at_().func_198091_l() / this.scale;
                    int minRegX = (int)leftBorder >> 9;
                    int maxRegX = (int)rightBorder >> 9;
                    int minRegZ = (int)topBorder >> 9;
                    int maxRegZ = (int)bottomBorder >> 9;
                    lastAmountOfRegionsViewed = (maxRegX - minRegX + 1) * (maxRegZ - minRegZ + 1);
                    if (this.mapProcessor.getMapLimiter().getMostRegionsAtATime() < lastAmountOfRegionsViewed) {
                        this.mapProcessor.getMapLimiter().setMostRegionsAtATime(lastAmountOfRegionsViewed);
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.disableAlphaTest();
                    this.regionBuffer.clear();
                    float brightness = this.mapProcessor.getBrightness();
                    int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                    boolean reloadEverything = WorldMap.settings.reloadEverything;
                    int globalReloadVersion = WorldMap.settings.reloadVersion;
                    GuiMap.setupTextureMatricesAndTextures(brightness);
                    for (int regX = minRegX; regX <= maxRegX; ++regX) {
                        for (int regZ = minRegZ; regZ <= maxRegZ; ++regZ) {
                            region = this.mapProcessor.getMapRegion(regX, regZ, this.mapProcessor.regionExists(regX, regZ));
                            if (region == null) continue;
                            MapRegion mapRegion = region;
                            synchronized (mapRegion) {
                                if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (reloadEverything && region.getReloadVersion() != globalReloadVersion || region.getCacheHashCode() != globalRegionCacheHashCode || region.getVersion() != this.mapProcessor.getGlobalVersion() || region.getLoadState() == 4 && region.shouldCache())) {
                                    if (region.isBeingWritten() && region.getLoadState() == 2) {
                                        region.requestRefresh(this.mapProcessor);
                                    } else {
                                        this.regionBuffer.add(region);
                                    }
                                }
                            }
                            if (!this.mapProcessor.isUploadingPaused()) {
                                List<MapRegion> regions = this.mapProcessor.getMapWorld().getCurrentDimension().getMapRegionsList();
                                regions.remove(region);
                                regions.add(region);
                            }
                            if (region.getLoadState() < 2) {
                                RenderSystem.pushMatrix();
                                RenderSystem.translatef((float)(512 * region.getRegionX() + 256 - flooredCameraX), (float)(512 * region.getRegionZ() + 256 - flooredCameraY), (float)0.0f);
                                float loadingAnimationPassed = System.currentTimeMillis() - this.loadingAnimationStart;
                                if (loadingAnimationPassed > 0.0f) {
                                    GuiMap.restoreTextureStates();
                                    int period = 2000;
                                    int numbersOfActors = 3;
                                    float loadingAnimation = loadingAnimationPassed % (float)period / (float)period * 360.0f;
                                    float step = 360.0f / (float)numbersOfActors;
                                    RenderSystem.rotatef((float)loadingAnimation, (float)0.0f, (float)0.0f, (float)1.0f);
                                    int numberOfVisibleActors = 1 + (int)loadingAnimationPassed % (3 * period) / period;
                                    for (int i = 0; i < numberOfVisibleActors; ++i) {
                                        RenderSystem.rotatef((float)step, (float)0.0f, (float)0.0f, (float)1.0f);
                                        GuiMap.func_238467_a_((MatrixStack)matrixStack, (int)16, (int)-8, (int)32, (int)8, (int)-1);
                                    }
                                    GuiMap.setupTextureMatricesAndTextures(brightness);
                                }
                                RenderSystem.popMatrix();
                            }
                            for (int o = 0; o < 8; ++o) {
                                for (int p = 0; p < 8; ++p) {
                                    chunk = region.getChunk(o, p);
                                    if (chunk == null || chunk.getGlColorTexture() == -1 || (double)((chunk.getX() + 1) * 64) < leftBorder || (double)(chunk.getX() * 64) > rightBorder || (double)(chunk.getZ() * 64) > bottomBorder || (double)((chunk.getZ() + 1) * 64) < topBorder || chunk.getGlColorTexture() == -1) continue;
                                    GuiMap.bindMapTextureWithLighting3(brightness, chunk, 9728, preferredTextureSize == 8 ? 1 : 0);
                                    GuiMap.renderTexturedModalRectWithLighting(64 * chunk.getX() - flooredCameraX, 64 * chunk.getZ() - flooredCameraY, 0, 0, 64.0f, 64.0f);
                                }
                            }
                            if (!WorldMap.settings.debug) continue;
                            GuiMap.restoreTextureStates();
                            RenderSystem.pushMatrix();
                            RenderSystem.translatef((float)(512 * region.getRegionX() + 32 - flooredCameraX), (float)(512 * region.getRegionZ() + 32 - flooredCameraY), (float)0.0f);
                            RenderSystem.scaled((double)10.0, (double)10.0, (double)1.0);
                            RenderSystem.enableCull();
                            GL11.glDisable((int)2884);
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("" + region.getLoadState()), (int)0, (int)0, (int)-1);
                            RenderSystem.disableCull();
                            RenderSystem.popMatrix();
                            GuiMap.setupTextureMatricesAndTextures(brightness);
                        }
                    }
                    GuiMap.restoreTextureStates();
                    MapRegion nextToLoad = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                    boolean shouldRequest = false;
                    if (nextToLoad != null) {
                        region = nextToLoad;
                        synchronized (region) {
                            if (!nextToLoad.reloadHasBeenRequested()) {
                                shouldRequest = true;
                            }
                        }
                    } else {
                        shouldRequest = true;
                    }
                    if (shouldRequest) {
                        int toRequest = 1;
                        int counter = 0;
                        MapRegion.setComparison(this.mouseBlockPosX >> 9, this.mouseBlockPosZ >> 9);
                        Collections.sort(this.regionBuffer);
                        for (int i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                            MapRegion region2 = this.regionBuffer.get(i);
                            if (region2 == nextToLoad && this.regionBuffer.size() > 1) continue;
                            MapRegion loadingAnimation = region2;
                            synchronized (loadingAnimation) {
                                if (region2.reloadHasBeenRequested() || region2.recacheHasBeenRequested() || region2.getLoadState() != 0 && region2.getLoadState() != 4) {
                                    continue;
                                }
                                this.mapProcessor.getMapSaveLoad().requestLoad(region2, "Gui");
                                if (counter == 0) {
                                    this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region2);
                                }
                                ++counter;
                                if (region2.getLoadState() == 4) {
                                    break;
                                }
                                continue;
                            }
                        }
                    }
                    GuiMap.func_238467_a_((MatrixStack)matrixStack, (int)((this.mouseBlockPosX >> 4) * 16 - flooredCameraX), (int)((this.mouseBlockPosZ >> 4) * 16 - flooredCameraY), (int)(((this.mouseBlockPosX >> 4) + 1) * 16 - flooredCameraX), (int)(((this.mouseBlockPosZ >> 4) + 1) * 16 - flooredCameraY), (int)0x28FFFFFF);
                    RenderSystem.enableBlend();
                    RenderSystem.enableAlphaTest();
                    RenderSystem.disableBlend();
                    RenderSystem.disableAlphaTest();
                    primaryScaleFBO.func_147609_e();
                    ImprovedFramebuffer.bindDefaultFramebuffer(primaryScaleFBO.getType(), 36160, mc);
                    RenderSystem.enableCull();
                    RenderSystem.popMatrix();
                    RenderSystem.pushMatrix();
                    RenderSystem.scaled((double)secondaryScale, (double)secondaryScale, (double)1.0);
                    primaryScaleFBO.func_147612_c();
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    int lineX = -mc.func_228018_at_().func_198109_k() / 2;
                    int lineY = mc.func_228018_at_().func_198091_l() / 2 - 5;
                    int lineW = mc.func_228018_at_().func_198109_k();
                    int lineH = 6;
                    GuiMap.func_238467_a_((MatrixStack)matrixStack, (int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)-16777216);
                    lineX = mc.func_228018_at_().func_198109_k() / 2 - 5;
                    lineY = -mc.func_228018_at_().func_198091_l() / 2;
                    lineW = 6;
                    lineH = mc.func_228018_at_().func_198091_l();
                    GuiMap.func_238467_a_((MatrixStack)matrixStack, (int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)-16777216);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableDepthTest();
                    GuiMap.renderTexturedModalRect((float)(-mc.func_228018_at_().func_198109_k() / 2) - (float)secondaryOffsetX, (float)(-mc.func_228018_at_().func_198091_l() / 2) - (float)secondaryOffsetY, 0, 0, mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l(), mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l());
                    RenderSystem.popMatrix();
                    RenderSystem.scaled((double)this.scale, (double)this.scale, (double)1.0);
                    RenderSystem.enableBlend();
                    RenderSystem.enableAlphaTest();
                    double minGuiScale = 4.0;
                    float guiBasedScale = 1.0f;
                    if (this.screenScale > minGuiScale) {
                        guiBasedScale = (float)(this.screenScale / minGuiScale);
                    }
                    ArrayList<Waypoint> renderResult = null;
                    if (SupportMods.minimap() && WorldMap.settings.waypoints) {
                        boolean waypointMenuReal;
                        RenderSystem.disableCull();
                        Waypoint oldViewed = this.viewed;
                        renderResult = SupportMods.xaeroMinimap.renderWaypoints(matrixStack, this, this.cameraX, this.cameraZ, mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l(), guiBasedScale, this.scale, mousePosX, mousePosZ, this.waypointMenuSearchPattern, this.waypointMenuSearchStartPattern, brightness);
                        boolean bl = waypointMenuReal = renderResult != null && (renderResult.size() > 1 || this.waypointMenu) && scaledMouseX > this.field_230708_k_ - 20 && scaledMouseY > this.field_230709_l_ - 20;
                        if (this.waypointMenu != waypointMenuReal) {
                            int animationEnd;
                            this.waypointMenu = waypointMenuReal;
                            int animationStart = this.waypointMenuAnimation != null ? (int)this.waypointMenuAnimation.getCurrent() : (this.waypointMenu ? 500 : 0);
                            int n = animationEnd = this.waypointMenu ? 0 : 500;
                            if (this.waypointMenu) {
                                this.waypointMenuAnimation = new SlowingAnimation(animationStart, animationEnd, 0.7, 0.001);
                                this.shouldRenderWaypointMenu = true;
                            } else {
                                this.waypointMenuAnimation = new Animation(animationStart, animationEnd, 500L);
                            }
                        }
                        if (!this.shouldRenderWaypointMenu) {
                            this.waypointMenuSelected = 0;
                            this.waypointMenuOffset = 0;
                        }
                        Waypoint waypoint = this.viewed = renderResult != null ? renderResult.remove(0) : null;
                        if (this.viewed != oldViewed) {
                            this.waypointHintAlphaDest = this.viewed != null ? 255.0f : 0.0f;
                            this.waypointHintAlphaAnim = new SlowingAnimation(this.waypointHintAlpha, this.waypointHintAlphaDest, this.waypointHintAlpha < this.waypointHintAlphaDest ? 0.9 : 0.95, 1.0);
                        }
                        if (this.waypointHintAlphaAnim != null) {
                            this.waypointHintAlpha = (float)this.waypointHintAlphaAnim.getCurrent();
                        }
                        RenderSystem.enableCull();
                        RenderSystem.enableBlend();
                    } else {
                        this.viewed = null;
                    }
                    if (WorldMap.settings.footsteps) {
                        for (int i = 0; i < this.mapProcessor.getFootprints().size(); ++i) {
                            Double[] coords = this.mapProcessor.getFootprints().get(i);
                            this.setColourBuffer(1.0f, 0.1f, 0.1f, 1.0f);
                            this.drawDotOnMap(coords[0] - this.cameraX, coords[1] - this.cameraZ, 0.0f, 1.0 / this.scale);
                        }
                    }
                    if (WorldMap.settings.renderArrow) {
                        boolean toTheLeft = this.player.func_226277_ct_() < leftBorder;
                        boolean toTheRight = this.player.func_226277_ct_() > rightBorder;
                        boolean down = this.player.func_226281_cx_() > bottomBorder;
                        boolean up = this.player.func_226281_cx_() < topBorder;
                        RenderSystem.enableBlend();
                        if (toTheLeft || toTheRight || up || down) {
                            double arrowX = this.player.func_226277_ct_();
                            double arrowZ = this.player.func_226281_cx_();
                            float a = 0.0f;
                            if (toTheLeft) {
                                a = up ? 1.5f : (down ? 0.5f : 1.0f);
                                arrowX = leftBorder;
                            } else if (toTheRight) {
                                a = up ? 2.5f : (down ? 3.5f : 3.0f);
                                arrowX = rightBorder;
                            }
                            if (down) {
                                arrowZ = bottomBorder;
                            } else if (up) {
                                if (a == 0.0f) {
                                    a = 2.0f;
                                }
                                arrowZ = topBorder;
                            }
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawFarArrowOnMap(arrowX - this.cameraX, arrowZ + (double)(2.0f * guiBasedScale) / this.scale - this.cameraZ, a, (double)guiBasedScale / this.scale);
                            this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                            this.drawFarArrowOnMap(arrowX - this.cameraX, arrowZ - this.cameraZ, a, (double)guiBasedScale / this.scale);
                        } else {
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawArrowOnMap(this.player.func_226277_ct_() - this.cameraX, this.player.func_226281_cx_() + (double)(2.0f * guiBasedScale) / this.scale - this.cameraZ, this.player.field_70177_z, (double)guiBasedScale / this.scale);
                            this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                            this.drawArrowOnMap(this.player.func_226277_ct_() - this.cameraX, this.player.func_226281_cx_() - this.cameraZ, this.player.field_70177_z, (double)guiBasedScale / this.scale);
                        }
                    }
                    RenderSystem.popMatrix();
                    if (this.shouldRenderWaypointMenu && renderResult != null) {
                        if (this.waypointMenuSelected >= renderResult.size()) {
                            this.waypointMenuSelected = renderResult.size() - 1;
                            this.waypointMenuOffset = Math.max(this.waypointMenuSelected - 7 + 2, 0);
                        }
                        if (this.waypointMenuSelected < 0) {
                            this.waypointMenuSelected = 0;
                        }
                        this.waypointMenuSelectedObject = renderResult.size() > 0 ? (Waypoint)renderResult.get(this.waypointMenuSelected) : null;
                        SupportMods.xaeroMinimap.renderSideWaypoints(matrixStack, this, renderResult, this.scale, this.field_230708_k_ + (int)this.waypointMenuAnimation.getCurrent(), this.field_230709_l_, this.waypointMenuOffset, this.waypointMenuSelected);
                        if (this.waypointMenu && this.waypointMenuSearch != null && this.waypointMenuSearch.length() > 0) {
                            GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)this.waypointMenuSearch.toString(), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ - 15), (int)-1);
                        }
                        if (!this.waypointMenu && this.waypointMenuAnimation.getCurrent() == this.waypointMenuAnimation.getDestination()) {
                            this.shouldRenderWaypointMenu = false;
                            this.waypointMenuSearch = new StringBuilder();
                            this.waypointMenuSearchPattern = null;
                            this.waypointMenuSearchStartPattern = null;
                        }
                    }
                    this.dimensionSettings.renderText(matrixStack, this.field_230706_i_, scaledMouseX, scaledMouseY, this.field_230708_k_, this.field_230709_l_);
                    if ((int)this.waypointHintAlpha > 3) {
                        int hintColour = (int)this.waypointHintAlpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                        RenderSystem.enableBlend();
                        RenderSystem.enableAlphaTest();
                        if (SupportMods.xaeroMinimap.canTeleport()) {
                            GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)"Edit - Right Click     Teleport - T     Disable - H     Delete - Delete", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ - 25), (int)hintColour);
                        } else {
                            GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)"Edit - Right Click     Disable - H     Delete - Delete", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ - 25), (int)hintColour);
                        }
                    }
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.drawSetChange(matrixStack);
                    }
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    this.renderLoadingScreen(matrixStack);
                }
            } else {
                this.renderLoadingScreen(matrixStack);
            }
            mc.func_110434_K().func_110577_a(WorldMap.guiTextures);
            this.func_238474_b_(matrixStack, this.field_230708_k_ - 35, 2, 0, 37, 32, 32);
        }
        RenderSystem.enableDepthTest();
        super.func_230430_a_(matrixStack, scaledMouseX, scaledMouseY, partialTicks);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 501.0);
        for (GuiDropDown d : this.dropdowns) {
            if (!d.isClosed()) continue;
            d.drawButton(matrixStack, scaledMouseX, scaledMouseY, this.field_230709_l_);
        }
        for (GuiDropDown d : this.dropdowns) {
            if (d.isClosed()) continue;
            d.drawButton(matrixStack, scaledMouseX, scaledMouseY, this.field_230709_l_);
        }
        this.dimensionSettings.postMapRender(matrixStack, this.field_230706_i_, scaledMouseX, scaledMouseY, this.field_230708_k_, this.field_230709_l_);
        matrixStack.func_227865_b_();
    }

    private void renderLoadingScreen(MatrixStack matrixStack) {
        GuiMap.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)this.field_230706_i_.func_228018_at_().func_198109_k(), (int)this.field_230706_i_.func_228018_at_().func_198091_l(), (int)-16777216);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
        GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"Preparing World Map...", (int)(this.field_230706_i_.func_228018_at_().func_198107_o() / 2), (int)(this.field_230706_i_.func_228018_at_().func_198087_p() / 2), (int)-1);
        RenderSystem.popMatrix();
    }

    public void drawDotOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 2.5f, 2.5f, 0, 69, 5, 5, 9729);
    }

    public void drawArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 13.0f, 5.0f, 0, 0, 26, 28, 9729);
    }

    public void drawFarArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle * 90.0f, sc, 27.0f, 13.0f, 26, 0, 54, 13, 9729);
    }

    public void drawObjectOnMap(double x, double z, float angle, double sc, float offX, float offY, int textureX, int textureY, int w, int h, int filter) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)this.colourBuffer[0], (float)this.colourBuffer[1], (float)this.colourBuffer[2], (float)this.colourBuffer[3]);
        RenderSystem.translated((double)x, (double)z, (double)0.0);
        RenderSystem.scaled((double)sc, (double)sc, (double)1.0);
        if (angle != 0.0f) {
            RenderSystem.rotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        GuiMap.renderTexturedModalRect(-offX, -offY, textureX, textureY, w, h, 256.0f, 256.0f);
        if (filter != 9728) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public static void renderTexturedModalRectWithLighting(float x, float y, int textureX, int textureY, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, POSITION_TEX_TEX_TEX);
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + height), 0.0);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 1.0f);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 1.0f);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + 0.0f), 0.0);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 0.0f);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + 0.0f), 0.0);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 0.0f);
        vertexBuffer.func_181675_d();
        tessellator.func_78381_a();
    }

    private static void anyIndexFloatUV(BufferBuilder vertexBuffer, float u, float v) {
        vertexBuffer.func_225590_a_(0, u);
        vertexBuffer.func_225590_a_(4, v);
        vertexBuffer.func_181667_k();
    }

    public static void renderTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float textureWidth, float textureHeight) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float normalizedTextureX = (float)textureX / textureWidth;
        float normalizedTextureY = (float)textureY / textureHeight;
        float normalizedTextureX2 = ((float)textureX + width) / textureWidth;
        float normalizedTextureY2 = ((float)textureY + height) / textureHeight;
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + height), 0.0).func_225583_a_(normalizedTextureX, normalizedTextureY2).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_(normalizedTextureX2, normalizedTextureY2).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + 0.0f), 0.0).func_225583_a_(normalizedTextureX2, normalizedTextureY).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_225583_a_(normalizedTextureX, normalizedTextureY).func_181675_d();
        tessellator.func_78381_a();
    }

    public void mapClicked(int button, int x, int y) {
        if (!this.waypointMenu && this.viewed != null) {
            SupportMods.xaeroMinimap.openWaypoint(this, this.viewed);
            this.mouseDownPosX = -1;
            this.mouseDownPosY = -1;
        }
        if (this.waypointMenu && this.waypointMenuSelectedObject != null) {
            this.cameraDestination = new int[]{this.waypointMenuSelectedObject.getX(), this.waypointMenuSelectedObject.getZ()};
        }
    }

    private void setSearch(String search, String preChange) {
        try {
            this.waypointMenuSearchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.waypointMenuSearchStartPattern = search.charAt(0) == '^' ? this.waypointMenuSearchPattern : Pattern.compile('^' + search.toString().toLowerCase());
            } else {
                this.waypointMenuSearchPattern = null;
                this.waypointMenuSearchStartPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            if (preChange != null) {
                this.waypointMenuSearch = new StringBuilder(preChange);
                this.setSearch(preChange, null);
            }
            throw e;
        }
    }

    public boolean func_231042_a_(char par1, int par2) {
        if (this.waypointMenu) {
            String preChange = this.waypointMenuSearch.toString();
            this.waypointMenuSearch.append(par1);
            this.setSearch(this.waypointMenuSearch.toString(), preChange);
        }
        return super.func_231042_a_(par1, par2);
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        if (this.waypointMenu) {
            if (par1 != 0) {
                if (par1 == ControlsRegister.keyZoomIn.getKey().func_197937_c()) {
                    this.scrollWaypoints(1);
                } else if (par1 == ControlsRegister.keyZoomOut.getKey().func_197937_c()) {
                    this.scrollWaypoints(-1);
                } else {
                    String preChange = this.waypointMenuSearch.toString();
                    if (par1 == 259) {
                        if (this.waypointMenuSearch.length() > 0) {
                            this.waypointMenuSearch.deleteCharAt(this.waypointMenuSearch.length() - 1);
                        }
                    } else if (par1 == 257) {
                        this.waypointMenuSearch = new StringBuilder();
                    }
                    this.setSearch(this.waypointMenuSearch.toString(), preChange);
                }
            }
        } else {
            if (par1 == ControlsRegister.keyOpenMap.getKey().func_197937_c()) {
                return super.func_231046_a_(256, 1, par3);
            }
            if (par1 == 257 && this.dimensionSettings.active) {
                this.dimensionSettings.confirm(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            }
            if (SupportMods.minimap()) {
                SupportMods.xaeroMinimap.onMapKeyPressed(par1, par2, par3);
            }
            if (this.viewed != null) {
                switch (par1) {
                    case 72: {
                        SupportMods.xaeroMinimap.disableWaypoint(this.viewed);
                        break;
                    }
                    case 261: {
                        SupportMods.xaeroMinimap.deleteWaypoint(this.viewed);
                    }
                }
            }
        }
        return super.func_231046_a_(par1, par2, par3);
    }

    public boolean func_223281_a_(int par1, int par2, int par3) {
        if (!this.waypointMenu && SupportMods.minimap() && this.lastViewedDimensionId != null) {
            if (this.viewed != null) {
                switch (par1) {
                    case 84: {
                        SupportMods.xaeroMinimap.teleportToWaypoint(this, this.viewed);
                    }
                }
            }
            if (par1 == SupportMods.xaeroMinimap.getWaypointKeyCode() && WorldMap.settings.waypoints && this.mouseBlockPosY != -1) {
                SupportMods.xaeroMinimap.createWaypoint(this, this.mouseBlockPosX, this.mouseBlockPosY + 1, this.mouseBlockPosZ);
            }
            if (par1 == SupportMods.xaeroMinimap.getTempWaypointKeyCode() && WorldMap.settings.waypoints && this.mouseBlockPosY != -1) {
                SupportMods.xaeroMinimap.createTempWaypoint(this.mouseBlockPosX, this.mouseBlockPosY + 1, this.mouseBlockPosZ);
            }
        }
        return super.func_223281_a_(par1, par2, par3);
    }

    @Deprecated
    public static void bindMapTextureWithLighting(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        GuiMap.setupTextureMatricesAndTextures(brightness);
        GuiMap.bindMapTextureWithLighting3(brightness, chunk, magFilter, lod);
    }

    @Deprecated
    public static void bindMapTextureWithLighting2(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        GuiMap.setupTextures(brightness);
        GuiMap.bindMapTextureWithLighting3(brightness, chunk, magFilter, lod);
    }

    public static void bindMapTextureWithLighting3(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        int glLightTexture = chunk.getGlLightTexture();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.enableTexture();
        if (glLightTexture != -1) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            chunk.bindLightTexture(false, magFilter);
            GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
        } else {
            RenderSystem.color4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            chunk.bindColorTexture(false, magFilter);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        }
        RenderSystem.activeTexture((int)33985);
        if (glLightTexture != -1) {
            RenderSystem.enableTexture();
            chunk.bindLightTexture(false, magFilter);
        } else {
            RenderSystem.disableTexture();
        }
        RenderSystem.activeTexture((int)33986);
        if (glLightTexture != -1) {
            RenderSystem.enableTexture();
            chunk.bindColorTexture(false, magFilter);
        } else {
            RenderSystem.disableTexture();
        }
    }

    @Deprecated
    public static void setupTextureMatrices() {
        RenderSystem.activeTexture((int)33985);
        RenderSystem.matrixMode((int)5890);
        RenderSystem.loadIdentity();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.loadIdentity();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.activeTexture((int)33984);
    }

    private static void setupTexture0(float brightness) {
        float toSubtract = 1.0f - brightness;
        brightnessBuffer.position(0);
        brightnessBuffer.put(toSubtract);
        brightnessBuffer.put(toSubtract);
        brightnessBuffer.put(toSubtract);
        brightnessBuffer.put(1.0f);
        brightnessBuffer.flip();
        GL11.glTexEnvfv((int)8960, (int)8705, (FloatBuffer)brightnessBuffer);
        GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
        GL11.glTexEnvi((int)8960, (int)34161, (int)34023);
        GL11.glTexEnvi((int)8960, (int)34176, (int)5890);
        GL11.glTexEnvi((int)8960, (int)34192, (int)769);
        GL11.glTexEnvi((int)8960, (int)34177, (int)34166);
        GL11.glTexEnvi((int)8960, (int)34193, (int)768);
        GL11.glTexEnvi((int)8960, (int)34162, (int)7681);
        GL11.glTexEnvi((int)8960, (int)34184, (int)34166);
        GL11.glTexEnvi((int)8960, (int)34200, (int)770);
    }

    private static void setupTexture1() {
        GL11.glTexEnvi((int)8960, (int)8704, (int)260);
    }

    private static void setupTexture2() {
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
    }

    public static void setupTextures(float brightness) {
        RenderSystem.activeTexture((int)33984);
        RenderSystem.enableTexture();
        GuiMap.setupTexture0(brightness);
        RenderSystem.activeTexture((int)33985);
        GuiMap.setupTexture1();
        RenderSystem.activeTexture((int)33986);
        GuiMap.setupTexture2();
        RenderSystem.activeTexture((int)33984);
    }

    public static void setupTextureMatricesAndTextures(float brightness) {
        RenderSystem.activeTexture((int)33984);
        RenderSystem.enableTexture();
        GuiMap.setupTexture0(brightness);
        RenderSystem.activeTexture((int)33985);
        GuiMap.setupTexture1();
        RenderSystem.matrixMode((int)5890);
        RenderSystem.loadIdentity();
        RenderSystem.activeTexture((int)33986);
        GuiMap.setupTexture2();
        RenderSystem.loadIdentity();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.activeTexture((int)33984);
    }

    public static void restoreTextureStates() {
        RenderSystem.activeTexture((int)33985);
        RenderSystem.disableTexture();
        RenderSystem.activeTexture((int)33986);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        RenderSystem.disableTexture();
        RenderSystem.activeTexture((int)33984);
        GL11.glTexEnvi((int)8960, (int)34161, (int)8448);
        GL11.glTexEnvi((int)8960, (int)34192, (int)768);
        GL11.glTexEnvi((int)8960, (int)34177, (int)34168);
        GL11.glTexEnvi((int)8960, (int)34162, (int)8448);
        GL11.glTexEnvi((int)8960, (int)34184, (int)5890);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private void setColourBuffer(float r, float g, float b, float a) {
        this.colourBuffer[0] = r;
        this.colourBuffer[1] = g;
        this.colourBuffer[2] = b;
        this.colourBuffer[3] = a;
    }
}

