/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;

public class Waypoint
implements Comparable<Waypoint> {
    private Object original;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private int x;
    private int y;
    private int z;
    private String text;
    private String symbol;
    private int color;
    private boolean disabled = false;
    private int type = 0;
    private boolean rotation = false;
    private int yaw = 0;
    private float destAlpha = 0.0f;
    private float alpha = 0.0f;
    private SlowingAnimation alphaAnim = null;
    private boolean editable;

    public Waypoint(Object original, int x, int y, int z, String name, String symbol, int color, int type, boolean editable) {
        this.original = original;
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.text = name;
        this.editable = editable;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.text, (Object[])new Object[0]);
    }

    public void renderWaypoint(MatrixStack matrixStack, Screen gui, double wpScale, float x, float y, boolean viewing) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(WorldMap.guiTextures);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scaled((double)wpScale, (double)wpScale, (double)1.0);
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.color3f((float)((float)(this.color >> 16 & 0xFF) / 255.0f), (float)((float)(this.color >> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f));
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (this.symbol.length() > 1) {
            flagU = 70;
            flagW = 43;
        }
        RenderSystem.translatef((float)((float)(-flagW) / 2.0f), (float)(-flagH + 1), (float)0.0f);
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (float)flagU, (float)flagV, (int)flagW, (int)flagH, (int)256, (int)256);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
        float oldDestAlpha = this.destAlpha;
        this.destAlpha = viewing ? 255.0f : 0.0f;
        if (oldDestAlpha != this.destAlpha) {
            this.alphaAnim = new SlowingAnimation(this.alpha, this.destAlpha, 0.8, 1.0);
        }
        if (this.alphaAnim != null) {
            this.alpha = (float)this.alphaAnim.getCurrent();
        }
        int symbolTexture = 0;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        int stringWidth = mc.field_71466_p.func_78256_a(this.symbol);
        int symbolFrameWidth = stringWidth / 2 > 4 ? 64 : 32;
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        if (this.type == 0 && this.alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolTexture = WorldMap.waypointSymbolCreator.getSymbolTexture(this.symbol);
        } else if (this.type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolTexture = WorldMap.waypointSymbolCreator.getDeathSymbolTexture();
        }
        if (symbolTexture != 0) {
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.bindTexture((int)symbolTexture);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(-1.0f - (float)symbolWidth / 2.0f), (float)(-11 + symbolVerticalOffset - 1), (float)0.0f);
            RenderSystem.scaled((double)1.0, (double)-1.0, (double)1.0);
            AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)symbolFrameWidth, (int)32, (int)32, (int)symbolFrameWidth);
            RenderSystem.popMatrix();
        }
        if ((int)this.alpha > 0) {
            int r = this.color >> 16 & 0xFF;
            int g = this.color >> 8 & 0xFF;
            int b = this.color & 0xFF;
            int c = (int)this.alpha << 24 | r << 16 | g << 8 | b;
            int tbg = (int)(this.alpha / 255.0f * 200.0f) << 24;
            int tc = (int)this.alpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
            String name = this.getName();
            int len = mc.field_71466_p.func_78256_a(name);
            RenderSystem.translatef((float)0.0f, (float)-38.0f, (float)0.0f);
            RenderSystem.scaled((double)3.0, (double)3.0, (double)1.0);
            int bgLen = Math.max(len + 2, 10);
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(-bgLen / 2), (int)-1, (int)(bgLen / 2), (int)9, (int)c);
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(-bgLen / 2), (int)-1, (int)(bgLen / 2), (int)8, (int)tbg);
            RenderSystem.enableBlend();
            if ((int)this.alpha > 3) {
                mc.field_71466_p.func_238421_b_(matrixStack, name, (float)(-(len - 1)) / 2.0f, 0.0f, tc);
            }
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void renderSideWaypoint(MatrixStack matrixStack, Screen gui, float x, float y, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        RenderSystem.translatef((float)-4.0f, (float)-4.0f, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.color3f((float)((float)(this.color >> 16 & 0xFF) / 255.0f), (float)((float)(this.color >> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f));
        if (this.type == 1) {
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)this.color);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(minimapTextures);
            RenderSystem.color4f((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            gui.func_238474_b_(matrixStack, 1, 1, 0, 78, 9, 9);
            RenderSystem.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            gui.func_238474_b_(matrixStack, 0, 0, 0, 78, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.disableTexture();
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)this.color);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.type == 0) {
            mc.field_71466_p.func_238405_a_(matrixStack, this.symbol, (float)(5 - mc.field_71466_p.func_78256_a(this.symbol) / 2), 1.0f, -1);
        }
        String name = this.getName();
        int len = mc.field_71466_p.func_78256_a(name);
        mc.field_71466_p.func_238405_a_(matrixStack, name, (float)(-3 - len), 0.0f, -1);
        RenderSystem.enableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void renderShadow(float brightness, MatrixStack matrixStack, Screen gui, double wpScale, float x, float y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scaled((double)wpScale, (double)wpScale, (double)1.0);
        RenderSystem.translatef((float)-14.0f, (float)-41.0f, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)brightness);
        gui.func_238474_b_(matrixStack, 0, 19, 0, 117, 41, 22);
        RenderSystem.popMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int compareTo(Waypoint arg0) {
        return this.z > arg0.z ? 1 : (this.z != arg0.z ? -1 : 0);
    }

    public String toString() {
        return this.getName();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getType() {
        return this.type;
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Object getOriginal() {
        return this.original;
    }

    public String getSymbol() {
        return this.symbol;
    }
}

