/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeKey;
import xaero.map.region.MapBlock;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;

public class MapPixel {
    private static final float DEFAULT_AMBIENT_LIGHT = 0.7f;
    private static final float DEFAULT_AMBIENT_LIGHT_COLORED = 0.2f;
    private static final float DEFAULT_AMBIENT_LIGHT_WHITE = 0.5f;
    private static final float DEFAULT_MAX_DIRECT_LIGHT = 0.6666667f;
    private static final float GLOWING_MAX_DIRECT_LIGHT = 0.22222224f;
    protected BlockState state;
    protected byte colourType = (byte)-1;
    protected int customColour;
    protected byte light = 0;
    protected boolean glowing = false;

    public void getPixelColours(int[] result_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, MapTile mapTile, int x, int z, MapBlock block, int height, ArrayList<Overlay> overlays, BlockPos.Mutable mutableGlobalPos, MutableRegistry<Biome> biomeRegistry, float shadowR, float shadowG, float shadowB) {
        int colour = 0;
        int topLightValue = this.light;
        int lightMin = 9;
        float brightnessR = 1.0f;
        float brightnessG = 1.0f;
        float brightnessB = 1.0f;
        mutableGlobalPos.func_181079_c(mapTile.getChunkX() * 16 + x, height, mapTile.getChunkZ() * 16 + z);
        if (this.state.func_177230_c() != Blocks.field_150350_a) {
            if (WorldMap.settings.colours == 0) {
                colour = mapWriter.loadBlockColourFromTexture(this.state, true, world, (BlockPos)mutableGlobalPos);
            } else {
                try {
                    colour = this.state.func_177230_c() instanceof FlowingFluidBlock && RenderTypeLookup.canRenderInLayer((FluidState)this.state.func_204520_s(), (RenderType)RenderType.func_228645_f_()) ? 25825 : this.state.func_185909_g((IBlockReader)world, (BlockPos)mutableGlobalPos).field_76291_p;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        boolean isFinalBlock = this instanceof MapBlock;
        if (!isFinalBlock && ((Overlay)this).isWater()) {
            this.colourType = 1;
        }
        if (this.colourType == -1) {
            if (isFinalBlock) {
                BiomeKey biomeKey = mapWriter.getColorTypeCache().getBlockBiomeColour(world, this.state, (BlockPos)mutableGlobalPos, result_dest, block.getBiome(), biomeRegistry);
                this.colourType = (byte)result_dest[0];
                if (biomeKey != null) {
                    block.setBiome(biomeKey);
                }
                this.customColour = result_dest[2];
            } else {
                mapWriter.getColorTypeCache().getOverlayBiomeColour(world, this.state, (BlockPos)mutableGlobalPos, result_dest, mapWriter.getColorTypeCache().PLACEHOLDER_BIOME, biomeRegistry);
                this.colourType = (byte)result_dest[0];
                this.customColour = result_dest[2];
            }
        }
        if (this.colourType != 0 && (WorldMap.settings.biomeColorsVanillaMode || WorldMap.settings.colours == 0)) {
            int c = this.customColour;
            if (isFinalBlock) {
                if (this.colourType == 1) {
                    c = mapWriter.getBiomeColor(0, mutableGlobalPos, mapTile, world, biomeRegistry);
                } else if (this.colourType == 2) {
                    c = mapWriter.getBiomeColor(1, mutableGlobalPos, mapTile, world, biomeRegistry);
                }
            } else if (this.colourType == 1) {
                c = mapWriter.getBiomeColor(2, mutableGlobalPos, mapTile, world, biomeRegistry);
            }
            float rMultiplier = (float)r / 255.0f;
            float gMultiplier = (float)g / 255.0f;
            float bMultiplier = (float)b / 255.0f;
            r = (int)((float)(c >> 16 & 0xFF) * rMultiplier);
            g = (int)((float)(c >> 8 & 0xFF) * gMultiplier);
            b = (int)((float)(c & 0xFF) * bMultiplier);
        }
        if (this.glowing) {
            int total = r + g + b;
            float minBrightness = 407.0f;
            float brightener = Math.max(1.0f, minBrightness / (float)total);
            r = (int)((float)r * brightener);
            g = (int)((float)g * brightener);
            b = (int)((float)b * brightener);
            topLightValue = 15;
        }
        int overlayRed = 0;
        int overlayGreen = 0;
        int overlayBlue = 0;
        float currentTransparencyMultiplier = 1.0f;
        if (overlays != null && !overlays.isEmpty()) {
            int sun = 15;
            for (int i = 0; i < overlays.size(); ++i) {
                Overlay o = overlays.get(i);
                o.getPixelColour(block, result_dest, mapWriter, world, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, mapTile, x, z, mutableGlobalPos, biomeRegistry, shadowR, shadowG, shadowB);
                if (i == 0) {
                    topLightValue = o.light;
                }
                float transparency = o.getTransparency();
                float overlayIntensity = this.getBlockBrightness(lightMin, o.light, sun) * transparency * currentTransparencyMultiplier;
                overlayRed = (int)((float)overlayRed + (float)result_dest[0] * overlayIntensity);
                overlayGreen = (int)((float)overlayGreen + (float)result_dest[1] * overlayIntensity);
                overlayBlue = (int)((float)overlayBlue + (float)result_dest[2] * overlayIntensity);
                if ((sun -= o.getOpacity()) < 0) {
                    sun = 0;
                }
                currentTransparencyMultiplier *= 1.0f - transparency;
            }
            if (!this.glowing) {
                brightnessG = brightnessB = this.getBlockBrightness(lightMin, this.light, sun);
                brightnessR = brightnessB;
            }
        }
        if (isFinalBlock) {
            if (block.slopeUnknown && block.getState().func_177230_c() != Blocks.field_150350_a) {
                block.fixHeightType(x, z, mapTile, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, block.getHeight());
            }
            float depthBrightness = 1.0f;
            int slopes = WorldMap.settings.terrainSlopes;
            if (!this.glowing) {
                int block_height = block.getHeight();
                boolean caving = block.isCaveBlock() && block_height != -1 && block_height < 127;
                float caveBrightness = (float)block_height / 127.0f;
                if (caving) {
                    brightnessG = brightnessB = caveBrightness;
                    brightnessR = brightnessB;
                }
                if (!caving && WorldMap.settings.terrainDepth && block_height != -1) {
                    float min;
                    depthBrightness = (float)height / 63.0f;
                    float max = slopes >= 2 ? 1.0f : 1.15f;
                    float f = min = slopes >= 2 ? 0.9f : 0.7f;
                    if (depthBrightness > max) {
                        depthBrightness = max;
                    } else if (depthBrightness < min) {
                        depthBrightness = min;
                    }
                }
            }
            if (slopes > 0 && !block.slopeUnknown) {
                byte verticalSlope = block.getVerticalSlope();
                if (slopes == 1) {
                    if (verticalSlope > 0) {
                        depthBrightness = (float)((double)depthBrightness * 1.15);
                    } else if (verticalSlope < 0) {
                        depthBrightness = (float)((double)depthBrightness * 0.85);
                    }
                } else {
                    byte diagonalSlope = block.getDiagonalSlope();
                    float ambientLightColored = 0.2f;
                    float ambientLightWhite = 0.5f;
                    float maxDirectLight = 0.6666667f;
                    if (this.glowing) {
                        ambientLightColored = 0.0f;
                        ambientLightWhite = 1.0f;
                        maxDirectLight = 0.22222224f;
                    }
                    float cos = 0.0f;
                    if (slopes == 2) {
                        float crossZ = -verticalSlope;
                        if (crossZ < 1.0f) {
                            if (verticalSlope == 1 && diagonalSlope == 1) {
                                cos = 1.0f;
                            } else {
                                float crossX = verticalSlope - diagonalSlope;
                                float cast = 1.0f - crossZ;
                                float crossMagnitude = (float)Math.sqrt(crossX * crossX + 1.0f + crossZ * crossZ);
                                cos = (float)((double)(cast / crossMagnitude) / Math.sqrt(2.0));
                            }
                        }
                    } else if (verticalSlope >= 0) {
                        if (verticalSlope == 1) {
                            cos = 1.0f;
                        } else {
                            float surfaceDirectionMagnitude = (float)Math.sqrt(verticalSlope * verticalSlope + 1);
                            float castToMostLit = verticalSlope + 1;
                            cos = (float)((double)(castToMostLit / surfaceDirectionMagnitude) / Math.sqrt(2.0));
                        }
                    }
                    float directLightClamped = 0.0f;
                    if (cos == 1.0f) {
                        directLightClamped = maxDirectLight;
                    } else if (cos > 0.0f) {
                        directLightClamped = (float)Math.ceil(cos * 10.0f) / 10.0f * maxDirectLight * 0.88388f;
                    }
                    float whiteLight = ambientLightWhite + directLightClamped;
                    brightnessR *= shadowR * ambientLightColored + whiteLight;
                    brightnessG *= shadowG * ambientLightColored + whiteLight;
                    brightnessB *= shadowB * ambientLightColored + whiteLight;
                }
            }
            brightnessR *= depthBrightness;
            brightnessG *= depthBrightness;
            brightnessB *= depthBrightness;
        }
        result_dest[0] = (int)((float)r * brightnessR * currentTransparencyMultiplier + (float)overlayRed);
        if (result_dest[0] > 255) {
            result_dest[0] = 255;
        }
        result_dest[1] = (int)((float)g * brightnessG * currentTransparencyMultiplier + (float)overlayGreen);
        if (result_dest[1] > 255) {
            result_dest[1] = 255;
        }
        result_dest[2] = (int)((float)b * brightnessB * currentTransparencyMultiplier + (float)overlayBlue);
        if (result_dest[2] > 255) {
            result_dest[2] = 255;
        }
        result_dest[3] = (int)(this.getPixelLight(lightMin, topLightValue) * 255.0f);
    }

    public float getBlockBrightness(float min, int l, int sun) {
        return (min + (float)Math.max(sun, l)) / (15.0f + min);
    }

    private float getPixelLight(float min, int topLightValue) {
        return topLightValue == 0 ? 0.0f : this.getBlockBrightness(min, topLightValue, 0);
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public void setLight(byte light) {
        this.light = light;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
    }

    public byte getColourType() {
        return this.colourType;
    }

    public void setColourType(byte colourType) {
        this.colourType = colourType;
    }

    public int getCustomColour() {
        return this.customColour;
    }

    public void setCustomColour(int customColour) {
        this.customColour = customColour;
    }
}

