/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.world;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.world.MapDimension;

public class MapWorld {
    private MapProcessor mapProcessor;
    private boolean isMultiplayer;
    private String mainIdNoDim;
    private Hashtable<RegistryKey<World>, MapDimension> dimensions;
    private RegistryKey<World> currentDimensionId;
    private RegistryKey<World> futureDimensionId;
    private int futureMultiworldType;
    private int currentMultiworldType;
    private boolean futureMultiworldTypeConfirmed = true;
    private boolean currentMultiworldTypeConfirmed = false;
    private boolean ignoreServerLevelId;

    public MapWorld(String mainIdNoDim, MapProcessor mapProcessor) {
        this.mainIdNoDim = mainIdNoDim;
        this.mapProcessor = mapProcessor;
        this.isMultiplayer = mapProcessor.isWorldMultiplayer(mapProcessor.isWorldRealms(mainIdNoDim), mainIdNoDim);
        this.dimensions = new Hashtable();
        this.currentMultiworldType = 0;
        this.futureMultiworldType = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapDimension getDimension(RegistryKey<World> dimId) {
        Hashtable<RegistryKey<World>, MapDimension> hashtable = this.dimensions;
        synchronized (hashtable) {
            return this.dimensions.get(dimId);
        }
    }

    @Deprecated
    public MapDimension createDimension(RegistryKey<World> dimId) {
        return this.createDimensionUnsynced(dimId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapDimension createDimensionUnsynced(RegistryKey<World> dimId) {
        Hashtable<RegistryKey<World>, MapDimension> hashtable = this.dimensions;
        synchronized (hashtable) {
            MapDimension result = this.dimensions.get(dimId);
            if (result == null) {
                result = new MapDimension(this, dimId);
                this.dimensions.put(dimId, result);
                result.loadConfigUnsynced();
            }
            return result;
        }
    }

    public String getMainIdNoDim() {
        return this.mainIdNoDim;
    }

    public String getCurrentMultiworld() {
        MapDimension container = this.getDimension(this.currentDimensionId);
        return container.getCurrentMultiworld();
    }

    public String getFutureMultiworldUnsynced() {
        MapDimension container = this.getDimension(this.futureDimensionId);
        return container.getFutureMultiworldUnsynced();
    }

    public MapDimension getCurrentDimension() {
        return this.getDimension(this.currentDimensionId);
    }

    public MapDimension getFutureDimension() {
        return this.getDimension(this.futureDimensionId);
    }

    public RegistryKey<World> getCurrentDimensionId() {
        return this.currentDimensionId;
    }

    public RegistryKey<World> getFutureDimensionId() {
        return this.futureDimensionId;
    }

    public void setFutureDimensionId(RegistryKey<World> dimension) {
        this.futureDimensionId = dimension;
    }

    public void switchToFutureUnsynced() {
        this.currentDimensionId = this.futureDimensionId;
        this.getDimension(this.currentDimensionId).switchToFutureUnsynced();
    }

    public List<MapDimension> getDimensionsList() {
        ArrayList<MapDimension> destList = new ArrayList<MapDimension>();
        this.getDimensions(destList);
        return destList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDimensions(List<MapDimension> dest) {
        Hashtable<RegistryKey<World>, MapDimension> hashtable = this.dimensions;
        synchronized (hashtable) {
            dest.addAll(this.dimensions.values());
        }
    }

    public int getCurrentMultiworldType() {
        return this.currentMultiworldType;
    }

    public boolean isMultiplayer() {
        return this.isMultiplayer;
    }

    public boolean isCurrentMultiworldTypeConfirmed() {
        return this.currentMultiworldTypeConfirmed;
    }

    public int getFutureMultiworldType(MapDimension dim) {
        return dim.isFutureMultiworldServerBased() ? 2 : this.futureMultiworldType;
    }

    public void toggleMultiworldTypeUnsynced() {
        this.unconfirmMultiworldTypeUnsynced();
        this.futureMultiworldType = (this.futureMultiworldType + 1) % 3;
        this.getCurrentDimension().resetCustomMultiworldUnsynced();
        this.saveConfig();
    }

    public void unconfirmMultiworldTypeUnsynced() {
        this.futureMultiworldTypeConfirmed = false;
    }

    public void confirmMultiworldTypeUnsynced() {
        this.futureMultiworldTypeConfirmed = true;
    }

    public boolean isFutureMultiworldTypeConfirmed(MapDimension dim) {
        return dim.isFutureMultiworldServerBased() ? true : this.futureMultiworldTypeConfirmed;
    }

    public void switchToFutureMultiworldTypeUnsynced() {
        MapDimension futureDim = this.getFutureDimension();
        this.currentMultiworldType = this.getFutureMultiworldType(this.getFutureDimension());
        this.currentMultiworldTypeConfirmed = this.isFutureMultiworldTypeConfirmed(futureDim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() {
        MapProcessor mp = this.mapProcessor;
        String mainWorldId = this.mainIdNoDim.replace("%DIMENSION%", "null");
        Path overworldSavePath = mp.getMapSaveLoad().getMainFolder(mainWorldId, false);
        BufferedReader reader = null;
        try {
            Path configFile;
            if (!Files.exists(overworldSavePath, new LinkOption[0])) {
                Files.createDirectories(overworldSavePath, new FileAttribute[0]);
            }
            if (Files.exists(configFile = overworldSavePath.resolve("server_config.txt"), new LinkOption[0])) {
                String line;
                reader = new BufferedReader(new FileReader(configFile.toFile()));
                while ((line = reader.readLine()) != null) {
                    String[] args = line.split(":");
                    if (args[0].equals("multiworldType")) {
                        this.futureMultiworldType = Integer.parseInt(args[1]);
                        continue;
                    }
                    if (!args[0].equals("ignoreServerLevelId")) continue;
                    this.ignoreServerLevelId = args[1].equals("true");
                }
            } else {
                this.saveConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        MapProcessor mp = this.mapProcessor;
        String mainWorldId = this.mainIdNoDim.replace("%DIMENSION%", "null");
        Path overworldSavePath = mp.getMapSaveLoad().getMainFolder(mainWorldId, false);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(overworldSavePath.resolve("server_config.txt").toFile()));
            writer.println("multiworldType:" + this.futureMultiworldType);
            writer.println("ignoreServerLevelId:" + this.ignoreServerLevelId);
        }
    }

    MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public boolean isIgnoreServerLevelId() {
        return this.ignoreServerLevelId;
    }
}

