/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack;

import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModContainerTypes;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.init.ModTileEntityTypes;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="travelersbackpack")
public class TravelersBackpack {
    public static final String MODID = "travelersbackpack";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final SimpleChannel NETWORK = ModNetwork.getNetworkChannel();
    private static boolean curiosLoaded;

    public TravelersBackpack() {
        TravelersBackpackConfig.register(ModLoadingContext.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onFinish);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEnqueueIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        EffectFluidRegistry.initEffects();
        curiosLoaded = ModList.get().isLoaded("curios");
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (!TravelersBackpack.enableCurios()) {
            return;
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void setup(FMLCommonSetupEvent event) {
        TravelersBackpackCapability.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ModClientEventHandler.registerScreenFactory();
        ModClientEventHandler.bindTileEntityRenderer();
        ModClientEventHandler.registerKeybinding();
        ModClientEventHandler.addLayer();
        ModClientEventHandler.registerItemModelProperty();
    }

    private void onFinish(FMLLoadCompleteEvent event) {
        ModItems.addBackpacksToList();
        ResourceUtils.createModelTextureLocations();
        ResourceUtils.createWearableTextureLocations();
    }

    public static boolean enableCurios() {
        return curiosLoaded && TravelersBackpackConfig.curiosIntegration;
    }
}

