/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class HoseItem
extends Item {
    public HoseItem(Item.Properties properties) {
        super(properties);
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (HoseItem.getHoseMode(stack) == 3) {
            return UseAction.DRINK;
        }
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 24;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        if (CapabilityUtils.isWearingBackpack(player) && context.func_221531_n() == Hand.MAIN_HAND) {
            if (stack.func_77978_p() == null) {
                this.getCompoundTag(stack);
                return ActionResultType.PASS;
            }
            LazyOptional fluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)direction);
            TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
            FluidTank tank = this.getSelectedFluidTank(stack, inv);
            if (HoseItem.getHoseMode(stack) == 1) {
                BlockState blockstate1;
                if (fluidHandler.isPresent() && !((Boolean)fluidHandler.map(h -> h.getFluidInTank(0).isEmpty()).get()).booleanValue()) {
                    world.func_184133_a(player, pos, fluidHandler.map(f -> f.getFluidInTank(0).getFluid().getAttributes().getFillSound()).orElse(SoundEvents.field_187630_M), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    FluidUtil.tryFluidTransfer((IFluidHandler)tank, (IFluidHandler)((IFluidHandler)fluidHandler.orElse(null)), (int)1000, (boolean)true);
                    inv.markTankDirty();
                    return ActionResultType.SUCCESS;
                }
                BlockRayTraceResult result = HoseItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
                BlockPos blockpos = result.func_216350_a();
                Direction direction1 = result.func_216354_b();
                BlockPos blockpos1 = blockpos.func_177972_a(direction);
                if (world.func_175660_a(player, blockpos) && player.func_175151_a(blockpos1, direction1, stack) && (blockstate1 = world.func_180495_p(blockpos)).func_177230_c() instanceof IBucketPickupHandler) {
                    int level = (Integer)blockstate1.getBlockState().func_177229_b((Property)BlockStateProperties.field_208132_ag);
                    Fluid fluid = blockstate1.func_204520_s().func_206886_c();
                    if (level == 0 && fluid != Fluids.field_204541_a) {
                        boolean canFill;
                        FluidStack fluidStack = new FluidStack(fluid, 1000);
                        int tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                        boolean bl = canFill = tank.isEmpty() || tank.getFluid().isFluidEqual(fluidStack);
                        if (canFill && fluidStack.getAmount() + tankAmount <= tank.getCapacity()) {
                            ((IBucketPickupHandler)blockstate1.func_177230_c()).func_204508_a((IWorld)world, blockpos, blockstate1);
                            world.func_184133_a(player, result.func_216350_a(), fluid.getAttributes().getFillSound() == null ? (fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M) : fluid.getAttributes().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                            inv.markTankDirty();
                            return ActionResultType.SUCCESS;
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 2) {
                if (fluidHandler.isPresent() && !tank.isEmpty()) {
                    FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)fluidHandler.orElse(null)), (IFluidHandler)tank, (int)1000, (boolean)true);
                    world.func_184133_a(player, pos, fluidHandler.map(f -> f.getFluidInTank(0).getFluid().getAttributes().getFillSound()).orElse(SoundEvents.field_187630_M), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    inv.markTankDirty();
                    return ActionResultType.SUCCESS;
                }
                if (!tank.isEmpty()) {
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p();
                    if (!world.func_180495_p(pos).func_227032_a_(tank.getFluid().getFluid())) {
                        switch (context.func_196000_l()) {
                            case WEST: {
                                --x;
                                break;
                            }
                            case EAST: {
                                ++x;
                                break;
                            }
                            case NORTH: {
                                --z;
                                break;
                            }
                            case SOUTH: {
                                ++z;
                                break;
                            }
                            case UP: {
                                ++y;
                                break;
                            }
                            case DOWN: {
                                --y;
                                break;
                            }
                        }
                    }
                    BlockPos newPos = new BlockPos(x, y, z);
                    FluidStack fluidStack = tank.getFluid();
                    if (world.func_180495_p(newPos).func_227032_a_(tank.getFluid().getFluid()) && fluidStack.getFluid().getAttributes().canBePlacedInWorld((IBlockDisplayReader)world, newPos, fluidStack)) {
                        boolean flag;
                        Material material = world.func_180495_p(newPos).func_185904_a();
                        boolean bl = flag = !material.func_76220_a();
                        if (world.func_230315_m_().func_236040_e_() && fluidStack.getFluid().func_207185_a((ITag)FluidTags.field_206959_a)) {
                            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            inv.markTankDirty();
                            world.func_184133_a(null, newPos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                            int i = 0;
                            if (i < 3) {
                                double d0 = (double)newPos.func_177958_n() + world.field_73012_v.nextDouble();
                                double d1 = (double)newPos.func_177956_o() + world.field_73012_v.nextDouble() * 0.5 + 0.5;
                                double d2 = (double)newPos.func_177952_p() + world.field_73012_v.nextDouble();
                                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
                                return ActionResultType.SUCCESS;
                            }
                        }
                        if (fluidStack.getAmount() >= 1000) {
                            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                                world.func_175655_b(newPos, false);
                            }
                            if (world.func_175656_a(newPos, fluidStack.getFluid().func_207188_f().func_206883_i())) {
                                tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                                world.func_195593_d(newPos, fluidStack.getFluid().func_207188_f().func_206883_i().func_177230_c());
                            }
                            world.func_184133_a(player, newPos, fluidStack.getFluid().getAttributes().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            inv.markTankDirty();
                            return ActionResultType.SUCCESS;
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 3 && !tank.isEmpty() && EffectFluidRegistry.hasFluidEffectAndCanExecute(tank.getFluid(), world, (Entity)player)) {
                player.func_184598_c(Hand.MAIN_HAND);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        PlayerEntity player;
        if (entityLiving instanceof PlayerEntity && CapabilityUtils.isWearingBackpack(player = (PlayerEntity)entityLiving)) {
            TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
            FluidTank tank = this.getSelectedFluidTank(stack, inv);
            if (HoseItem.getHoseMode(stack) == 3 && tank != null && ServerActions.setFluidEffect(worldIn, player, tank)) {
                EffectFluid targetEffect = EffectFluidRegistry.getFluidEffect(tank.getFluid().getFluid());
                tank.drain(targetEffect.amountRequired, IFluidHandler.FluidAction.EXECUTE);
                inv.markTankDirty();
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (CapabilityUtils.isWearingBackpack(playerIn) && handIn == Hand.MAIN_HAND) {
            if (stack.func_77978_p() == null) {
                this.getCompoundTag(stack);
                return ActionResult.func_226250_c_((Object)stack);
            }
            FluidTank tank = this.getSelectedFluidTank(stack, CapabilityUtils.getBackpackInv(playerIn));
            if (HoseItem.getHoseMode(stack) == 3 && !tank.isEmpty() && tank.getFluidAmount() >= 1000 && EffectFluidRegistry.hasFluidEffect(tank.getFluid().getFluid())) {
                playerIn.func_184598_c(Hand.MAIN_HAND);
                return ActionResult.func_226248_a_((Object)stack);
            }
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public static int getHoseMode(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74762_e("Mode");
        }
        return 0;
    }

    public static int getHoseTank(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74762_e("Tank");
        }
        return 0;
    }

    public FluidTank getSelectedFluidTank(ItemStack stack, TravelersBackpackInventory inv) {
        return HoseItem.getHoseTank(stack) == 1 ? inv.getLeftTank() : inv.getRightTank();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity && !CapabilityUtils.isWearingBackpack((PlayerEntity)entityIn) && stack.func_77978_p() != null) {
            stack.func_77982_d(null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (HoseItem.getHoseMode(stack) == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("hose.travelersbackpack.not_assigned").func_240699_a_(TextFormatting.BLUE));
        } else if (stack.func_77978_p() != null) {
            CompoundNBT compound = stack.func_77978_p();
            if (compound.func_74762_e("Mode") == 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.travelersbackpack.current_mode_suck").func_240699_a_(TextFormatting.BLUE));
            }
            if (compound.func_74762_e("Mode") == 2) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.travelersbackpack.current_mode_spill").func_240699_a_(TextFormatting.BLUE));
            }
            if (compound.func_74762_e("Mode") == 3) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.travelersbackpack.current_mode_drink").func_240699_a_(TextFormatting.BLUE));
            }
            if (compound.func_74762_e("Tank") == 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.travelersbackpack.current_tank_left").func_240699_a_(TextFormatting.BLUE));
            }
            if (compound.func_74762_e("Tank") == 2) {
                tooltip.add((ITextComponent)new TranslationTextComponent("hose.travelersbackpack.current_tank_right").func_240699_a_(TextFormatting.BLUE));
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        int x = HoseItem.getHoseMode(stack);
        String mode = "";
        String localizedName = new TranslationTextComponent("item.travelersbackpack.hose").getString();
        String suckMode = new TranslationTextComponent("item.travelersbackpack.hose.suck").getString();
        String spillMode = new TranslationTextComponent("item.travelersbackpack.hose.spill").getString();
        String drinkMode = new TranslationTextComponent("item.travelersbackpack.hose.drink").getString();
        if (x == 1) {
            mode = " " + suckMode;
        } else if (x == 2) {
            mode = " " + spillMode;
        } else if (x == 3) {
            mode = " " + drinkMode;
        }
        return new StringTextComponent(localizedName + mode);
    }

    public CompoundNBT getCompoundTag(ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (!(tag = stack.func_77978_p()).func_186855_b("Tank")) {
            tag.func_74768_a("Tank", 1);
        }
        if (!tag.func_186855_b("Mode")) {
            tag.func_74768_a("Mode", 1);
        }
        return tag;
    }
}

