/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio;

import info.u_team.voice_chat.audio_client.api.NoExceptionCloseable;
import info.u_team.voice_chat.audio_client.micro.MicroData;
import info.u_team.voice_chat.audio_client.micro.MicroRecorder;
import info.u_team.voice_chat.client.TalkingManager;
import info.u_team.voice_chat.client.VoiceClientManager;
import info.u_team.voice_chat.config.ClientConfig;
import info.u_team.voice_chat.packet.message.VoiceToServerPacket;
import net.minecraft.client.Minecraft;

public class MicroHandler
implements NoExceptionCloseable {
    private final ClientConfig config = ClientConfig.getInstance();
    private final MicroData data;
    private final MicroRecorder recorder;

    public MicroHandler() {
        this.data = new MicroData((String)this.config.microphoneValue.get(), (Integer)this.config.microphoneVolumeValue.get());
        this.recorder = new MicroRecorder(this.data, this::sendVoicePacket, (Integer)this.config.bitrateValue.get());
    }

    protected void sendVoicePacket(byte[] opusPacket) {
        if (VoiceClientManager.isRunning()) {
            VoiceClientManager.getClient().send(new VoiceToServerPacket(opusPacket));
            TalkingManager.addOrUpdate(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        }
    }

    public void start() {
        this.recorder.start();
    }

    public void stop() {
        this.recorder.stop();
    }

    public boolean isSending() {
        return this.recorder.isSending();
    }

    public String getMicro() {
        return this.data.getMixer();
    }

    public void setMicro(String mixer) {
        this.data.setMixer(mixer);
        this.config.microphoneValue.set((Object)mixer);
        ClientConfig.CONFIG.save();
    }

    public int getVolume() {
        return this.data.getVolume();
    }

    public void setVolume(int volume) {
        this.data.setVolume(volume);
        this.config.microphoneVolumeValue.set((Object)volume);
        ClientConfig.CONFIG.save();
    }

    @Override
    public void close() {
        this.recorder.close();
        this.data.close();
    }
}

