/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio_client.micro;

import info.u_team.voice_chat.audio_client.api.NoExceptionCloseable;
import info.u_team.voice_chat.audio_client.api.opus.IOpusEncoder;
import info.u_team.voice_chat.audio_client.micro.MicroData;
import info.u_team.voice_chat.audio_client.opus.PcmOpusEncoder;
import info.u_team.voice_chat.audio_client.util.ThreadUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class MicroRecorder
implements NoExceptionCloseable {
    private final ExecutorService executor = Executors.newSingleThreadExecutor(ThreadUtil.createDaemonFactory("micro recorder"));
    private final MicroData microData;
    private final Consumer<byte[]> opusPacketConsumer;
    private final IOpusEncoder encoder;
    private volatile boolean send;

    public MicroRecorder(MicroData microData, Consumer<byte[]> opusPacketConsumer, int bitrate) {
        this.microData = microData;
        this.opusPacketConsumer = opusPacketConsumer;
        this.encoder = new PcmOpusEncoder(48000, 2, 20, bitrate, 3001, 1000);
    }

    public void start() {
        if (this.send || !this.microData.isAvailable()) {
            return;
        }
        this.send = true;
        this.executor.execute(() -> {
            byte[] buffer = new byte[3840];
            while (this.send && this.microData.isAvailable()) {
                this.opusPacketConsumer.accept(this.encoder.encode(this.microData.read(buffer)));
            }
            ThreadUtil.execute(5, 20, () -> this.opusPacketConsumer.accept(this.encoder.silence()));
        });
    }

    public void stop() {
        this.send = false;
        this.microData.flush();
    }

    public boolean isSending() {
        return this.send;
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.encoder.close();
    }
}

