/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio_client.opus;

import info.u_team.voice_chat.audio_client.api.opus.IOpusDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.opus.Opus;

public class PcmOpusDecoder
implements IOpusDecoder {
    private final int frameSize;
    private final long instance;
    private final ByteBuffer inputBuffer;
    private final ByteBuffer outputBuffer;
    private final ShortBuffer outputShortBuffer;

    public PcmOpusDecoder(int sampleRate, int channel, int milliseconds, int bufferSize) {
        this.frameSize = sampleRate / (1000 / milliseconds);
        this.instance = Opus.opus_decoder_create((int)sampleRate, (int)channel, null);
        this.inputBuffer = MemoryUtil.memCalloc((int)bufferSize);
        this.outputBuffer = MemoryUtil.memCalloc((int)(this.frameSize * channel * 2));
        this.outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.outputShortBuffer = this.outputBuffer.asShortBuffer();
        this.inputBuffer.mark();
        this.outputBuffer.mark();
        this.outputShortBuffer.mark();
    }

    @Override
    public byte[] decoder(byte[] opus) {
        this.inputBuffer.reset();
        this.outputBuffer.reset();
        this.outputShortBuffer.reset();
        this.inputBuffer.limit(opus.length);
        this.inputBuffer.put(opus);
        this.inputBuffer.reset();
        Opus.opus_decode((long)this.instance, (ByteBuffer)this.inputBuffer, (ShortBuffer)this.outputShortBuffer, (int)this.frameSize, (int)0);
        byte[] buffer = new byte[this.outputBuffer.capacity()];
        this.outputBuffer.get(buffer);
        return buffer;
    }

    @Override
    public void close() {
        Opus.opus_decoder_destroy((long)this.instance);
        MemoryUtil.memFree((Buffer)this.inputBuffer);
        MemoryUtil.memFree((Buffer)this.outputBuffer);
    }
}

