/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio_client.speaker;

import info.u_team.voice_chat.audio_client.api.NoExceptionCloseable;
import info.u_team.voice_chat.audio_client.speaker.SpeakerLineInfo;
import info.u_team.voice_chat.audio_client.util.AudioUtil;
import info.u_team.voice_chat.audio_client.util.ThreadUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class SpeakerData
implements NoExceptionCloseable {
    public static final AudioFormat FORMAT = new AudioFormat(48000.0f, 16, 2, true, false);
    public static final DataLine.Info SPEAKER_INFO = new DataLine.Info(SourceDataLine.class, FORMAT);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(ThreadUtil.createDaemonFactory("speaker data cleanup"));
    private Mixer mixer;
    private final Map<Integer, SpeakerLineInfo> sourceLines = new ConcurrentHashMap<Integer, SpeakerLineInfo>();
    private int volume;
    private final ScheduledFuture<?> cleanupTask;

    public SpeakerData(String speakerName, int volume) {
        this.setMixer(speakerName);
        this.setVolume(volume);
        this.cleanupTask = this.executor.scheduleWithFixedDelay(() -> {
            long currentTime = System.currentTimeMillis();
            this.sourceLines.forEach((id, lineInfo) -> {
                if (currentTime - lineInfo.getLastAccessed() > 30000L) {
                    this.closeLine(this.sourceLines.remove(id));
                }
            });
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    private boolean createLine(int id) {
        if (this.mixer != null) {
            try {
                SourceDataLine line = (SourceDataLine)this.mixer.getLine(SPEAKER_INFO);
                line.open(FORMAT, 15360);
                line.start();
                SpeakerLineInfo lineInfo = new SpeakerLineInfo(line);
                lineInfo.setMasterVolume(this.volume);
                this.sourceLines.put(id, lineInfo);
                return true;
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
        }
        return false;
    }

    private void closeLine(SpeakerLineInfo lineInfo) {
        SourceDataLine line = lineInfo.getSourceDataLine();
        line.flush();
        line.stop();
        line.close();
    }

    public String getMixer() {
        if (this.mixer != null) {
            return this.mixer.getMixerInfo().getName();
        }
        return null;
    }

    public void setMixer(String name) {
        if (this.mixer != null && this.mixer.getMixerInfo().getName().equals(name)) {
            return;
        }
        Mixer oldMixer = this.mixer;
        this.mixer = AudioUtil.findMixer(name, SPEAKER_INFO);
        this.sourceLines.values().forEach(this::closeLine);
        this.sourceLines.clear();
        if (oldMixer != null && !AudioUtil.hasLinesOpen(oldMixer)) {
            oldMixer.close();
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
        this.sourceLines.values().stream().forEach(lineInfo -> lineInfo.setMasterVolume(volume));
    }

    public boolean isAvailable(int id) {
        if (this.mixer != null) {
            SpeakerLineInfo lineInfo = this.sourceLines.get(id);
            if (lineInfo != null) {
                return lineInfo.getSourceDataLine().isOpen();
            }
            return this.createLine(id);
        }
        return false;
    }

    public void flush(int id) {
        if (this.isAvailable(id)) {
            this.sourceLines.get(id).getSourceDataLine().flush();
        }
    }

    public byte[] write(int id, byte[] array) {
        if (this.isAvailable(id)) {
            SpeakerLineInfo lineInfo = this.sourceLines.get(id);
            if (!lineInfo.isMasterVolumeControlFound()) {
                AudioUtil.changeVolume(array, this.volume, lineInfo.getMultiplier());
            }
            lineInfo.getSourceDataLine().write(array, 0, array.length);
        }
        return array;
    }

    public int freeBuffer(int id) {
        if (this.isAvailable(id)) {
            return this.sourceLines.get(id).getSourceDataLine().available();
        }
        return 0;
    }

    @Override
    public void close() {
        this.cleanupTask.cancel(false);
        this.executor.shutdown();
        this.sourceLines.values().forEach(this::closeLine);
        this.sourceLines.clear();
        if (this.mixer != null && !AudioUtil.hasLinesOpen(this.mixer)) {
            this.mixer.close();
        }
    }
}

