/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio_client.speaker;

import info.u_team.voice_chat.audio_client.util.AudioUtil;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class SpeakerLineInfo {
    private final SourceDataLine line;
    private long lastAccessed;
    private boolean masterVolumeControlFound;
    private int multiplier;

    public SpeakerLineInfo(SourceDataLine line) {
        this.line = line;
        this.lastAccessed = System.currentTimeMillis();
    }

    public void setMasterVolume(int volume) {
        if (this.line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            ((FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN)).setValue(20.0f * (float)Math.log10((float)volume / 100.0f));
            this.masterVolumeControlFound = true;
        } else {
            this.multiplier = AudioUtil.calculateVolumeMultiplier(volume);
        }
    }

    public SourceDataLine getSourceDataLine() {
        this.lastAccessed = System.currentTimeMillis();
        return this.line;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public boolean isMasterVolumeControlFound() {
        return this.masterVolumeControlFound;
    }

    public int getMultiplier() {
        return this.multiplier;
    }
}

