/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio_client.speaker;

import info.u_team.voice_chat.audio_client.api.NoExceptionCloseable;
import info.u_team.voice_chat.audio_client.speaker.SpeakerBufferPusher;
import info.u_team.voice_chat.audio_client.speaker.SpeakerData;
import info.u_team.voice_chat.audio_client.util.ThreadUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SpeakerPlayer
implements NoExceptionCloseable {
    private final ExecutorService executor = Executors.newCachedThreadPool(ThreadUtil.createDaemonFactory("speaker player"));
    private final SpeakerData speakerData;
    private final Map<Integer, SpeakerBufferPusher> bufferMap;

    public SpeakerPlayer(SpeakerData speakerData) {
        this.speakerData = speakerData;
        this.bufferMap = new HashMap<Integer, SpeakerBufferPusher>();
    }

    public void accept(int id, byte[] opusPacket) {
        if (this.speakerData.isAvailable(id)) {
            this.bufferMap.computeIfAbsent(id, $ -> new SpeakerBufferPusher(this.executor, id, this.speakerData)).decodeAndPushPacket(opusPacket);
        }
    }

    @Override
    public void close() {
        this.bufferMap.values().forEach(SpeakerBufferPusher::close);
        this.bufferMap.clear();
        this.executor.shutdown();
    }
}

