/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio_client.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;

public class AudioUtil {
    public static Mixer findMixer(String name, Line.Info lineInfo) {
        Mixer defaultMixer = null;
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo)) continue;
            if (mixerInfo.getName().equals(name)) {
                return mixer;
            }
            if (defaultMixer != null) continue;
            defaultMixer = mixer;
        }
        return defaultMixer;
    }

    public static List<String> findAudioDevices(Line.Info lineInfo) {
        ArrayList<String> list = new ArrayList<String>();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo)) continue;
            list.add(mixerInfo.getName());
        }
        return list;
    }

    public static boolean hasLinesOpen(Mixer mixer) {
        return mixer.getSourceLines().length != 0 || mixer.getTargetLines().length != 0;
    }

    public static int calculateVolumeMultiplier(int volume) {
        return (int)((float)Math.tan((float)volume * 0.0079f) * 10000.0f);
    }

    public static void changeVolume(byte[] pcm, int volume, int multiplier) {
        if (volume == 100) {
            return;
        }
        AudioUtil.changeVolume(pcm, multiplier);
    }

    public static void changeVolume(byte[] pcm, int multiplier) {
        ShortBuffer buffer = ByteBuffer.wrap(pcm).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        for (int index = buffer.position(); index < buffer.limit(); ++index) {
            buffer.put(index, (short)Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, buffer.get(index) * multiplier / 10000)));
        }
    }
}

