/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.client;

import info.u_team.voice_chat.api.IIntegration;
import info.u_team.voice_chat.audio.MicroManager;
import info.u_team.voice_chat.audio.SpeakerManager;
import info.u_team.voice_chat.client.PlayerIDManager;
import info.u_team.voice_chat.client.TalkingManager;
import info.u_team.voice_chat.client.VoiceClientManager;
import info.u_team.voice_chat.init.VoiceChatIntegrations;
import info.u_team.voice_chat.init.VoiceChatKeys;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="voicechat", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    @SubscribeEvent
    public static void logout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (MicroManager.isRunning()) {
            MicroManager.stop();
        }
        if (SpeakerManager.isRunning()) {
            SpeakerManager.stop();
        }
        if (VoiceClientManager.isRunning()) {
            VoiceClientManager.stop();
        }
        if (TalkingManager.isRunning()) {
            TalkingManager.stop();
        }
        VoiceChatIntegrations.INTEGRATIONS.forEach(IIntegration::stop);
        PlayerIDManager.clear();
    }

    @SubscribeEvent
    public static void keyPress(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (VoiceChatKeys.PUSH_TALK.func_151470_d()) {
                if (MicroManager.isRunning() && !MicroManager.getHandler().isSending()) {
                    MicroManager.getHandler().start();
                }
            } else if (MicroManager.isRunning() && MicroManager.getHandler().isSending()) {
                MicroManager.getHandler().stop();
            }
        }
    }
}

