/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.client;

import info.u_team.voice_chat.audio_client.util.ThreadUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TalkingManager {
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor(ThreadUtil.createDaemonFactory("talking manager cleanup"));
    private static final Map<UUID, Long> MAP = new ConcurrentHashMap<UUID, Long>();
    private static Future<?> TASK;

    public static synchronized void addOrUpdate(UUID uuid) {
        MAP.put(uuid, System.currentTimeMillis());
    }

    public static synchronized void removeAllThatAreInactiveFor200ms() {
        long currentTime = System.currentTimeMillis();
        MAP.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 200L);
    }

    public static Set<UUID> getTalkers() {
        return Collections.unmodifiableSet(MAP.keySet());
    }

    public static synchronized void clear() {
        MAP.clear();
    }

    public static synchronized void start() {
        TASK = EXECUTOR.scheduleWithFixedDelay(TalkingManager::removeAllThatAreInactiveFor200ms, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public static synchronized void stop() {
        TalkingManager.clear();
        if (TASK != null) {
            TASK.cancel(true);
            TASK = null;
        }
    }

    public static boolean isRunning() {
        return TASK != null;
    }
}

