/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.client;

import info.u_team.voice_chat.packet.PacketRegistry;
import info.u_team.voice_chat.packet.message.HandshakePacket;
import info.u_team.voice_chat.util.NetworkUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class VoiceClient {
    private final DatagramSocket socket;
    private final InetSocketAddress serverAddress;
    private final byte[] secret;
    private volatile boolean handshakeMode;
    private final Future<?> handshakeTask;
    private final Future<?> task;

    public VoiceClient(ExecutorService service, int port, byte[] secret) throws SocketException {
        this.secret = Arrays.copyOf(secret, secret.length);
        this.socket = new DatagramSocket();
        this.serverAddress = NetworkUtil.findServerInetAddress(port);
        this.handshakeMode = true;
        this.handshakeTask = service.submit(() -> {
            while (!Thread.currentThread().isInterrupted() && this.handshakeMode) {
                try {
                    System.out.println("SEND HANDSHAKE PACKET");
                    this.sendIntern(new HandshakePacket());
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        });
        this.task = service.submit(() -> {
            while (!Thread.currentThread().isInterrupted() && !this.socket.isClosed()) {
                try {
                    DatagramPacket packet = new DatagramPacket(new byte[1002], 1002);
                    this.socket.receive(packet);
                    if (packet.getLength() < 1) {
                        return;
                    }
                    Object message = PacketRegistry.decode(packet.getData(), packet.getLength());
                    if (message == null) continue;
                    PacketRegistry.handle(message, PacketRegistry.Context.Sender.SERVER, (InetSocketAddress)packet.getSocketAddress());
                }
                catch (IOException ex) {
                    if (this.socket.isClosed()) continue;
                    ex.printStackTrace();
                }
            }
        });
    }

    public <MSG> void send(MSG message) {
        if (this.handshakeTask.isDone()) {
            this.sendIntern(message);
        }
    }

    private <MSG> void sendIntern(MSG message) {
        block2: {
            byte[] data = PacketRegistry.encode(message);
            ByteBuffer buffer = ByteBuffer.allocate(8 + data.length);
            buffer.put(this.secret);
            buffer.put(data);
            try {
                this.socket.send(new DatagramPacket(buffer.array(), buffer.capacity(), this.serverAddress));
            }
            catch (IOException ex) {
                if (this.socket.isClosed()) break block2;
                ex.printStackTrace();
            }
        }
    }

    public void close() {
        this.socket.close();
        this.handshakeTask.cancel(true);
        this.handshakeMode = false;
        this.task.cancel(true);
    }

    public void setHandshakeDone() {
        this.handshakeTask.cancel(true);
        this.handshakeMode = false;
        System.out.println("--------------------------------------------- Handshake done ---------------------------------------------");
    }
}

