/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.dependency;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class DependencyManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"Load");

    public static void construct() {
        LOGGER.info(MARKER, "Load dependencies");
        String devPath = System.getProperty("voicechat.dev");
        if (devPath == null) {
            DependencyManager.findJarFilesInJar("dependencies/internal", path -> DependencyManager.addToInternalDependencies(DependencyManager.createInternalURL(path)));
        }
        LOGGER.info(MARKER, "Finished loading dependencies");
    }

    private static void findJarFilesInJar(String folder, Consumer<Path> consumer) {
        ModFile modfile = ModList.get().getModFileById("voicechat").getFile();
        try (Stream<Path> stream = Files.walk(modfile.findResource("/" + folder), new FileVisitOption[0]);){
            stream.filter(file -> file.toString().endsWith(".jar")).forEach(consumer);
        }
        catch (IOException ex) {
            LOGGER.error(MARKER, "When searching for jar files in jar an exception occured.", (Throwable)ex);
        }
    }

    private static URL createInternalURL(Path path) {
        String url = "modjar://voicechat" + path;
        LOGGER.debug(MARKER, "Load url" + url);
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            LOGGER.error(MARKER, "Could not create url from internal path", (Throwable)ex);
            return null;
        }
    }

    private static void addToInternalDependencies(URL url) {
        try {
            URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)systemClassLoader, url);
        }
        catch (Exception ex) {
            LOGGER.error(MARKER, "Method addURL on system classloader could not be invoked", (Throwable)ex);
        }
    }
}

