/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.musicplayer_integration.message;

import info.u_team.voice_chat.musicplayer_integration.message.MusicToClientPacket;
import info.u_team.voice_chat.packet.PacketRegistry;
import info.u_team.voice_chat.server.VerifiedPlayerManager;
import info.u_team.voice_chat.server.VoiceServerManager;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;

public class MusicToServerPacket {
    private final byte[] opusPacket;

    public MusicToServerPacket(byte[] opusPacket) {
        this.opusPacket = opusPacket;
    }

    public static ByteBuffer encode(MusicToServerPacket message) {
        return ByteBuffer.wrap(message.opusPacket);
    }

    public static MusicToServerPacket decode(ByteBuffer buffer) {
        return new MusicToServerPacket(buffer.array());
    }

    public static class Handler {
        public static void handle(MusicToServerPacket message, Supplier<PacketRegistry.Context> contextSupplier) {
            PacketRegistry.Context context = contextSupplier.get();
            if (!context.hasPlayer()) {
                return;
            }
            ServerPlayerEntity player = context.getPlayer();
            VerifiedPlayerManager.PlayerData playerData = VerifiedPlayerManager.getPlayerData(player);
            if (playerData == null) {
                return;
            }
            VoiceServerManager.getServer().sendAllExcept(new MusicToClientPacket(playerData.getId(), message.opusPacket), player);
        }
    }
}

